// BASE_WCL.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "base_wcl.h"

#include "base_app.h"
#include <stdlib.h>	// the definition for NULL...

#include <GL/glut.h>

/*################################################################################################*/

base_wcl::base_wcl(ogl_camera * c)
{
	wnd = NULL;
	
	cam = c;
	delete_cam_plz = false;
	cam->RegisterClient(this);
	
	if (!cam->update_vdim)
	{
		vdim[0] = 1.0;	// just set some default values here...
		vdim[1] = 1.0;	// just set some default values here...
	}
	
	title = NULL;
}

base_wcl::~base_wcl(void)
{
	if (wnd != NULL)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wcl::wnd memleak!");
	}
	
	cam->UnregisterClient(this);
	
	if (delete_cam_plz)
	{
		delete cam;
		cam = NULL;
	}
	
	if (title != NULL)
	{
		delete[] title;
		title = NULL;
	}
}

base_wnd * base_wcl::GetWnd(void)
{
	return wnd;
}

ogl_camera * base_wcl::GetCam(void)
{
	return cam;
}

void base_wcl::LinkWnd(base_wnd * w)
{
	if (wnd != NULL)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wcl::LinkWnd() : wnd already in use!");
	}
	
	if (w->wcl != NULL)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wcl::LinkWnd() : link overwrite!");
	}
	
	w->wcl = this;
	wnd = w;
	
	cam->RegisterWnd(wnd);
	
	// if the window is realized (so that SetCurrent() may be called)
	// but is not initialized yet, then do the initialization...
	
	if (w->is_realized && !w->is_initialized)
	{
		w->is_initialized = true;
		
		w->SetCurrent();
		w->GetClient()->InitGL();
		w->RequestUpdate(false);
	}
	
	// if we have a title available, then ask the window to show it...
	
	if (title != NULL) w->TitleChanged();
}

void base_wcl::UnlinkWnd(void)
{
	if (!wnd)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wcl::UnlinkWnd() : wnd is already NULL!");
	}
	
	if (wnd->wcl == NULL)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wcl::UnlinkWnd() : wcl is already NULL!");
	}
	
	cam->UnregisterWnd(wnd);
	
	wnd->wcl = NULL;
	wnd = NULL;
}

const char * base_wcl::GetTitle(void)
{
	return (const char *) title;
}

void base_wcl::SetTitle(const char * t)
{
	if (t == NULL)
	{
		cout << "ERROR : base_wcl::SetTitle() got NULL." << endl;
		exit(EXIT_FAILURE);
	}
	
	if (title != NULL)
	{
		delete[] title;
		title = NULL;
	}
	
	title = new char[strlen(t) + 1];
	strcpy(title, t);
	
	if (wnd != NULL) wnd->TitleChanged();
}

// 2001-12-28 : tried to add support for both bitmap and line-based fonts but it's not ready yet.
// the font scaling and even orientation seems to be very different... there seems to be in use
// some versions of GLUT that lack the bitmap fonts and related functions. hopefully there remains
// at least some sane way to render text using OpenGL/GLUT; at the moment the support for line
// fonts here isveeery broken...  :(

// 2001-12-29 : the line fonts are now more or less readable everywhere, but 3D text still is
// not correctly aligned...

const GLfloat stroke_font_scale = 0.1;

int base_wcl::ogl_GetGlutStringWidth(const char * str, void * font)
{
//font = NULL;	// uncomment this to try the line fonts...
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	bool use_bitmap_font = (font != NULL ? true : false);
	
	unsigned int count = 0; int width = 0;
	while (count < strlen(str))
	{
		if (use_bitmap_font) width += glutBitmapWidth(font, str[count++]);
		else width += glutStrokeWidth(GLUT_STROKE_ROMAN, str[count++]);
	}
	
	if (!use_bitmap_font) width = (int) (width * stroke_font_scale);
	return width;
}

void base_wcl::ogl_WriteGlutString2D(const char * str, GLfloat x, GLfloat y, void * font)
{
	glPushMatrix();
	glLoadIdentity();
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix(); glLoadIdentity();
	gluOrtho2D(0, GetWnd()->GetWidth(), 0, GetWnd()->GetHeight());
	
	ogl_WriteGlutString3D(str, x, y, 0.0, NULL, font);
	
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	
	glPopMatrix();
}

void base_wcl::ogl_WriteGlutString3D(const char * str, GLfloat x, GLfloat y, GLfloat z, const ogl_obj_loc_data * eye, void * font)
{
//font = NULL;	// uncomment this to try the line fonts...
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	bool use_bitmap_font = (font != NULL ? true : false);
	
	// text centering?!?!?! add a new flag???
	// text centering?!?!?! add a new flag???
	// text centering?!?!?! add a new flag???
	
	if (use_bitmap_font)
	{
		glDisable(GL_DEPTH_TEST);
		
		glRasterPos3f(x, y, z);
		
		unsigned int count = 0;
		while (count < strlen(str))
		{
			glutBitmapCharacter(font, str[count++]);
		}
		
		glEnable(GL_DEPTH_TEST);
	}
	else
	{
		glDisable(GL_DEPTH_TEST);
		
		glPushMatrix();
		glTranslatef(x, y, z);
		
	// here the text should be oriented to the "eye" coordinates if they are given...
	// it's possible but tricky; something similar than in SetModelView() at objects.cpp
		
		GLfloat font_scale = stroke_font_scale;		// the 2D and 3D texts must be scaled very
		if (eye != NULL) font_scale /= 500.0;		// differently; detect 3D cases by "eye"...
		glScalef(font_scale, font_scale, font_scale);	// GetGlutStringWidth() is not scaled!!!
		
		unsigned int count = 0;
		while (count < strlen(str))
		{
			glutStrokeCharacter(GLUT_STROKE_ROMAN, str[count++]);
		}
		
		glPopMatrix();
		glEnable(GL_DEPTH_TEST);
	}
}

/*################################################################################################*/

// eof
