/* soapC.cpp
   Generated by gSOAP 2.7.6e from InstrudeoService.h
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.6e 2006-04-11 00:06:57 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE__isdxsd__ftpUploadDoneResponse:
		return soap_in__isdxsd__ftpUploadDoneResponse(soap, NULL, NULL, "isdxsd:ftpUploadDoneResponse");
	case SOAP_TYPE__isdxsd__ftpUploadDoneRequest:
		return soap_in__isdxsd__ftpUploadDoneRequest(soap, NULL, NULL, "isdxsd:ftpUploadDoneRequest");
	case SOAP_TYPE__isdxsd__newFtpPathResponse:
		return soap_in__isdxsd__newFtpPathResponse(soap, NULL, NULL, "isdxsd:newFtpPathResponse");
	case SOAP_TYPE__isdxsd__newFtpPathRequest:
		return soap_in__isdxsd__newFtpPathRequest(soap, NULL, NULL, "isdxsd:newFtpPathRequest");
	case SOAP_TYPE__isdxsd__availableCategoriesResponse:
		return soap_in__isdxsd__availableCategoriesResponse(soap, NULL, NULL, "isdxsd:availableCategoriesResponse");
	case SOAP_TYPE__isdxsd__availableCategoriesRequest:
		return soap_in__isdxsd__availableCategoriesRequest(soap, NULL, NULL, "isdxsd:availableCategoriesRequest");
	case SOAP_TYPE__isdxsd__availablePlatformsResponse:
		return soap_in__isdxsd__availablePlatformsResponse(soap, NULL, NULL, "isdxsd:availablePlatformsResponse");
	case SOAP_TYPE__isdxsd__availablePlatformsRequest:
		return soap_in__isdxsd__availablePlatformsRequest(soap, NULL, NULL, "isdxsd:availablePlatformsRequest");
	case SOAP_TYPE_isdxsd__CategoryArray:
		return soap_in_isdxsd__CategoryArray(soap, NULL, NULL, "isdxsd:CategoryArray");
	case SOAP_TYPE_isdxsd__Category:
		return soap_in_isdxsd__Category(soap, NULL, NULL, "isdxsd:Category");
	case SOAP_TYPE_isdxsd__PlatformArray:
		return soap_in_isdxsd__PlatformArray(soap, NULL, NULL, "isdxsd:PlatformArray");
	case SOAP_TYPE_isdxsd__Platform:
		return soap_in_isdxsd__Platform(soap, NULL, NULL, "isdxsd:Platform");
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneResponse:
		return soap_in_PointerTo_isdxsd__ftpUploadDoneResponse(soap, NULL, NULL, "isdxsd:ftpUploadDoneResponse");
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneRequest:
		return soap_in_PointerTo_isdxsd__ftpUploadDoneRequest(soap, NULL, NULL, "isdxsd:ftpUploadDoneRequest");
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathResponse:
		return soap_in_PointerTo_isdxsd__newFtpPathResponse(soap, NULL, NULL, "isdxsd:newFtpPathResponse");
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathRequest:
		return soap_in_PointerTo_isdxsd__newFtpPathRequest(soap, NULL, NULL, "isdxsd:newFtpPathRequest");
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesResponse:
		return soap_in_PointerTo_isdxsd__availableCategoriesResponse(soap, NULL, NULL, "isdxsd:availableCategoriesResponse");
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesRequest:
		return soap_in_PointerTo_isdxsd__availableCategoriesRequest(soap, NULL, NULL, "isdxsd:availableCategoriesRequest");
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsResponse:
		return soap_in_PointerTo_isdxsd__availablePlatformsResponse(soap, NULL, NULL, "isdxsd:availablePlatformsResponse");
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsRequest:
		return soap_in_PointerTo_isdxsd__availablePlatformsRequest(soap, NULL, NULL, "isdxsd:availablePlatformsRequest");
	case SOAP_TYPE_PointerToisdxsd__CategoryArray:
		return soap_in_PointerToisdxsd__CategoryArray(soap, NULL, NULL, "isdxsd:CategoryArray");
	case SOAP_TYPE_PointerToisdxsd__PlatformArray:
		return soap_in_PointerToisdxsd__PlatformArray(soap, NULL, NULL, "isdxsd:PlatformArray");
	case SOAP_TYPE_PointerToisdxsd__Category:
		return soap_in_PointerToisdxsd__Category(soap, NULL, NULL, "isdxsd:Category");
	case SOAP_TYPE_PointerToisdxsd__Platform:
		return soap_in_PointerToisdxsd__Platform(soap, NULL, NULL, "isdxsd:Platform");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:ftpUploadDoneResponse"))
		{	*type = SOAP_TYPE__isdxsd__ftpUploadDoneResponse;
			return soap_in__isdxsd__ftpUploadDoneResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:ftpUploadDoneRequest"))
		{	*type = SOAP_TYPE__isdxsd__ftpUploadDoneRequest;
			return soap_in__isdxsd__ftpUploadDoneRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:newFtpPathResponse"))
		{	*type = SOAP_TYPE__isdxsd__newFtpPathResponse;
			return soap_in__isdxsd__newFtpPathResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:newFtpPathRequest"))
		{	*type = SOAP_TYPE__isdxsd__newFtpPathRequest;
			return soap_in__isdxsd__newFtpPathRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:availableCategoriesResponse"))
		{	*type = SOAP_TYPE__isdxsd__availableCategoriesResponse;
			return soap_in__isdxsd__availableCategoriesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:availableCategoriesRequest"))
		{	*type = SOAP_TYPE__isdxsd__availableCategoriesRequest;
			return soap_in__isdxsd__availableCategoriesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:availablePlatformsResponse"))
		{	*type = SOAP_TYPE__isdxsd__availablePlatformsResponse;
			return soap_in__isdxsd__availablePlatformsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:availablePlatformsRequest"))
		{	*type = SOAP_TYPE__isdxsd__availablePlatformsRequest;
			return soap_in__isdxsd__availablePlatformsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:CategoryArray"))
		{	*type = SOAP_TYPE_isdxsd__CategoryArray;
			return soap_in_isdxsd__CategoryArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:Category"))
		{	*type = SOAP_TYPE_isdxsd__Category;
			return soap_in_isdxsd__Category(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:PlatformArray"))
		{	*type = SOAP_TYPE_isdxsd__PlatformArray;
			return soap_in_isdxsd__PlatformArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "isdxsd:Platform"))
		{	*type = SOAP_TYPE_isdxsd__Platform;
			return soap_in_isdxsd__Platform(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE__isdxsd__ftpUploadDoneResponse:
		return ((_isdxsd__ftpUploadDoneResponse *)ptr)->soap_out(soap, "isdxsd:ftpUploadDoneResponse", id, NULL);
	case SOAP_TYPE__isdxsd__ftpUploadDoneRequest:
		return ((_isdxsd__ftpUploadDoneRequest *)ptr)->soap_out(soap, "isdxsd:ftpUploadDoneRequest", id, NULL);
	case SOAP_TYPE__isdxsd__newFtpPathResponse:
		return ((_isdxsd__newFtpPathResponse *)ptr)->soap_out(soap, "isdxsd:newFtpPathResponse", id, NULL);
	case SOAP_TYPE__isdxsd__newFtpPathRequest:
		return ((_isdxsd__newFtpPathRequest *)ptr)->soap_out(soap, "isdxsd:newFtpPathRequest", id, NULL);
	case SOAP_TYPE__isdxsd__availableCategoriesResponse:
		return ((_isdxsd__availableCategoriesResponse *)ptr)->soap_out(soap, "isdxsd:availableCategoriesResponse", id, NULL);
	case SOAP_TYPE__isdxsd__availableCategoriesRequest:
		return ((_isdxsd__availableCategoriesRequest *)ptr)->soap_out(soap, "isdxsd:availableCategoriesRequest", id, NULL);
	case SOAP_TYPE__isdxsd__availablePlatformsResponse:
		return ((_isdxsd__availablePlatformsResponse *)ptr)->soap_out(soap, "isdxsd:availablePlatformsResponse", id, NULL);
	case SOAP_TYPE__isdxsd__availablePlatformsRequest:
		return ((_isdxsd__availablePlatformsRequest *)ptr)->soap_out(soap, "isdxsd:availablePlatformsRequest", id, NULL);
	case SOAP_TYPE_isdxsd__CategoryArray:
		return ((isdxsd__CategoryArray *)ptr)->soap_out(soap, tag, id, "isdxsd:CategoryArray");
	case SOAP_TYPE_isdxsd__Category:
		return ((isdxsd__Category *)ptr)->soap_out(soap, tag, id, "isdxsd:Category");
	case SOAP_TYPE_isdxsd__PlatformArray:
		return ((isdxsd__PlatformArray *)ptr)->soap_out(soap, tag, id, "isdxsd:PlatformArray");
	case SOAP_TYPE_isdxsd__Platform:
		return ((isdxsd__Platform *)ptr)->soap_out(soap, tag, id, "isdxsd:Platform");
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneResponse:
		return soap_out_PointerTo_isdxsd__ftpUploadDoneResponse(soap, tag, id, (_isdxsd__ftpUploadDoneResponse *const*)ptr, "isdxsd:ftpUploadDoneResponse");
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneRequest:
		return soap_out_PointerTo_isdxsd__ftpUploadDoneRequest(soap, tag, id, (_isdxsd__ftpUploadDoneRequest *const*)ptr, "isdxsd:ftpUploadDoneRequest");
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathResponse:
		return soap_out_PointerTo_isdxsd__newFtpPathResponse(soap, tag, id, (_isdxsd__newFtpPathResponse *const*)ptr, "isdxsd:newFtpPathResponse");
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathRequest:
		return soap_out_PointerTo_isdxsd__newFtpPathRequest(soap, tag, id, (_isdxsd__newFtpPathRequest *const*)ptr, "isdxsd:newFtpPathRequest");
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesResponse:
		return soap_out_PointerTo_isdxsd__availableCategoriesResponse(soap, tag, id, (_isdxsd__availableCategoriesResponse *const*)ptr, "isdxsd:availableCategoriesResponse");
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesRequest:
		return soap_out_PointerTo_isdxsd__availableCategoriesRequest(soap, tag, id, (_isdxsd__availableCategoriesRequest *const*)ptr, "isdxsd:availableCategoriesRequest");
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsResponse:
		return soap_out_PointerTo_isdxsd__availablePlatformsResponse(soap, tag, id, (_isdxsd__availablePlatformsResponse *const*)ptr, "isdxsd:availablePlatformsResponse");
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsRequest:
		return soap_out_PointerTo_isdxsd__availablePlatformsRequest(soap, tag, id, (_isdxsd__availablePlatformsRequest *const*)ptr, "isdxsd:availablePlatformsRequest");
	case SOAP_TYPE_PointerToisdxsd__CategoryArray:
		return soap_out_PointerToisdxsd__CategoryArray(soap, tag, id, (isdxsd__CategoryArray *const*)ptr, "isdxsd:CategoryArray");
	case SOAP_TYPE_PointerToisdxsd__PlatformArray:
		return soap_out_PointerToisdxsd__PlatformArray(soap, tag, id, (isdxsd__PlatformArray *const*)ptr, "isdxsd:PlatformArray");
	case SOAP_TYPE_PointerToisdxsd__Category:
		return soap_out_PointerToisdxsd__Category(soap, tag, id, (isdxsd__Category *const*)ptr, "isdxsd:Category");
	case SOAP_TYPE_PointerToisdxsd__Platform:
		return soap_out_PointerToisdxsd__Platform(soap, tag, id, (isdxsd__Platform *const*)ptr, "isdxsd:Platform");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__isdxsd__ftpUploadDoneResponse:
		((_isdxsd__ftpUploadDoneResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__ftpUploadDoneRequest:
		((_isdxsd__ftpUploadDoneRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__newFtpPathResponse:
		((_isdxsd__newFtpPathResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__newFtpPathRequest:
		((_isdxsd__newFtpPathRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__availableCategoriesResponse:
		((_isdxsd__availableCategoriesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__availableCategoriesRequest:
		((_isdxsd__availableCategoriesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__availablePlatformsResponse:
		((_isdxsd__availablePlatformsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__isdxsd__availablePlatformsRequest:
		((_isdxsd__availablePlatformsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_isdxsd__CategoryArray:
		((isdxsd__CategoryArray *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_isdxsd__Category:
		((isdxsd__Category *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_isdxsd__PlatformArray:
		((isdxsd__PlatformArray *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_isdxsd__Platform:
		((isdxsd__Platform *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___isdws__setFtpUploadDone:
		soap_serialize___isdws__setFtpUploadDone(soap, (const struct __isdws__setFtpUploadDone *)ptr);
		break;
	case SOAP_TYPE___isdws__getNewFtpPath:
		soap_serialize___isdws__getNewFtpPath(soap, (const struct __isdws__getNewFtpPath *)ptr);
		break;
	case SOAP_TYPE___isdws__getAvailableCategories:
		soap_serialize___isdws__getAvailableCategories(soap, (const struct __isdws__getAvailableCategories *)ptr);
		break;
	case SOAP_TYPE___isdws__getAvailablePlatforms:
		soap_serialize___isdws__getAvailablePlatforms(soap, (const struct __isdws__getAvailablePlatforms *)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneResponse:
		soap_serialize_PointerTo_isdxsd__ftpUploadDoneResponse(soap, (_isdxsd__ftpUploadDoneResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneRequest:
		soap_serialize_PointerTo_isdxsd__ftpUploadDoneRequest(soap, (_isdxsd__ftpUploadDoneRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathResponse:
		soap_serialize_PointerTo_isdxsd__newFtpPathResponse(soap, (_isdxsd__newFtpPathResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__newFtpPathRequest:
		soap_serialize_PointerTo_isdxsd__newFtpPathRequest(soap, (_isdxsd__newFtpPathRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesResponse:
		soap_serialize_PointerTo_isdxsd__availableCategoriesResponse(soap, (_isdxsd__availableCategoriesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__availableCategoriesRequest:
		soap_serialize_PointerTo_isdxsd__availableCategoriesRequest(soap, (_isdxsd__availableCategoriesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsResponse:
		soap_serialize_PointerTo_isdxsd__availablePlatformsResponse(soap, (_isdxsd__availablePlatformsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_isdxsd__availablePlatformsRequest:
		soap_serialize_PointerTo_isdxsd__availablePlatformsRequest(soap, (_isdxsd__availablePlatformsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToisdxsd__CategoryArray:
		soap_serialize_PointerToisdxsd__CategoryArray(soap, (isdxsd__CategoryArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerToisdxsd__PlatformArray:
		soap_serialize_PointerToisdxsd__PlatformArray(soap, (isdxsd__PlatformArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerToisdxsd__Category:
		soap_serialize_PointerToisdxsd__Category(soap, (isdxsd__Category *const*)ptr);
		break;
	case SOAP_TYPE_PointerToisdxsd__Platform:
		soap_serialize_PointerToisdxsd__Platform(soap, (isdxsd__Platform *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_isdxsd__Platform:
		return (void*)soap_instantiate_isdxsd__Platform(soap, -1, type, arrayType, n);
	case SOAP_TYPE_isdxsd__PlatformArray:
		return (void*)soap_instantiate_isdxsd__PlatformArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_isdxsd__Category:
		return (void*)soap_instantiate_isdxsd__Category(soap, -1, type, arrayType, n);
	case SOAP_TYPE_isdxsd__CategoryArray:
		return (void*)soap_instantiate_isdxsd__CategoryArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__availablePlatformsRequest:
		return (void*)soap_instantiate__isdxsd__availablePlatformsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__availablePlatformsResponse:
		return (void*)soap_instantiate__isdxsd__availablePlatformsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__availableCategoriesRequest:
		return (void*)soap_instantiate__isdxsd__availableCategoriesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__availableCategoriesResponse:
		return (void*)soap_instantiate__isdxsd__availableCategoriesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__newFtpPathRequest:
		return (void*)soap_instantiate__isdxsd__newFtpPathRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__newFtpPathResponse:
		return (void*)soap_instantiate__isdxsd__newFtpPathResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__ftpUploadDoneRequest:
		return (void*)soap_instantiate__isdxsd__ftpUploadDoneRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__isdxsd__ftpUploadDoneResponse:
		return (void*)soap_instantiate__isdxsd__ftpUploadDoneResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___isdws__getAvailablePlatforms:
		return (void*)soap_instantiate___isdws__getAvailablePlatforms(soap, -1, type, arrayType, n);
	case SOAP_TYPE___isdws__getAvailableCategories:
		return (void*)soap_instantiate___isdws__getAvailableCategories(soap, -1, type, arrayType, n);
	case SOAP_TYPE___isdws__getNewFtpPath:
		return (void*)soap_instantiate___isdws__getNewFtpPath(soap, -1, type, arrayType, n);
	case SOAP_TYPE___isdws__setFtpUploadDone:
		return (void*)soap_instantiate___isdws__setFtpUploadDone(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Category:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Category(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Platform:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Platform(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_isdxsd__Platform:
		if (p->size < 0)
			delete (isdxsd__Platform*)p->ptr;
		else
			delete[] (isdxsd__Platform*)p->ptr;
		break;
	case SOAP_TYPE_isdxsd__PlatformArray:
		if (p->size < 0)
			delete (isdxsd__PlatformArray*)p->ptr;
		else
			delete[] (isdxsd__PlatformArray*)p->ptr;
		break;
	case SOAP_TYPE_isdxsd__Category:
		if (p->size < 0)
			delete (isdxsd__Category*)p->ptr;
		else
			delete[] (isdxsd__Category*)p->ptr;
		break;
	case SOAP_TYPE_isdxsd__CategoryArray:
		if (p->size < 0)
			delete (isdxsd__CategoryArray*)p->ptr;
		else
			delete[] (isdxsd__CategoryArray*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__availablePlatformsRequest:
		if (p->size < 0)
			delete (_isdxsd__availablePlatformsRequest*)p->ptr;
		else
			delete[] (_isdxsd__availablePlatformsRequest*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__availablePlatformsResponse:
		if (p->size < 0)
			delete (_isdxsd__availablePlatformsResponse*)p->ptr;
		else
			delete[] (_isdxsd__availablePlatformsResponse*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__availableCategoriesRequest:
		if (p->size < 0)
			delete (_isdxsd__availableCategoriesRequest*)p->ptr;
		else
			delete[] (_isdxsd__availableCategoriesRequest*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__availableCategoriesResponse:
		if (p->size < 0)
			delete (_isdxsd__availableCategoriesResponse*)p->ptr;
		else
			delete[] (_isdxsd__availableCategoriesResponse*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__newFtpPathRequest:
		if (p->size < 0)
			delete (_isdxsd__newFtpPathRequest*)p->ptr;
		else
			delete[] (_isdxsd__newFtpPathRequest*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__newFtpPathResponse:
		if (p->size < 0)
			delete (_isdxsd__newFtpPathResponse*)p->ptr;
		else
			delete[] (_isdxsd__newFtpPathResponse*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__ftpUploadDoneRequest:
		if (p->size < 0)
			delete (_isdxsd__ftpUploadDoneRequest*)p->ptr;
		else
			delete[] (_isdxsd__ftpUploadDoneRequest*)p->ptr;
		break;
	case SOAP_TYPE__isdxsd__ftpUploadDoneResponse:
		if (p->size < 0)
			delete (_isdxsd__ftpUploadDoneResponse*)p->ptr;
		else
			delete[] (_isdxsd__ftpUploadDoneResponse*)p->ptr;
		break;
	case SOAP_TYPE___isdws__getAvailablePlatforms:
		if (p->size < 0)
			delete (struct __isdws__getAvailablePlatforms*)p->ptr;
		else
			delete[] (struct __isdws__getAvailablePlatforms*)p->ptr;
		break;
	case SOAP_TYPE___isdws__getAvailableCategories:
		if (p->size < 0)
			delete (struct __isdws__getAvailableCategories*)p->ptr;
		else
			delete[] (struct __isdws__getAvailableCategories*)p->ptr;
		break;
	case SOAP_TYPE___isdws__getNewFtpPath:
		if (p->size < 0)
			delete (struct __isdws__getNewFtpPath*)p->ptr;
		else
			delete[] (struct __isdws__getNewFtpPath*)p->ptr;
		break;
	case SOAP_TYPE___isdws__setFtpUploadDone:
		if (p->size < 0)
			delete (struct __isdws__setFtpUploadDone*)p->ptr;
		else
			delete[] (struct __isdws__setFtpUploadDone*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Category:
		if (p->size < 0)
			delete (std::vector<isdxsd__Category * >*)p->ptr;
		else
			delete[] (std::vector<isdxsd__Category * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Platform:
		if (p->size < 0)
			delete (std::vector<isdxsd__Platform * >*)p->ptr;
		else
			delete[] (std::vector<isdxsd__Platform * >*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Category:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<isdxsd__Category * >*)p)[len] = *(isdxsd__Category **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Platform:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<isdxsd__Platform * >*)p)[len] = *(isdxsd__Platform **)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_str_code(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *p)
{	(void)soap; (void)p; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_std__string(struct soap *soap, int n)
{	return soap_instantiate_std__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__string(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void _isdxsd__ftpUploadDoneResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &((_isdxsd__ftpUploadDoneResponse*)this)->errorString);
	/* transient soap skipped */
}

void _isdxsd__ftpUploadDoneResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__ftpUploadDoneResponse*)this)->errorCode);
	soap_default_std__string(soap, &((_isdxsd__ftpUploadDoneResponse*)this)->errorString);
	/* transient soap skipped */
}

int _isdxsd__ftpUploadDoneResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__ftpUploadDoneResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__ftpUploadDoneResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__ftpUploadDoneResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__ftpUploadDoneResponse(struct soap *soap, const char *tag, int id, const _isdxsd__ftpUploadDoneResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__ftpUploadDoneResponse), type);
	soap_out_int(soap, "isdxsd:errorCode", -1, &(((_isdxsd__ftpUploadDoneResponse*)a)->errorCode), "");
	soap_out_std__string(soap, "isdxsd:errorString", -1, &(((_isdxsd__ftpUploadDoneResponse*)a)->errorString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__ftpUploadDoneResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__ftpUploadDoneResponse(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneResponse * SOAP_FMAC4 soap_get__isdxsd__ftpUploadDoneResponse(struct soap *soap, _isdxsd__ftpUploadDoneResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__ftpUploadDoneResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__ftpUploadDoneResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__ftpUploadDoneResponse(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneResponse * SOAP_FMAC4 soap_in__isdxsd__ftpUploadDoneResponse(struct soap *soap, const char *tag, _isdxsd__ftpUploadDoneResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__ftpUploadDoneResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__ftpUploadDoneResponse, sizeof(_isdxsd__ftpUploadDoneResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__ftpUploadDoneResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__ftpUploadDoneResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_errorCode1 = 1, soap_flag_errorString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_errorCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:errorCode", &(((_isdxsd__ftpUploadDoneResponse*)a)->errorCode), "xsd:int"))
				{	soap_flag_errorCode1--;
					continue;
				}
			if (soap_flag_errorString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:errorString", &(((_isdxsd__ftpUploadDoneResponse*)a)->errorString), "xsd:string"))
				{	soap_flag_errorString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_errorCode1 > 0 || soap_flag_errorString1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__ftpUploadDoneResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__ftpUploadDoneResponse, 0, sizeof(_isdxsd__ftpUploadDoneResponse), 0, soap_copy__isdxsd__ftpUploadDoneResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__ftpUploadDoneResponse * SOAP_FMAC6 soap_new__isdxsd__ftpUploadDoneResponse(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__ftpUploadDoneResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__ftpUploadDoneResponse(struct soap *soap, _isdxsd__ftpUploadDoneResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneResponse * SOAP_FMAC4 soap_instantiate__isdxsd__ftpUploadDoneResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__ftpUploadDoneResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__ftpUploadDoneResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__ftpUploadDoneResponse;
		if (size)
			*size = sizeof(_isdxsd__ftpUploadDoneResponse);
		((_isdxsd__ftpUploadDoneResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__ftpUploadDoneResponse[n];
		if (size)
			*size = n * sizeof(_isdxsd__ftpUploadDoneResponse);
		for (int i = 0; i < n; i++)
			((_isdxsd__ftpUploadDoneResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__ftpUploadDoneResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__ftpUploadDoneResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__ftpUploadDoneResponse %p -> %p\n", q, p));
	*(_isdxsd__ftpUploadDoneResponse*)p = *(_isdxsd__ftpUploadDoneResponse*)q;
}

void _isdxsd__ftpUploadDoneRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void _isdxsd__ftpUploadDoneRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__ftpUploadDoneRequest*)this)->majorVersion);
	soap_default_int(soap, &((_isdxsd__ftpUploadDoneRequest*)this)->minorVersion);
	soap_default_int(soap, &((_isdxsd__ftpUploadDoneRequest*)this)->id);
	soap_default_bool(soap, &((_isdxsd__ftpUploadDoneRequest*)this)->error);
	/* transient soap skipped */
}

int _isdxsd__ftpUploadDoneRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__ftpUploadDoneRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__ftpUploadDoneRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__ftpUploadDoneRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__ftpUploadDoneRequest(struct soap *soap, const char *tag, int id, const _isdxsd__ftpUploadDoneRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__ftpUploadDoneRequest), type);
	soap_out_int(soap, "isdxsd:majorVersion", -1, &(((_isdxsd__ftpUploadDoneRequest*)a)->majorVersion), "");
	soap_out_int(soap, "isdxsd:minorVersion", -1, &(((_isdxsd__ftpUploadDoneRequest*)a)->minorVersion), "");
	soap_out_int(soap, "isdxsd:id", -1, &(((_isdxsd__ftpUploadDoneRequest*)a)->id), "");
	soap_out_bool(soap, "isdxsd:error", -1, &(((_isdxsd__ftpUploadDoneRequest*)a)->error), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__ftpUploadDoneRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__ftpUploadDoneRequest(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneRequest * SOAP_FMAC4 soap_get__isdxsd__ftpUploadDoneRequest(struct soap *soap, _isdxsd__ftpUploadDoneRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__ftpUploadDoneRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__ftpUploadDoneRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__ftpUploadDoneRequest(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneRequest * SOAP_FMAC4 soap_in__isdxsd__ftpUploadDoneRequest(struct soap *soap, const char *tag, _isdxsd__ftpUploadDoneRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__ftpUploadDoneRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__ftpUploadDoneRequest, sizeof(_isdxsd__ftpUploadDoneRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__ftpUploadDoneRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__ftpUploadDoneRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_majorVersion1 = 1, soap_flag_minorVersion1 = 1, soap_flag_id1 = 1, soap_flag_error1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_majorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:majorVersion", &(((_isdxsd__ftpUploadDoneRequest*)a)->majorVersion), "xsd:int"))
				{	soap_flag_majorVersion1--;
					continue;
				}
			if (soap_flag_minorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:minorVersion", &(((_isdxsd__ftpUploadDoneRequest*)a)->minorVersion), "xsd:int"))
				{	soap_flag_minorVersion1--;
					continue;
				}
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:id", &(((_isdxsd__ftpUploadDoneRequest*)a)->id), "xsd:int"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_error1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isdxsd:error", &(((_isdxsd__ftpUploadDoneRequest*)a)->error), "xsd:boolean"))
				{	soap_flag_error1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_majorVersion1 > 0 || soap_flag_minorVersion1 > 0 || soap_flag_id1 > 0 || soap_flag_error1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__ftpUploadDoneRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__ftpUploadDoneRequest, 0, sizeof(_isdxsd__ftpUploadDoneRequest), 0, soap_copy__isdxsd__ftpUploadDoneRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__ftpUploadDoneRequest * SOAP_FMAC6 soap_new__isdxsd__ftpUploadDoneRequest(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__ftpUploadDoneRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__ftpUploadDoneRequest(struct soap *soap, _isdxsd__ftpUploadDoneRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneRequest * SOAP_FMAC4 soap_instantiate__isdxsd__ftpUploadDoneRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__ftpUploadDoneRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__ftpUploadDoneRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__ftpUploadDoneRequest;
		if (size)
			*size = sizeof(_isdxsd__ftpUploadDoneRequest);
		((_isdxsd__ftpUploadDoneRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__ftpUploadDoneRequest[n];
		if (size)
			*size = n * sizeof(_isdxsd__ftpUploadDoneRequest);
		for (int i = 0; i < n; i++)
			((_isdxsd__ftpUploadDoneRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__ftpUploadDoneRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__ftpUploadDoneRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__ftpUploadDoneRequest %p -> %p\n", q, p));
	*(_isdxsd__ftpUploadDoneRequest*)p = *(_isdxsd__ftpUploadDoneRequest*)q;
}

void _isdxsd__newFtpPathResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &((_isdxsd__newFtpPathResponse*)this)->ftpPath);
	soap_serialize_std__string(soap, &((_isdxsd__newFtpPathResponse*)this)->errorString);
	/* transient soap skipped */
}

void _isdxsd__newFtpPathResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__newFtpPathResponse*)this)->id);
	soap_default_std__string(soap, &((_isdxsd__newFtpPathResponse*)this)->ftpPath);
	soap_default_int(soap, &((_isdxsd__newFtpPathResponse*)this)->errorCode);
	soap_default_std__string(soap, &((_isdxsd__newFtpPathResponse*)this)->errorString);
	/* transient soap skipped */
}

int _isdxsd__newFtpPathResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__newFtpPathResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__newFtpPathResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__newFtpPathResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__newFtpPathResponse(struct soap *soap, const char *tag, int id, const _isdxsd__newFtpPathResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__newFtpPathResponse), type);
	soap_out_int(soap, "isdxsd:id", -1, &(((_isdxsd__newFtpPathResponse*)a)->id), "");
	soap_out_std__string(soap, "isdxsd:ftpPath", -1, &(((_isdxsd__newFtpPathResponse*)a)->ftpPath), "");
	soap_out_int(soap, "isdxsd:errorCode", -1, &(((_isdxsd__newFtpPathResponse*)a)->errorCode), "");
	soap_out_std__string(soap, "isdxsd:errorString", -1, &(((_isdxsd__newFtpPathResponse*)a)->errorString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__newFtpPathResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__newFtpPathResponse(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathResponse * SOAP_FMAC4 soap_get__isdxsd__newFtpPathResponse(struct soap *soap, _isdxsd__newFtpPathResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__newFtpPathResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__newFtpPathResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__newFtpPathResponse(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathResponse * SOAP_FMAC4 soap_in__isdxsd__newFtpPathResponse(struct soap *soap, const char *tag, _isdxsd__newFtpPathResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__newFtpPathResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__newFtpPathResponse, sizeof(_isdxsd__newFtpPathResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__newFtpPathResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__newFtpPathResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_ftpPath1 = 1, soap_flag_errorCode1 = 1, soap_flag_errorString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:id", &(((_isdxsd__newFtpPathResponse*)a)->id), "xsd:int"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_ftpPath1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:ftpPath", &(((_isdxsd__newFtpPathResponse*)a)->ftpPath), "xsd:string"))
				{	soap_flag_ftpPath1--;
					continue;
				}
			if (soap_flag_errorCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:errorCode", &(((_isdxsd__newFtpPathResponse*)a)->errorCode), "xsd:int"))
				{	soap_flag_errorCode1--;
					continue;
				}
			if (soap_flag_errorString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:errorString", &(((_isdxsd__newFtpPathResponse*)a)->errorString), "xsd:string"))
				{	soap_flag_errorString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1 > 0 || soap_flag_ftpPath1 > 0 || soap_flag_errorCode1 > 0 || soap_flag_errorString1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__newFtpPathResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__newFtpPathResponse, 0, sizeof(_isdxsd__newFtpPathResponse), 0, soap_copy__isdxsd__newFtpPathResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__newFtpPathResponse * SOAP_FMAC6 soap_new__isdxsd__newFtpPathResponse(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__newFtpPathResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__newFtpPathResponse(struct soap *soap, _isdxsd__newFtpPathResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__newFtpPathResponse * SOAP_FMAC4 soap_instantiate__isdxsd__newFtpPathResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__newFtpPathResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__newFtpPathResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__newFtpPathResponse;
		if (size)
			*size = sizeof(_isdxsd__newFtpPathResponse);
		((_isdxsd__newFtpPathResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__newFtpPathResponse[n];
		if (size)
			*size = n * sizeof(_isdxsd__newFtpPathResponse);
		for (int i = 0; i < n; i++)
			((_isdxsd__newFtpPathResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__newFtpPathResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__newFtpPathResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__newFtpPathResponse %p -> %p\n", q, p));
	*(_isdxsd__newFtpPathResponse*)p = *(_isdxsd__newFtpPathResponse*)q;
}

void _isdxsd__newFtpPathRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &((_isdxsd__newFtpPathRequest*)this)->username);
	soap_serialize_std__string(soap, &((_isdxsd__newFtpPathRequest*)this)->password);
	/* transient soap skipped */
}

void _isdxsd__newFtpPathRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__newFtpPathRequest*)this)->majorVersion);
	soap_default_int(soap, &((_isdxsd__newFtpPathRequest*)this)->minorVersion);
	soap_default_std__string(soap, &((_isdxsd__newFtpPathRequest*)this)->username);
	soap_default_std__string(soap, &((_isdxsd__newFtpPathRequest*)this)->password);
	/* transient soap skipped */
}

int _isdxsd__newFtpPathRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__newFtpPathRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__newFtpPathRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__newFtpPathRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__newFtpPathRequest(struct soap *soap, const char *tag, int id, const _isdxsd__newFtpPathRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__newFtpPathRequest), type);
	soap_out_int(soap, "isdxsd:majorVersion", -1, &(((_isdxsd__newFtpPathRequest*)a)->majorVersion), "");
	soap_out_int(soap, "isdxsd:minorVersion", -1, &(((_isdxsd__newFtpPathRequest*)a)->minorVersion), "");
	soap_out_std__string(soap, "isdxsd:username", -1, &(((_isdxsd__newFtpPathRequest*)a)->username), "");
	soap_out_std__string(soap, "isdxsd:password", -1, &(((_isdxsd__newFtpPathRequest*)a)->password), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__newFtpPathRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__newFtpPathRequest(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathRequest * SOAP_FMAC4 soap_get__isdxsd__newFtpPathRequest(struct soap *soap, _isdxsd__newFtpPathRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__newFtpPathRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__newFtpPathRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__newFtpPathRequest(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathRequest * SOAP_FMAC4 soap_in__isdxsd__newFtpPathRequest(struct soap *soap, const char *tag, _isdxsd__newFtpPathRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__newFtpPathRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__newFtpPathRequest, sizeof(_isdxsd__newFtpPathRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__newFtpPathRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__newFtpPathRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_majorVersion1 = 1, soap_flag_minorVersion1 = 1, soap_flag_username1 = 1, soap_flag_password1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_majorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:majorVersion", &(((_isdxsd__newFtpPathRequest*)a)->majorVersion), "xsd:int"))
				{	soap_flag_majorVersion1--;
					continue;
				}
			if (soap_flag_minorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:minorVersion", &(((_isdxsd__newFtpPathRequest*)a)->minorVersion), "xsd:int"))
				{	soap_flag_minorVersion1--;
					continue;
				}
			if (soap_flag_username1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:username", &(((_isdxsd__newFtpPathRequest*)a)->username), "xsd:string"))
				{	soap_flag_username1--;
					continue;
				}
			if (soap_flag_password1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:password", &(((_isdxsd__newFtpPathRequest*)a)->password), "xsd:string"))
				{	soap_flag_password1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_majorVersion1 > 0 || soap_flag_minorVersion1 > 0 || soap_flag_username1 > 0 || soap_flag_password1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__newFtpPathRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__newFtpPathRequest, 0, sizeof(_isdxsd__newFtpPathRequest), 0, soap_copy__isdxsd__newFtpPathRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__newFtpPathRequest * SOAP_FMAC6 soap_new__isdxsd__newFtpPathRequest(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__newFtpPathRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__newFtpPathRequest(struct soap *soap, _isdxsd__newFtpPathRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__newFtpPathRequest * SOAP_FMAC4 soap_instantiate__isdxsd__newFtpPathRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__newFtpPathRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__newFtpPathRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__newFtpPathRequest;
		if (size)
			*size = sizeof(_isdxsd__newFtpPathRequest);
		((_isdxsd__newFtpPathRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__newFtpPathRequest[n];
		if (size)
			*size = n * sizeof(_isdxsd__newFtpPathRequest);
		for (int i = 0; i < n; i++)
			((_isdxsd__newFtpPathRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__newFtpPathRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__newFtpPathRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__newFtpPathRequest %p -> %p\n", q, p));
	*(_isdxsd__newFtpPathRequest*)p = *(_isdxsd__newFtpPathRequest*)q;
}

void _isdxsd__availableCategoriesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToisdxsd__CategoryArray(soap, &((_isdxsd__availableCategoriesResponse*)this)->categoryArray);
	soap_serialize_std__string(soap, &((_isdxsd__availableCategoriesResponse*)this)->errorString);
	/* transient soap skipped */
}

void _isdxsd__availableCategoriesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_isdxsd__availableCategoriesResponse*)this)->categoryArray = NULL;
	soap_default_int(soap, &((_isdxsd__availableCategoriesResponse*)this)->errorCode);
	soap_default_std__string(soap, &((_isdxsd__availableCategoriesResponse*)this)->errorString);
	/* transient soap skipped */
}

int _isdxsd__availableCategoriesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__availableCategoriesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__availableCategoriesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__availableCategoriesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__availableCategoriesResponse(struct soap *soap, const char *tag, int id, const _isdxsd__availableCategoriesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__availableCategoriesResponse), type);
	soap_out_PointerToisdxsd__CategoryArray(soap, "isdxsd:categoryArray", -1, &(((_isdxsd__availableCategoriesResponse*)a)->categoryArray), "");
	soap_out_int(soap, "isdxsd:errorCode", -1, &(((_isdxsd__availableCategoriesResponse*)a)->errorCode), "");
	soap_out_std__string(soap, "isdxsd:errorString", -1, &(((_isdxsd__availableCategoriesResponse*)a)->errorString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__availableCategoriesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__availableCategoriesResponse(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesResponse * SOAP_FMAC4 soap_get__isdxsd__availableCategoriesResponse(struct soap *soap, _isdxsd__availableCategoriesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__availableCategoriesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__availableCategoriesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__availableCategoriesResponse(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesResponse * SOAP_FMAC4 soap_in__isdxsd__availableCategoriesResponse(struct soap *soap, const char *tag, _isdxsd__availableCategoriesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__availableCategoriesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__availableCategoriesResponse, sizeof(_isdxsd__availableCategoriesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__availableCategoriesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__availableCategoriesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_categoryArray1 = 1, soap_flag_errorCode1 = 1, soap_flag_errorString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_categoryArray1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToisdxsd__CategoryArray(soap, "isdxsd:categoryArray", &(((_isdxsd__availableCategoriesResponse*)a)->categoryArray), "isdxsd:CategoryArray"))
				{	soap_flag_categoryArray1--;
					continue;
				}
			if (soap_flag_errorCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:errorCode", &(((_isdxsd__availableCategoriesResponse*)a)->errorCode), "xsd:int"))
				{	soap_flag_errorCode1--;
					continue;
				}
			if (soap_flag_errorString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:errorString", &(((_isdxsd__availableCategoriesResponse*)a)->errorString), "xsd:string"))
				{	soap_flag_errorString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_categoryArray1 > 0 || soap_flag_errorCode1 > 0 || soap_flag_errorString1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__availableCategoriesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__availableCategoriesResponse, 0, sizeof(_isdxsd__availableCategoriesResponse), 0, soap_copy__isdxsd__availableCategoriesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__availableCategoriesResponse * SOAP_FMAC6 soap_new__isdxsd__availableCategoriesResponse(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__availableCategoriesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__availableCategoriesResponse(struct soap *soap, _isdxsd__availableCategoriesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__availableCategoriesResponse * SOAP_FMAC4 soap_instantiate__isdxsd__availableCategoriesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__availableCategoriesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__availableCategoriesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__availableCategoriesResponse;
		if (size)
			*size = sizeof(_isdxsd__availableCategoriesResponse);
		((_isdxsd__availableCategoriesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__availableCategoriesResponse[n];
		if (size)
			*size = n * sizeof(_isdxsd__availableCategoriesResponse);
		for (int i = 0; i < n; i++)
			((_isdxsd__availableCategoriesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__availableCategoriesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__availableCategoriesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__availableCategoriesResponse %p -> %p\n", q, p));
	*(_isdxsd__availableCategoriesResponse*)p = *(_isdxsd__availableCategoriesResponse*)q;
}

void _isdxsd__availableCategoriesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToisdxsd__Category(soap, &((_isdxsd__availableCategoriesRequest*)this)->category);
	/* transient soap skipped */
}

void _isdxsd__availableCategoriesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__availableCategoriesRequest*)this)->majorVersion);
	soap_default_int(soap, &((_isdxsd__availableCategoriesRequest*)this)->minorVersion);
	((_isdxsd__availableCategoriesRequest*)this)->category = NULL;
	/* transient soap skipped */
}

int _isdxsd__availableCategoriesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__availableCategoriesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__availableCategoriesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__availableCategoriesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__availableCategoriesRequest(struct soap *soap, const char *tag, int id, const _isdxsd__availableCategoriesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__availableCategoriesRequest), type);
	soap_out_int(soap, "isdxsd:majorVersion", -1, &(((_isdxsd__availableCategoriesRequest*)a)->majorVersion), "");
	soap_out_int(soap, "isdxsd:minorVersion", -1, &(((_isdxsd__availableCategoriesRequest*)a)->minorVersion), "");
	soap_out_PointerToisdxsd__Category(soap, "isdxsd:category", -1, &(((_isdxsd__availableCategoriesRequest*)a)->category), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__availableCategoriesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__availableCategoriesRequest(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesRequest * SOAP_FMAC4 soap_get__isdxsd__availableCategoriesRequest(struct soap *soap, _isdxsd__availableCategoriesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__availableCategoriesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__availableCategoriesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__availableCategoriesRequest(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesRequest * SOAP_FMAC4 soap_in__isdxsd__availableCategoriesRequest(struct soap *soap, const char *tag, _isdxsd__availableCategoriesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__availableCategoriesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__availableCategoriesRequest, sizeof(_isdxsd__availableCategoriesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__availableCategoriesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__availableCategoriesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_majorVersion1 = 1, soap_flag_minorVersion1 = 1, soap_flag_category1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_majorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:majorVersion", &(((_isdxsd__availableCategoriesRequest*)a)->majorVersion), "xsd:int"))
				{	soap_flag_majorVersion1--;
					continue;
				}
			if (soap_flag_minorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:minorVersion", &(((_isdxsd__availableCategoriesRequest*)a)->minorVersion), "xsd:int"))
				{	soap_flag_minorVersion1--;
					continue;
				}
			if (soap_flag_category1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToisdxsd__Category(soap, "isdxsd:category", &(((_isdxsd__availableCategoriesRequest*)a)->category), "isdxsd:Category"))
				{	soap_flag_category1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_majorVersion1 > 0 || soap_flag_minorVersion1 > 0 || soap_flag_category1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__availableCategoriesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__availableCategoriesRequest, 0, sizeof(_isdxsd__availableCategoriesRequest), 0, soap_copy__isdxsd__availableCategoriesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__availableCategoriesRequest * SOAP_FMAC6 soap_new__isdxsd__availableCategoriesRequest(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__availableCategoriesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__availableCategoriesRequest(struct soap *soap, _isdxsd__availableCategoriesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__availableCategoriesRequest * SOAP_FMAC4 soap_instantiate__isdxsd__availableCategoriesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__availableCategoriesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__availableCategoriesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__availableCategoriesRequest;
		if (size)
			*size = sizeof(_isdxsd__availableCategoriesRequest);
		((_isdxsd__availableCategoriesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__availableCategoriesRequest[n];
		if (size)
			*size = n * sizeof(_isdxsd__availableCategoriesRequest);
		for (int i = 0; i < n; i++)
			((_isdxsd__availableCategoriesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__availableCategoriesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__availableCategoriesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__availableCategoriesRequest %p -> %p\n", q, p));
	*(_isdxsd__availableCategoriesRequest*)p = *(_isdxsd__availableCategoriesRequest*)q;
}

void _isdxsd__availablePlatformsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToisdxsd__PlatformArray(soap, &((_isdxsd__availablePlatformsResponse*)this)->platformArray);
	soap_serialize_std__string(soap, &((_isdxsd__availablePlatformsResponse*)this)->errorString);
	/* transient soap skipped */
}

void _isdxsd__availablePlatformsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_isdxsd__availablePlatformsResponse*)this)->platformArray = NULL;
	soap_default_int(soap, &((_isdxsd__availablePlatformsResponse*)this)->errorCode);
	soap_default_std__string(soap, &((_isdxsd__availablePlatformsResponse*)this)->errorString);
	/* transient soap skipped */
}

int _isdxsd__availablePlatformsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__availablePlatformsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__availablePlatformsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__availablePlatformsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__availablePlatformsResponse(struct soap *soap, const char *tag, int id, const _isdxsd__availablePlatformsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__availablePlatformsResponse), type);
	soap_out_PointerToisdxsd__PlatformArray(soap, "isdxsd:platformArray", -1, &(((_isdxsd__availablePlatformsResponse*)a)->platformArray), "");
	soap_out_int(soap, "isdxsd:errorCode", -1, &(((_isdxsd__availablePlatformsResponse*)a)->errorCode), "");
	soap_out_std__string(soap, "isdxsd:errorString", -1, &(((_isdxsd__availablePlatformsResponse*)a)->errorString), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__availablePlatformsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__availablePlatformsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsResponse * SOAP_FMAC4 soap_get__isdxsd__availablePlatformsResponse(struct soap *soap, _isdxsd__availablePlatformsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__availablePlatformsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__availablePlatformsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__availablePlatformsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsResponse * SOAP_FMAC4 soap_in__isdxsd__availablePlatformsResponse(struct soap *soap, const char *tag, _isdxsd__availablePlatformsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__availablePlatformsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__availablePlatformsResponse, sizeof(_isdxsd__availablePlatformsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__availablePlatformsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__availablePlatformsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_platformArray1 = 1, soap_flag_errorCode1 = 1, soap_flag_errorString1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_platformArray1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToisdxsd__PlatformArray(soap, "isdxsd:platformArray", &(((_isdxsd__availablePlatformsResponse*)a)->platformArray), "isdxsd:PlatformArray"))
				{	soap_flag_platformArray1--;
					continue;
				}
			if (soap_flag_errorCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:errorCode", &(((_isdxsd__availablePlatformsResponse*)a)->errorCode), "xsd:int"))
				{	soap_flag_errorCode1--;
					continue;
				}
			if (soap_flag_errorString1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:errorString", &(((_isdxsd__availablePlatformsResponse*)a)->errorString), "xsd:string"))
				{	soap_flag_errorString1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_platformArray1 > 0 || soap_flag_errorCode1 > 0 || soap_flag_errorString1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__availablePlatformsResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__availablePlatformsResponse, 0, sizeof(_isdxsd__availablePlatformsResponse), 0, soap_copy__isdxsd__availablePlatformsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__availablePlatformsResponse * SOAP_FMAC6 soap_new__isdxsd__availablePlatformsResponse(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__availablePlatformsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__availablePlatformsResponse(struct soap *soap, _isdxsd__availablePlatformsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__availablePlatformsResponse * SOAP_FMAC4 soap_instantiate__isdxsd__availablePlatformsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__availablePlatformsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__availablePlatformsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__availablePlatformsResponse;
		if (size)
			*size = sizeof(_isdxsd__availablePlatformsResponse);
		((_isdxsd__availablePlatformsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__availablePlatformsResponse[n];
		if (size)
			*size = n * sizeof(_isdxsd__availablePlatformsResponse);
		for (int i = 0; i < n; i++)
			((_isdxsd__availablePlatformsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__availablePlatformsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__availablePlatformsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__availablePlatformsResponse %p -> %p\n", q, p));
	*(_isdxsd__availablePlatformsResponse*)p = *(_isdxsd__availablePlatformsResponse*)q;
}

void _isdxsd__availablePlatformsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToisdxsd__Platform(soap, &((_isdxsd__availablePlatformsRequest*)this)->platform);
	/* transient soap skipped */
}

void _isdxsd__availablePlatformsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((_isdxsd__availablePlatformsRequest*)this)->majorVersion);
	soap_default_int(soap, &((_isdxsd__availablePlatformsRequest*)this)->minorVersion);
	((_isdxsd__availablePlatformsRequest*)this)->platform = NULL;
	/* transient soap skipped */
}

int _isdxsd__availablePlatformsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__isdxsd__availablePlatformsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _isdxsd__availablePlatformsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__isdxsd__availablePlatformsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__isdxsd__availablePlatformsRequest(struct soap *soap, const char *tag, int id, const _isdxsd__availablePlatformsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__isdxsd__availablePlatformsRequest), type);
	soap_out_int(soap, "isdxsd:majorVersion", -1, &(((_isdxsd__availablePlatformsRequest*)a)->majorVersion), "");
	soap_out_int(soap, "isdxsd:minorVersion", -1, &(((_isdxsd__availablePlatformsRequest*)a)->minorVersion), "");
	soap_out_PointerToisdxsd__Platform(soap, "isdxsd:platform", -1, &(((_isdxsd__availablePlatformsRequest*)a)->platform), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_isdxsd__availablePlatformsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__isdxsd__availablePlatformsRequest(soap, this, tag, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsRequest * SOAP_FMAC4 soap_get__isdxsd__availablePlatformsRequest(struct soap *soap, _isdxsd__availablePlatformsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__isdxsd__availablePlatformsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_isdxsd__availablePlatformsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__isdxsd__availablePlatformsRequest(soap, tag, this, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsRequest * SOAP_FMAC4 soap_in__isdxsd__availablePlatformsRequest(struct soap *soap, const char *tag, _isdxsd__availablePlatformsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_isdxsd__availablePlatformsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__isdxsd__availablePlatformsRequest, sizeof(_isdxsd__availablePlatformsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__isdxsd__availablePlatformsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_isdxsd__availablePlatformsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_majorVersion1 = 1, soap_flag_minorVersion1 = 1, soap_flag_platform1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_majorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:majorVersion", &(((_isdxsd__availablePlatformsRequest*)a)->majorVersion), "xsd:int"))
				{	soap_flag_majorVersion1--;
					continue;
				}
			if (soap_flag_minorVersion1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:minorVersion", &(((_isdxsd__availablePlatformsRequest*)a)->minorVersion), "xsd:int"))
				{	soap_flag_minorVersion1--;
					continue;
				}
			if (soap_flag_platform1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToisdxsd__Platform(soap, "isdxsd:platform", &(((_isdxsd__availablePlatformsRequest*)a)->platform), "isdxsd:Platform"))
				{	soap_flag_platform1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_majorVersion1 > 0 || soap_flag_minorVersion1 > 0 || soap_flag_platform1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_isdxsd__availablePlatformsRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__isdxsd__availablePlatformsRequest, 0, sizeof(_isdxsd__availablePlatformsRequest), 0, soap_copy__isdxsd__availablePlatformsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _isdxsd__availablePlatformsRequest * SOAP_FMAC6 soap_new__isdxsd__availablePlatformsRequest(struct soap *soap, int n)
{	return soap_instantiate__isdxsd__availablePlatformsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__isdxsd__availablePlatformsRequest(struct soap *soap, _isdxsd__availablePlatformsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _isdxsd__availablePlatformsRequest * SOAP_FMAC4 soap_instantiate__isdxsd__availablePlatformsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__isdxsd__availablePlatformsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__isdxsd__availablePlatformsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _isdxsd__availablePlatformsRequest;
		if (size)
			*size = sizeof(_isdxsd__availablePlatformsRequest);
		((_isdxsd__availablePlatformsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _isdxsd__availablePlatformsRequest[n];
		if (size)
			*size = n * sizeof(_isdxsd__availablePlatformsRequest);
		for (int i = 0; i < n; i++)
			((_isdxsd__availablePlatformsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_isdxsd__availablePlatformsRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__isdxsd__availablePlatformsRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _isdxsd__availablePlatformsRequest %p -> %p\n", q, p));
	*(_isdxsd__availablePlatformsRequest*)p = *(_isdxsd__availablePlatformsRequest*)q;
}

void isdxsd__CategoryArray::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerToisdxsd__Category(soap, &((isdxsd__CategoryArray*)this)->category);
	/* transient soap skipped */
}

void isdxsd__CategoryArray::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerToisdxsd__Category(soap, &((isdxsd__CategoryArray*)this)->category);
	/* transient soap skipped */
}

int isdxsd__CategoryArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_isdxsd__CategoryArray);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int isdxsd__CategoryArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_isdxsd__CategoryArray(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_isdxsd__CategoryArray(struct soap *soap, const char *tag, int id, const isdxsd__CategoryArray *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_isdxsd__CategoryArray), type);
	soap_out_std__vectorTemplateOfPointerToisdxsd__Category(soap, "isdxsd:category", -1, &(((isdxsd__CategoryArray*)a)->category), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *isdxsd__CategoryArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_isdxsd__CategoryArray(soap, this, tag, type);
}

SOAP_FMAC3 isdxsd__CategoryArray * SOAP_FMAC4 soap_get_isdxsd__CategoryArray(struct soap *soap, isdxsd__CategoryArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_isdxsd__CategoryArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *isdxsd__CategoryArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_isdxsd__CategoryArray(soap, tag, this, type);
}

SOAP_FMAC3 isdxsd__CategoryArray * SOAP_FMAC4 soap_in_isdxsd__CategoryArray(struct soap *soap, const char *tag, isdxsd__CategoryArray *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (isdxsd__CategoryArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_isdxsd__CategoryArray, sizeof(isdxsd__CategoryArray), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_isdxsd__CategoryArray)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (isdxsd__CategoryArray *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerToisdxsd__Category(soap, "isdxsd:category", &(((isdxsd__CategoryArray*)a)->category), "isdxsd:Category"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (isdxsd__CategoryArray *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_isdxsd__CategoryArray, 0, sizeof(isdxsd__CategoryArray), 0, soap_copy_isdxsd__CategoryArray);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 isdxsd__CategoryArray * SOAP_FMAC6 soap_new_isdxsd__CategoryArray(struct soap *soap, int n)
{	return soap_instantiate_isdxsd__CategoryArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_isdxsd__CategoryArray(struct soap *soap, isdxsd__CategoryArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 isdxsd__CategoryArray * SOAP_FMAC4 soap_instantiate_isdxsd__CategoryArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_isdxsd__CategoryArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_isdxsd__CategoryArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new isdxsd__CategoryArray;
		if (size)
			*size = sizeof(isdxsd__CategoryArray);
		((isdxsd__CategoryArray*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new isdxsd__CategoryArray[n];
		if (size)
			*size = n * sizeof(isdxsd__CategoryArray);
		for (int i = 0; i < n; i++)
			((isdxsd__CategoryArray*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (isdxsd__CategoryArray*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_isdxsd__CategoryArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying isdxsd__CategoryArray %p -> %p\n", q, p));
	*(isdxsd__CategoryArray*)p = *(isdxsd__CategoryArray*)q;
}

void isdxsd__Category::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &((isdxsd__Category*)this)->title);
	/* transient soap skipped */
}

void isdxsd__Category::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((isdxsd__Category*)this)->id);
	soap_default_std__string(soap, &((isdxsd__Category*)this)->title);
	/* transient soap skipped */
}

int isdxsd__Category::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_isdxsd__Category);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int isdxsd__Category::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_isdxsd__Category(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_isdxsd__Category(struct soap *soap, const char *tag, int id, const isdxsd__Category *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_isdxsd__Category), type);
	soap_out_int(soap, "isdxsd:id", -1, &(((isdxsd__Category*)a)->id), "");
	soap_out_std__string(soap, "isdxsd:title", -1, &(((isdxsd__Category*)a)->title), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *isdxsd__Category::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_isdxsd__Category(soap, this, tag, type);
}

SOAP_FMAC3 isdxsd__Category * SOAP_FMAC4 soap_get_isdxsd__Category(struct soap *soap, isdxsd__Category *p, const char *tag, const char *type)
{
	if ((p = soap_in_isdxsd__Category(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *isdxsd__Category::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_isdxsd__Category(soap, tag, this, type);
}

SOAP_FMAC3 isdxsd__Category * SOAP_FMAC4 soap_in_isdxsd__Category(struct soap *soap, const char *tag, isdxsd__Category *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (isdxsd__Category *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_isdxsd__Category, sizeof(isdxsd__Category), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_isdxsd__Category)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (isdxsd__Category *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_title1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:id", &(((isdxsd__Category*)a)->id), "xsd:int"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_title1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:title", &(((isdxsd__Category*)a)->title), "xsd:string"))
				{	soap_flag_title1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1 > 0 || soap_flag_title1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (isdxsd__Category *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_isdxsd__Category, 0, sizeof(isdxsd__Category), 0, soap_copy_isdxsd__Category);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 isdxsd__Category * SOAP_FMAC6 soap_new_isdxsd__Category(struct soap *soap, int n)
{	return soap_instantiate_isdxsd__Category(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_isdxsd__Category(struct soap *soap, isdxsd__Category *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 isdxsd__Category * SOAP_FMAC4 soap_instantiate_isdxsd__Category(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_isdxsd__Category(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_isdxsd__Category, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new isdxsd__Category;
		if (size)
			*size = sizeof(isdxsd__Category);
		((isdxsd__Category*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new isdxsd__Category[n];
		if (size)
			*size = n * sizeof(isdxsd__Category);
		for (int i = 0; i < n; i++)
			((isdxsd__Category*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (isdxsd__Category*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_isdxsd__Category(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying isdxsd__Category %p -> %p\n", q, p));
	*(isdxsd__Category*)p = *(isdxsd__Category*)q;
}

void isdxsd__PlatformArray::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerToisdxsd__Platform(soap, &((isdxsd__PlatformArray*)this)->platform);
	/* transient soap skipped */
}

void isdxsd__PlatformArray::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerToisdxsd__Platform(soap, &((isdxsd__PlatformArray*)this)->platform);
	/* transient soap skipped */
}

int isdxsd__PlatformArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_isdxsd__PlatformArray);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int isdxsd__PlatformArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_isdxsd__PlatformArray(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_isdxsd__PlatformArray(struct soap *soap, const char *tag, int id, const isdxsd__PlatformArray *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_isdxsd__PlatformArray), type);
	soap_out_std__vectorTemplateOfPointerToisdxsd__Platform(soap, "isdxsd:platform", -1, &(((isdxsd__PlatformArray*)a)->platform), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *isdxsd__PlatformArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_isdxsd__PlatformArray(soap, this, tag, type);
}

SOAP_FMAC3 isdxsd__PlatformArray * SOAP_FMAC4 soap_get_isdxsd__PlatformArray(struct soap *soap, isdxsd__PlatformArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_isdxsd__PlatformArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *isdxsd__PlatformArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_isdxsd__PlatformArray(soap, tag, this, type);
}

SOAP_FMAC3 isdxsd__PlatformArray * SOAP_FMAC4 soap_in_isdxsd__PlatformArray(struct soap *soap, const char *tag, isdxsd__PlatformArray *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (isdxsd__PlatformArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_isdxsd__PlatformArray, sizeof(isdxsd__PlatformArray), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_isdxsd__PlatformArray)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (isdxsd__PlatformArray *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerToisdxsd__Platform(soap, "isdxsd:platform", &(((isdxsd__PlatformArray*)a)->platform), "isdxsd:Platform"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (isdxsd__PlatformArray *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_isdxsd__PlatformArray, 0, sizeof(isdxsd__PlatformArray), 0, soap_copy_isdxsd__PlatformArray);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 isdxsd__PlatformArray * SOAP_FMAC6 soap_new_isdxsd__PlatformArray(struct soap *soap, int n)
{	return soap_instantiate_isdxsd__PlatformArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_isdxsd__PlatformArray(struct soap *soap, isdxsd__PlatformArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 isdxsd__PlatformArray * SOAP_FMAC4 soap_instantiate_isdxsd__PlatformArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_isdxsd__PlatformArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_isdxsd__PlatformArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new isdxsd__PlatformArray;
		if (size)
			*size = sizeof(isdxsd__PlatformArray);
		((isdxsd__PlatformArray*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new isdxsd__PlatformArray[n];
		if (size)
			*size = n * sizeof(isdxsd__PlatformArray);
		for (int i = 0; i < n; i++)
			((isdxsd__PlatformArray*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (isdxsd__PlatformArray*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_isdxsd__PlatformArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying isdxsd__PlatformArray %p -> %p\n", q, p));
	*(isdxsd__PlatformArray*)p = *(isdxsd__PlatformArray*)q;
}

void isdxsd__Platform::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &((isdxsd__Platform*)this)->title);
	/* transient soap skipped */
}

void isdxsd__Platform::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((isdxsd__Platform*)this)->id);
	soap_default_std__string(soap, &((isdxsd__Platform*)this)->title);
	/* transient soap skipped */
}

int isdxsd__Platform::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_isdxsd__Platform);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int isdxsd__Platform::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_isdxsd__Platform(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_isdxsd__Platform(struct soap *soap, const char *tag, int id, const isdxsd__Platform *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_isdxsd__Platform), type);
	soap_out_int(soap, "isdxsd:id", -1, &(((isdxsd__Platform*)a)->id), "");
	soap_out_std__string(soap, "isdxsd:title", -1, &(((isdxsd__Platform*)a)->title), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *isdxsd__Platform::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_isdxsd__Platform(soap, this, tag, type);
}

SOAP_FMAC3 isdxsd__Platform * SOAP_FMAC4 soap_get_isdxsd__Platform(struct soap *soap, isdxsd__Platform *p, const char *tag, const char *type)
{
	if ((p = soap_in_isdxsd__Platform(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *isdxsd__Platform::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_isdxsd__Platform(soap, tag, this, type);
}

SOAP_FMAC3 isdxsd__Platform * SOAP_FMAC4 soap_in_isdxsd__Platform(struct soap *soap, const char *tag, isdxsd__Platform *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (isdxsd__Platform *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_isdxsd__Platform, sizeof(isdxsd__Platform), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_isdxsd__Platform)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (isdxsd__Platform *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_title1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "isdxsd:id", &(((isdxsd__Platform*)a)->id), "xsd:int"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_title1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "isdxsd:title", &(((isdxsd__Platform*)a)->title), "xsd:string"))
				{	soap_flag_title1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1 > 0 || soap_flag_title1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (isdxsd__Platform *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_isdxsd__Platform, 0, sizeof(isdxsd__Platform), 0, soap_copy_isdxsd__Platform);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 isdxsd__Platform * SOAP_FMAC6 soap_new_isdxsd__Platform(struct soap *soap, int n)
{	return soap_instantiate_isdxsd__Platform(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_isdxsd__Platform(struct soap *soap, isdxsd__Platform *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 isdxsd__Platform * SOAP_FMAC4 soap_instantiate_isdxsd__Platform(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_isdxsd__Platform(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_isdxsd__Platform, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new isdxsd__Platform;
		if (size)
			*size = sizeof(isdxsd__Platform);
		((isdxsd__Platform*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new isdxsd__Platform[n];
		if (size)
			*size = n * sizeof(isdxsd__Platform);
		for (int i = 0; i < n; i++)
			((isdxsd__Platform*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (isdxsd__Platform*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_isdxsd__Platform(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying isdxsd__Platform %p -> %p\n", q, p));
	*(isdxsd__Platform*)p = *(isdxsd__Platform*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___isdws__setFtpUploadDone(struct soap *soap, const struct __isdws__setFtpUploadDone *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_isdxsd__ftpUploadDoneRequest(soap, &a->isdxsd__ftpUploadDoneRequest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___isdws__setFtpUploadDone(struct soap *soap, struct __isdws__setFtpUploadDone *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->isdxsd__ftpUploadDoneRequest = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___isdws__setFtpUploadDone(struct soap *soap, const struct __isdws__setFtpUploadDone *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___isdws__setFtpUploadDone(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___isdws__setFtpUploadDone(struct soap *soap, const char *tag, int id, const struct __isdws__setFtpUploadDone *a, const char *type)
{
	soap_out_PointerTo_isdxsd__ftpUploadDoneRequest(soap, "isdxsd:ftpUploadDoneRequest", -1, &a->isdxsd__ftpUploadDoneRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __isdws__setFtpUploadDone * SOAP_FMAC4 soap_get___isdws__setFtpUploadDone(struct soap *soap, struct __isdws__setFtpUploadDone *p, const char *tag, const char *type)
{
	if ((p = soap_in___isdws__setFtpUploadDone(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __isdws__setFtpUploadDone * SOAP_FMAC4 soap_in___isdws__setFtpUploadDone(struct soap *soap, const char *tag, struct __isdws__setFtpUploadDone *a, const char *type)
{
	short soap_flag_isdxsd__ftpUploadDoneRequest = 1;
	a = (struct __isdws__setFtpUploadDone *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___isdws__setFtpUploadDone, sizeof(struct __isdws__setFtpUploadDone), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___isdws__setFtpUploadDone(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_isdxsd__ftpUploadDoneRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_isdxsd__ftpUploadDoneRequest(soap, "isdxsd:ftpUploadDoneRequest", &a->isdxsd__ftpUploadDoneRequest, ""))
				{	soap_flag_isdxsd__ftpUploadDoneRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __isdws__setFtpUploadDone * SOAP_FMAC6 soap_new___isdws__setFtpUploadDone(struct soap *soap, int n)
{	return soap_instantiate___isdws__setFtpUploadDone(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___isdws__setFtpUploadDone(struct soap *soap, struct __isdws__setFtpUploadDone *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __isdws__setFtpUploadDone * SOAP_FMAC4 soap_instantiate___isdws__setFtpUploadDone(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___isdws__setFtpUploadDone(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___isdws__setFtpUploadDone, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __isdws__setFtpUploadDone;
		if (size)
			*size = sizeof(struct __isdws__setFtpUploadDone);
	}
	else
	{	cp->ptr = (void*)new struct __isdws__setFtpUploadDone[n];
		if (size)
			*size = n * sizeof(struct __isdws__setFtpUploadDone);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __isdws__setFtpUploadDone*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___isdws__setFtpUploadDone(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __isdws__setFtpUploadDone %p -> %p\n", q, p));
	*(struct __isdws__setFtpUploadDone*)p = *(struct __isdws__setFtpUploadDone*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___isdws__getNewFtpPath(struct soap *soap, const struct __isdws__getNewFtpPath *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_isdxsd__newFtpPathRequest(soap, &a->isdxsd__newFtpPathRequest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___isdws__getNewFtpPath(struct soap *soap, struct __isdws__getNewFtpPath *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->isdxsd__newFtpPathRequest = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___isdws__getNewFtpPath(struct soap *soap, const struct __isdws__getNewFtpPath *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___isdws__getNewFtpPath(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___isdws__getNewFtpPath(struct soap *soap, const char *tag, int id, const struct __isdws__getNewFtpPath *a, const char *type)
{
	soap_out_PointerTo_isdxsd__newFtpPathRequest(soap, "isdxsd:newFtpPathRequest", -1, &a->isdxsd__newFtpPathRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __isdws__getNewFtpPath * SOAP_FMAC4 soap_get___isdws__getNewFtpPath(struct soap *soap, struct __isdws__getNewFtpPath *p, const char *tag, const char *type)
{
	if ((p = soap_in___isdws__getNewFtpPath(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __isdws__getNewFtpPath * SOAP_FMAC4 soap_in___isdws__getNewFtpPath(struct soap *soap, const char *tag, struct __isdws__getNewFtpPath *a, const char *type)
{
	short soap_flag_isdxsd__newFtpPathRequest = 1;
	a = (struct __isdws__getNewFtpPath *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___isdws__getNewFtpPath, sizeof(struct __isdws__getNewFtpPath), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___isdws__getNewFtpPath(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_isdxsd__newFtpPathRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_isdxsd__newFtpPathRequest(soap, "isdxsd:newFtpPathRequest", &a->isdxsd__newFtpPathRequest, ""))
				{	soap_flag_isdxsd__newFtpPathRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __isdws__getNewFtpPath * SOAP_FMAC6 soap_new___isdws__getNewFtpPath(struct soap *soap, int n)
{	return soap_instantiate___isdws__getNewFtpPath(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___isdws__getNewFtpPath(struct soap *soap, struct __isdws__getNewFtpPath *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __isdws__getNewFtpPath * SOAP_FMAC4 soap_instantiate___isdws__getNewFtpPath(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___isdws__getNewFtpPath(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___isdws__getNewFtpPath, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __isdws__getNewFtpPath;
		if (size)
			*size = sizeof(struct __isdws__getNewFtpPath);
	}
	else
	{	cp->ptr = (void*)new struct __isdws__getNewFtpPath[n];
		if (size)
			*size = n * sizeof(struct __isdws__getNewFtpPath);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __isdws__getNewFtpPath*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___isdws__getNewFtpPath(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __isdws__getNewFtpPath %p -> %p\n", q, p));
	*(struct __isdws__getNewFtpPath*)p = *(struct __isdws__getNewFtpPath*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___isdws__getAvailableCategories(struct soap *soap, const struct __isdws__getAvailableCategories *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_isdxsd__availableCategoriesRequest(soap, &a->isdxsd__availableCategoriesRequest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___isdws__getAvailableCategories(struct soap *soap, struct __isdws__getAvailableCategories *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->isdxsd__availableCategoriesRequest = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___isdws__getAvailableCategories(struct soap *soap, const struct __isdws__getAvailableCategories *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___isdws__getAvailableCategories(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___isdws__getAvailableCategories(struct soap *soap, const char *tag, int id, const struct __isdws__getAvailableCategories *a, const char *type)
{
	soap_out_PointerTo_isdxsd__availableCategoriesRequest(soap, "isdxsd:availableCategoriesRequest", -1, &a->isdxsd__availableCategoriesRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __isdws__getAvailableCategories * SOAP_FMAC4 soap_get___isdws__getAvailableCategories(struct soap *soap, struct __isdws__getAvailableCategories *p, const char *tag, const char *type)
{
	if ((p = soap_in___isdws__getAvailableCategories(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __isdws__getAvailableCategories * SOAP_FMAC4 soap_in___isdws__getAvailableCategories(struct soap *soap, const char *tag, struct __isdws__getAvailableCategories *a, const char *type)
{
	short soap_flag_isdxsd__availableCategoriesRequest = 1;
	a = (struct __isdws__getAvailableCategories *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___isdws__getAvailableCategories, sizeof(struct __isdws__getAvailableCategories), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___isdws__getAvailableCategories(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_isdxsd__availableCategoriesRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_isdxsd__availableCategoriesRequest(soap, "isdxsd:availableCategoriesRequest", &a->isdxsd__availableCategoriesRequest, ""))
				{	soap_flag_isdxsd__availableCategoriesRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __isdws__getAvailableCategories * SOAP_FMAC6 soap_new___isdws__getAvailableCategories(struct soap *soap, int n)
{	return soap_instantiate___isdws__getAvailableCategories(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___isdws__getAvailableCategories(struct soap *soap, struct __isdws__getAvailableCategories *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __isdws__getAvailableCategories * SOAP_FMAC4 soap_instantiate___isdws__getAvailableCategories(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___isdws__getAvailableCategories(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___isdws__getAvailableCategories, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __isdws__getAvailableCategories;
		if (size)
			*size = sizeof(struct __isdws__getAvailableCategories);
	}
	else
	{	cp->ptr = (void*)new struct __isdws__getAvailableCategories[n];
		if (size)
			*size = n * sizeof(struct __isdws__getAvailableCategories);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __isdws__getAvailableCategories*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___isdws__getAvailableCategories(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __isdws__getAvailableCategories %p -> %p\n", q, p));
	*(struct __isdws__getAvailableCategories*)p = *(struct __isdws__getAvailableCategories*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___isdws__getAvailablePlatforms(struct soap *soap, const struct __isdws__getAvailablePlatforms *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_isdxsd__availablePlatformsRequest(soap, &a->isdxsd__availablePlatformsRequest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___isdws__getAvailablePlatforms(struct soap *soap, struct __isdws__getAvailablePlatforms *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->isdxsd__availablePlatformsRequest = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___isdws__getAvailablePlatforms(struct soap *soap, const struct __isdws__getAvailablePlatforms *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___isdws__getAvailablePlatforms(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___isdws__getAvailablePlatforms(struct soap *soap, const char *tag, int id, const struct __isdws__getAvailablePlatforms *a, const char *type)
{
	soap_out_PointerTo_isdxsd__availablePlatformsRequest(soap, "isdxsd:availablePlatformsRequest", -1, &a->isdxsd__availablePlatformsRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __isdws__getAvailablePlatforms * SOAP_FMAC4 soap_get___isdws__getAvailablePlatforms(struct soap *soap, struct __isdws__getAvailablePlatforms *p, const char *tag, const char *type)
{
	if ((p = soap_in___isdws__getAvailablePlatforms(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __isdws__getAvailablePlatforms * SOAP_FMAC4 soap_in___isdws__getAvailablePlatforms(struct soap *soap, const char *tag, struct __isdws__getAvailablePlatforms *a, const char *type)
{
	short soap_flag_isdxsd__availablePlatformsRequest = 1;
	a = (struct __isdws__getAvailablePlatforms *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___isdws__getAvailablePlatforms, sizeof(struct __isdws__getAvailablePlatforms), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___isdws__getAvailablePlatforms(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_isdxsd__availablePlatformsRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_isdxsd__availablePlatformsRequest(soap, "isdxsd:availablePlatformsRequest", &a->isdxsd__availablePlatformsRequest, ""))
				{	soap_flag_isdxsd__availablePlatformsRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __isdws__getAvailablePlatforms * SOAP_FMAC6 soap_new___isdws__getAvailablePlatforms(struct soap *soap, int n)
{	return soap_instantiate___isdws__getAvailablePlatforms(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___isdws__getAvailablePlatforms(struct soap *soap, struct __isdws__getAvailablePlatforms *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __isdws__getAvailablePlatforms * SOAP_FMAC4 soap_instantiate___isdws__getAvailablePlatforms(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___isdws__getAvailablePlatforms(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___isdws__getAvailablePlatforms, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __isdws__getAvailablePlatforms;
		if (size)
			*size = sizeof(struct __isdws__getAvailablePlatforms);
	}
	else
	{	cp->ptr = (void*)new struct __isdws__getAvailablePlatforms[n];
		if (size)
			*size = n * sizeof(struct __isdws__getAvailablePlatforms);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __isdws__getAvailablePlatforms*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___isdws__getAvailablePlatforms(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __isdws__getAvailablePlatforms %p -> %p\n", q, p));
	*(struct __isdws__getAvailablePlatforms*)p = *(struct __isdws__getAvailablePlatforms*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__ftpUploadDoneResponse(struct soap *soap, _isdxsd__ftpUploadDoneResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__ftpUploadDoneResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__ftpUploadDoneResponse(struct soap *soap, _isdxsd__ftpUploadDoneResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneResponse);
	if (soap_out_PointerTo_isdxsd__ftpUploadDoneResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__ftpUploadDoneResponse(struct soap *soap, const char *tag, int id, _isdxsd__ftpUploadDoneResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__ftpUploadDoneResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneResponse ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__ftpUploadDoneResponse(struct soap *soap, _isdxsd__ftpUploadDoneResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__ftpUploadDoneResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneResponse ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__ftpUploadDoneResponse(struct soap *soap, const char *tag, _isdxsd__ftpUploadDoneResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__ftpUploadDoneResponse **)soap_malloc(soap, sizeof(_isdxsd__ftpUploadDoneResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__ftpUploadDoneResponse *)soap_instantiate__isdxsd__ftpUploadDoneResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__ftpUploadDoneResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__ftpUploadDoneResponse, sizeof(_isdxsd__ftpUploadDoneResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__ftpUploadDoneRequest(struct soap *soap, _isdxsd__ftpUploadDoneRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__ftpUploadDoneRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__ftpUploadDoneRequest(struct soap *soap, _isdxsd__ftpUploadDoneRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__ftpUploadDoneRequest);
	if (soap_out_PointerTo_isdxsd__ftpUploadDoneRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__ftpUploadDoneRequest(struct soap *soap, const char *tag, int id, _isdxsd__ftpUploadDoneRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__ftpUploadDoneRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneRequest ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__ftpUploadDoneRequest(struct soap *soap, _isdxsd__ftpUploadDoneRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__ftpUploadDoneRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__ftpUploadDoneRequest ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__ftpUploadDoneRequest(struct soap *soap, const char *tag, _isdxsd__ftpUploadDoneRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__ftpUploadDoneRequest **)soap_malloc(soap, sizeof(_isdxsd__ftpUploadDoneRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__ftpUploadDoneRequest *)soap_instantiate__isdxsd__ftpUploadDoneRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__ftpUploadDoneRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__ftpUploadDoneRequest, sizeof(_isdxsd__ftpUploadDoneRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__newFtpPathResponse(struct soap *soap, _isdxsd__newFtpPathResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__newFtpPathResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__newFtpPathResponse(struct soap *soap, _isdxsd__newFtpPathResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__newFtpPathResponse);
	if (soap_out_PointerTo_isdxsd__newFtpPathResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__newFtpPathResponse(struct soap *soap, const char *tag, int id, _isdxsd__newFtpPathResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__newFtpPathResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathResponse ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__newFtpPathResponse(struct soap *soap, _isdxsd__newFtpPathResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__newFtpPathResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__newFtpPathResponse ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__newFtpPathResponse(struct soap *soap, const char *tag, _isdxsd__newFtpPathResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__newFtpPathResponse **)soap_malloc(soap, sizeof(_isdxsd__newFtpPathResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__newFtpPathResponse *)soap_instantiate__isdxsd__newFtpPathResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__newFtpPathResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__newFtpPathResponse, sizeof(_isdxsd__newFtpPathResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__newFtpPathRequest(struct soap *soap, _isdxsd__newFtpPathRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__newFtpPathRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__newFtpPathRequest(struct soap *soap, _isdxsd__newFtpPathRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__newFtpPathRequest);
	if (soap_out_PointerTo_isdxsd__newFtpPathRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__newFtpPathRequest(struct soap *soap, const char *tag, int id, _isdxsd__newFtpPathRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__newFtpPathRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__newFtpPathRequest ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__newFtpPathRequest(struct soap *soap, _isdxsd__newFtpPathRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__newFtpPathRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__newFtpPathRequest ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__newFtpPathRequest(struct soap *soap, const char *tag, _isdxsd__newFtpPathRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__newFtpPathRequest **)soap_malloc(soap, sizeof(_isdxsd__newFtpPathRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__newFtpPathRequest *)soap_instantiate__isdxsd__newFtpPathRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__newFtpPathRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__newFtpPathRequest, sizeof(_isdxsd__newFtpPathRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__availableCategoriesResponse(struct soap *soap, _isdxsd__availableCategoriesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__availableCategoriesResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__availableCategoriesResponse(struct soap *soap, _isdxsd__availableCategoriesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__availableCategoriesResponse);
	if (soap_out_PointerTo_isdxsd__availableCategoriesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__availableCategoriesResponse(struct soap *soap, const char *tag, int id, _isdxsd__availableCategoriesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__availableCategoriesResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesResponse ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__availableCategoriesResponse(struct soap *soap, _isdxsd__availableCategoriesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__availableCategoriesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__availableCategoriesResponse ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__availableCategoriesResponse(struct soap *soap, const char *tag, _isdxsd__availableCategoriesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__availableCategoriesResponse **)soap_malloc(soap, sizeof(_isdxsd__availableCategoriesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__availableCategoriesResponse *)soap_instantiate__isdxsd__availableCategoriesResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__availableCategoriesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__availableCategoriesResponse, sizeof(_isdxsd__availableCategoriesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__availableCategoriesRequest(struct soap *soap, _isdxsd__availableCategoriesRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__availableCategoriesRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__availableCategoriesRequest(struct soap *soap, _isdxsd__availableCategoriesRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__availableCategoriesRequest);
	if (soap_out_PointerTo_isdxsd__availableCategoriesRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__availableCategoriesRequest(struct soap *soap, const char *tag, int id, _isdxsd__availableCategoriesRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__availableCategoriesRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__availableCategoriesRequest ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__availableCategoriesRequest(struct soap *soap, _isdxsd__availableCategoriesRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__availableCategoriesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__availableCategoriesRequest ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__availableCategoriesRequest(struct soap *soap, const char *tag, _isdxsd__availableCategoriesRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__availableCategoriesRequest **)soap_malloc(soap, sizeof(_isdxsd__availableCategoriesRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__availableCategoriesRequest *)soap_instantiate__isdxsd__availableCategoriesRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__availableCategoriesRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__availableCategoriesRequest, sizeof(_isdxsd__availableCategoriesRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__availablePlatformsResponse(struct soap *soap, _isdxsd__availablePlatformsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__availablePlatformsResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__availablePlatformsResponse(struct soap *soap, _isdxsd__availablePlatformsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__availablePlatformsResponse);
	if (soap_out_PointerTo_isdxsd__availablePlatformsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__availablePlatformsResponse(struct soap *soap, const char *tag, int id, _isdxsd__availablePlatformsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__availablePlatformsResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsResponse ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__availablePlatformsResponse(struct soap *soap, _isdxsd__availablePlatformsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__availablePlatformsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__availablePlatformsResponse ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__availablePlatformsResponse(struct soap *soap, const char *tag, _isdxsd__availablePlatformsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__availablePlatformsResponse **)soap_malloc(soap, sizeof(_isdxsd__availablePlatformsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__availablePlatformsResponse *)soap_instantiate__isdxsd__availablePlatformsResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__availablePlatformsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__availablePlatformsResponse, sizeof(_isdxsd__availablePlatformsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_isdxsd__availablePlatformsRequest(struct soap *soap, _isdxsd__availablePlatformsRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__isdxsd__availablePlatformsRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_isdxsd__availablePlatformsRequest(struct soap *soap, _isdxsd__availablePlatformsRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_isdxsd__availablePlatformsRequest);
	if (soap_out_PointerTo_isdxsd__availablePlatformsRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_isdxsd__availablePlatformsRequest(struct soap *soap, const char *tag, int id, _isdxsd__availablePlatformsRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__isdxsd__availablePlatformsRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _isdxsd__availablePlatformsRequest ** SOAP_FMAC4 soap_get_PointerTo_isdxsd__availablePlatformsRequest(struct soap *soap, _isdxsd__availablePlatformsRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_isdxsd__availablePlatformsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 _isdxsd__availablePlatformsRequest ** SOAP_FMAC4 soap_in_PointerTo_isdxsd__availablePlatformsRequest(struct soap *soap, const char *tag, _isdxsd__availablePlatformsRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (_isdxsd__availablePlatformsRequest **)soap_malloc(soap, sizeof(_isdxsd__availablePlatformsRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_isdxsd__availablePlatformsRequest *)soap_instantiate__isdxsd__availablePlatformsRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (_isdxsd__availablePlatformsRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__isdxsd__availablePlatformsRequest, sizeof(_isdxsd__availablePlatformsRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToisdxsd__CategoryArray(struct soap *soap, isdxsd__CategoryArray *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_isdxsd__CategoryArray))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToisdxsd__CategoryArray(struct soap *soap, isdxsd__CategoryArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToisdxsd__CategoryArray);
	if (soap_out_PointerToisdxsd__CategoryArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToisdxsd__CategoryArray(struct soap *soap, const char *tag, int id, isdxsd__CategoryArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_isdxsd__CategoryArray);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 isdxsd__CategoryArray ** SOAP_FMAC4 soap_get_PointerToisdxsd__CategoryArray(struct soap *soap, isdxsd__CategoryArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToisdxsd__CategoryArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 isdxsd__CategoryArray ** SOAP_FMAC4 soap_in_PointerToisdxsd__CategoryArray(struct soap *soap, const char *tag, isdxsd__CategoryArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (isdxsd__CategoryArray **)soap_malloc(soap, sizeof(isdxsd__CategoryArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (isdxsd__CategoryArray *)soap_instantiate_isdxsd__CategoryArray(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (isdxsd__CategoryArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_isdxsd__CategoryArray, sizeof(isdxsd__CategoryArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToisdxsd__PlatformArray(struct soap *soap, isdxsd__PlatformArray *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_isdxsd__PlatformArray))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToisdxsd__PlatformArray(struct soap *soap, isdxsd__PlatformArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToisdxsd__PlatformArray);
	if (soap_out_PointerToisdxsd__PlatformArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToisdxsd__PlatformArray(struct soap *soap, const char *tag, int id, isdxsd__PlatformArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_isdxsd__PlatformArray);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 isdxsd__PlatformArray ** SOAP_FMAC4 soap_get_PointerToisdxsd__PlatformArray(struct soap *soap, isdxsd__PlatformArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToisdxsd__PlatformArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 isdxsd__PlatformArray ** SOAP_FMAC4 soap_in_PointerToisdxsd__PlatformArray(struct soap *soap, const char *tag, isdxsd__PlatformArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (isdxsd__PlatformArray **)soap_malloc(soap, sizeof(isdxsd__PlatformArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (isdxsd__PlatformArray *)soap_instantiate_isdxsd__PlatformArray(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (isdxsd__PlatformArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_isdxsd__PlatformArray, sizeof(isdxsd__PlatformArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToisdxsd__Category(struct soap *soap, isdxsd__Category *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_isdxsd__Category))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToisdxsd__Category(struct soap *soap, isdxsd__Category *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToisdxsd__Category);
	if (soap_out_PointerToisdxsd__Category(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToisdxsd__Category(struct soap *soap, const char *tag, int id, isdxsd__Category *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_isdxsd__Category);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 isdxsd__Category ** SOAP_FMAC4 soap_get_PointerToisdxsd__Category(struct soap *soap, isdxsd__Category **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToisdxsd__Category(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 isdxsd__Category ** SOAP_FMAC4 soap_in_PointerToisdxsd__Category(struct soap *soap, const char *tag, isdxsd__Category **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (isdxsd__Category **)soap_malloc(soap, sizeof(isdxsd__Category *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (isdxsd__Category *)soap_instantiate_isdxsd__Category(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (isdxsd__Category **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_isdxsd__Category, sizeof(isdxsd__Category), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToisdxsd__Platform(struct soap *soap, isdxsd__Platform *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_isdxsd__Platform))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToisdxsd__Platform(struct soap *soap, isdxsd__Platform *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToisdxsd__Platform);
	if (soap_out_PointerToisdxsd__Platform(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToisdxsd__Platform(struct soap *soap, const char *tag, int id, isdxsd__Platform *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_isdxsd__Platform);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 isdxsd__Platform ** SOAP_FMAC4 soap_get_PointerToisdxsd__Platform(struct soap *soap, isdxsd__Platform **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToisdxsd__Platform(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 isdxsd__Platform ** SOAP_FMAC4 soap_in_PointerToisdxsd__Platform(struct soap *soap, const char *tag, isdxsd__Platform **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (isdxsd__Platform **)soap_malloc(soap, sizeof(isdxsd__Platform *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (isdxsd__Platform *)soap_instantiate_isdxsd__Platform(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (isdxsd__Platform **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_isdxsd__Platform, sizeof(isdxsd__Platform), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, const std::vector<isdxsd__Category * >*a)
{
	for (std::vector<isdxsd__Category * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerToisdxsd__Category(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, std::vector<isdxsd__Category * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, const char *tag, int id, const std::vector<isdxsd__Category * >*a, const char *type)
{
	for (std::vector<isdxsd__Category * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerToisdxsd__Category(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<isdxsd__Category * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, const char *tag, std::vector<isdxsd__Category * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerToisdxsd__Category(soap, -1)))
		return NULL;
	isdxsd__Category *n;
	isdxsd__Category **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_isdxsd__Category, SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Category, sizeof(isdxsd__Category), 1))
				break;
			if (!(p = soap_in_PointerToisdxsd__Category(soap, tag, NULL, "isdxsd:Category")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerToisdxsd__Category(soap, tag, &n, "isdxsd:Category"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<isdxsd__Category * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Category(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, std::vector<isdxsd__Category * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<isdxsd__Category * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Category(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Category, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<isdxsd__Category * >;
		if (size)
			*size = sizeof(std::vector<isdxsd__Category * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<isdxsd__Category * >[n];
		if (size)
			*size = n * sizeof(std::vector<isdxsd__Category * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<isdxsd__Category * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerToisdxsd__Category(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<isdxsd__Category * > %p -> %p\n", q, p));
	*(std::vector<isdxsd__Category * >*)p = *(std::vector<isdxsd__Category * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, const std::vector<isdxsd__Platform * >*a)
{
	for (std::vector<isdxsd__Platform * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerToisdxsd__Platform(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, std::vector<isdxsd__Platform * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, const char *tag, int id, const std::vector<isdxsd__Platform * >*a, const char *type)
{
	for (std::vector<isdxsd__Platform * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerToisdxsd__Platform(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<isdxsd__Platform * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, const char *tag, std::vector<isdxsd__Platform * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerToisdxsd__Platform(soap, -1)))
		return NULL;
	isdxsd__Platform *n;
	isdxsd__Platform **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_isdxsd__Platform, SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Platform, sizeof(isdxsd__Platform), 1))
				break;
			if (!(p = soap_in_PointerToisdxsd__Platform(soap, tag, NULL, "isdxsd:Platform")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerToisdxsd__Platform(soap, tag, &n, "isdxsd:Platform"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<isdxsd__Platform * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Platform(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, std::vector<isdxsd__Platform * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<isdxsd__Platform * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerToisdxsd__Platform(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerToisdxsd__Platform, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<isdxsd__Platform * >;
		if (size)
			*size = sizeof(std::vector<isdxsd__Platform * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<isdxsd__Platform * >[n];
		if (size)
			*size = n * sizeof(std::vector<isdxsd__Platform * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<isdxsd__Platform * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerToisdxsd__Platform(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<isdxsd__Platform * > %p -> %p\n", q, p));
	*(std::vector<isdxsd__Platform * >*)p = *(std::vector<isdxsd__Platform * >*)q;
}

/* End of soapC.cpp */
