/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDTEXTBALLOON_H
#define ISDTEXTBALLOON_H

/**
 * Textballoon-implementation of a commentbox.
 * Refer to the ISDCommentbox class for method-documentation.
 * @see ISDCommentbox
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <string>

#include <libinstrudeo/isdcommentbox.h>
#include <libinstrudeo/glm.h>

using namespace std;

#define TEXTBALLOON_OBJ_FILENAME (string(COMMENTBOXES_DIR_NAME)+string("/textballoon.obj"))
#define TEXTBALLOON_MESH_OBJ_NAME "TextBalloon_Mesh"
#define TEXTBALLOON_TEXTBOX_OBJ_NAME "TextBox_Plane"

#define DEFAULT_TEXTBALLOON_X 0
#define DEFAULT_TEXTBALLOON_Y 0
#define DEFAULT_TEXTBALLOON_WIDTH 300
#define DEFAULT_TEXTBALLOON_HEIGHT 200

//white, semi-transparent
#define DEFAULT_TEXTBALLOON_COLOR_R 1.0
#define DEFAULT_TEXTBALLOON_COLOR_G 1.0
#define DEFAULT_TEXTBALLOON_COLOR_B 1.0
#define DEFAULT_TEXTBALLOON_COLOR_A 0.5

//black
#define DEFAULT_TEXTBALLOON_TEXTCOLOR_R 0.0
#define DEFAULT_TEXTBALLOON_TEXTCOLOR_G 0.0
#define DEFAULT_TEXTBALLOON_TEXTCOLOR_B 0.0
#define DEFAULT_TEXTBALLOON_TEXTCOLOR_A 1.0

class ISDGLObjFile;
class ISDVideoCanvas;

class ISDTextballoon : public ISDCommentbox
{
 public:
    //-----CONSTRUCTORS-----
    ISDTextballoon(ISDVideoCanvas* parent, int id);

    virtual ~ISDTextballoon();

    //-----METHODS-----
    int getType();
    
    ISDGLObjFile* getObjFile();

    /**
     * This method is overridden by this subclass to adjust
     * the colors of the model with the specified color.
     * See the implementation for the details on coloring.
     *
     * See ISDCommentbox for more details.
     */
    virtual void setColor(float r, float g, float b, float a);

 protected:
    //-----METHODS-----
    /**
     * See ISDCommentbox::displayModel() for details about this method.
     */
    void displayModel();

    /**
     * See ISDCommentbox::getScalesTweakValues() for details about this method.
     */
    virtual void getScalesTweakValues(float values[3]);

    /**
     * Help-routine that sets the color of the mesh .obj file wrapper to the current color
     *
     * @param model The main model, this must be a valid pointer, no check is performed, caution.
     * @param meshObject The mesh object, this must be a valid pointer, no check is performed, caution.
     */
    void setMeshColor(GLMmodel* model, GLMobject* meshObject);

    //-----VARIABLES-----
    static ISDGLObjFile* objFile;
};

#endif
