/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <libinstrudeo/isdwsplatform.h>
#include <libinstrudeo/isdwscategory.h>
#include <libinstrudeo/isdrecordingmetainfo.h>

//-----CONSTRUCTORS-----
ISDRecordingMetaInfo::ISDRecordingMetaInfo()
    : ISDObject(),
      versionNumber(""),
      title(""),
      question(""),
      description("")
{
}

//-----DESTRUCTOR-----
ISDRecordingMetaInfo::~ISDRecordingMetaInfo()
{
}

//-----PUBLIC GETTERS/SETTER
void ISDRecordingMetaInfo::setVersionNumberString(Glib::ustring& value)
{
    versionNumber = value;
}
Glib::ustring& ISDRecordingMetaInfo::getVersionNumberString()
{
    return versionNumber;
}
void ISDRecordingMetaInfo::setTitle(Glib::ustring& value)
{
    title = value;
}
Glib::ustring& ISDRecordingMetaInfo::getTitle()
{
    return title;
}
void ISDRecordingMetaInfo::setQuestion(Glib::ustring& value)
{
    question = value;
}
Glib::ustring& ISDRecordingMetaInfo::getQuestion()
{
    return question;
}
void ISDRecordingMetaInfo::setDescription(Glib::ustring& value)
{
    description = value;
}
Glib::ustring& ISDRecordingMetaInfo::getDescription()
{
    return description;
}
void ISDRecordingMetaInfo::addPlatform(ISDWSPlatform* plat)
{
    platformList.push_back(plat);
}
void ISDRecordingMetaInfo::deleteAllPlatforms()
{
    platformList.clear();
}
list<ISDWSPlatform*> ISDRecordingMetaInfo::getAllPlatforms()
{
    return platformList;
}
void ISDRecordingMetaInfo::addCategory(ISDWSCategory* cat)
{
    categoryList.push_back(cat);
}
void ISDRecordingMetaInfo::deleteAllCategories()
{
    categoryList.clear();
}
list<ISDWSCategory*> ISDRecordingMetaInfo::getAllCategories()
{
    return categoryList;
}
