/*******************************************************************************************************************************************
 cdialog.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CForm
		         |--CDialog

 Dialog definition. Dialog are a convenient way to prompt the user for a small amount of input, e.g. to display a message, ask a question, 
 or anything else that does not require extensive effort on the user's part, nor on the programmer ones :-) 
 Modal dialog are handled (that is, one which freezes the rest of the application from user input until done with it).

 Xml serialization is handled on dialogs too but it is not recommended to use dialog boxes that way as a lot of them could not serialize
 all of their state and the main purpose of such widgets is to be instanciated and displayed only when needed, not to be instanciated the
 same it was from a xml dump...
*******************************************************************************************************************************************/

#ifndef __CDIALOG_H__
#define __CDIALOG_H__

#include "cform.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog return code definition
//-----------------------------------------------------------------------------------------------------------------------------------------
typedef enum
{
	DIALOG_NONE				= 0,

	DIALOG_OK				= 1L,
	DIALOG_YES				=(1L<<1),
	DIALOG_NO				=(1L<<2),

	DIALOG_REJECT				=(1L<<3),
	DIALOG_ACCEPT				=(1L<<4),
	DIALOG_CANCEL				=(1L<<5),
	DIALOG_CLOSE				=(1L<<6),
	DIALOG_APPLY				=(1L<<7),
	DIALOG_HELP				=(1L<<8)
} TDialog;

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog standard button definition
//-----------------------------------------------------------------------------------------------------------------------------------------
const static int _DBNone_			= DIALOG_NONE;
const static int _DBOk_				= DIALOG_OK;
const static int _DBYes_			= DIALOG_YES;
const static int _DBNo_				= DIALOG_NO;
const static int _DBReject_			= DIALOG_REJECT;
const static int _DBAccept_			= DIALOG_ACCEPT;
const static int _DBCancel_			= DIALOG_CANCEL;
const static int _DBClose_			= DIALOG_CLOSE;
const static int _DBApply_			= DIALOG_APPLY;
const static int _DBHelp_			= DIALOG_HELP;

const static int _DBOkCancel_			= DIALOG_OK  | DIALOG_CANCEL;
const static int _DBYesNo_			= DIALOG_YES | DIALOG_NO;
const static int _DBYesNoCancel_		= DIALOG_YES | DIALOG_NO | DIALOG_CANCEL;

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cdialog modal="true|false" [buttons="ok[,yes[,no[,reject[,accept[,cancel[,close[,apply[,help]]]]]]]]"]>
//    ...
// </cdialog>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_DIALOG_ELEMENT		("cdialog");
static CString XML_DIALOG_ATTR_MODAL		("modal");
static CString XML_DIALOG_ATTR_BUTTONS		("buttons");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDialogListener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDialogListener : public CFormListener
{
	// instanciation section
	public :

		CDialogListener			();
		virtual ~CDialogListener	() =0;

	// listener specifics
	public :

		// called when a response is emitted on the inSender dialog 
		virtual void			OnResponse			(const CObject *inSender, const TDialog inResponse)	{ }

		// associated metaclass
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_dlg', CDialogListener, CFormListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDialog class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDialog : public CForm
{
	// instanciation section
	public :

		CDialog				(CForm *inOwner=NULL, const CString &inCaption=CString(), const int inButtons=_DBNone_,
						 const bool inModal=false, const CDialogListener *inListener=NULL);
		virtual ~CDialog		();

	// protected gtk widget handling
	protected :

		// gtk widget instanciation and initialization handling
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// protected container handling
	protected :

		// gtk widget child add on or removal
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// protected CObjet redefinition
	protected :

		// expected listener type : CDialogListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CComponent redefinition
	public :

		// expected owner type : CForm
		virtual CMetaClasses		OwnerMustBe			() const;

		// owner affectation
		virtual bool			SetOwner			(CComponent *inOwner, const SInt16 inIndex=-1);

	// specific dialog functions
	public :

		// modal mode access
		void				SetModal			(const bool);
		bool				GetModal			() const;

		// dialog standard buttons access
		virtual void			SetButtons			(const int inButtons);
		int				GetButtons			() const;

		// dialog form run, action code to perform as a return value
		virtual TDialog			Run				();
		
		// dialog run end request
		virtual void			Response			(const TDialog);

	// CSerialized redefinition
	public :

		// gtkol dialog xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// protected attributes
	protected :

		// dialog title, standard buttons that are used, modal state
		CString				m_Caption;
		bool				m_Modal;
		int				m_Buttons;

		// metaclass assocation
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('dlog', CDialog, CForm);

#endif
