/** \file
 * Defines the allocator interface as used by the Builder class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/06/01 12:10:40 $
 * \version $Revision: 1.5 $
 */

#ifndef __INCLUDE_FACTORY_ALLOCBASE_H__
#define __INCLUDE_FACTORY_ALLOCBASE_H__

namespace Factory
{
  /**
     _Alloc_base acts as a reference implementation for libfactory++
     allocators. They interface follows std::allocator conventions.
  */

  template <typename _Type, typename _Alloc>
    class _Alloc_base
    { 
    public:
      inline
      _Alloc_base(_Alloc const& __A)
        : _M_allocator(__A) {}
    
      inline _Alloc
      get_allocator() const
      {
        return _M_allocator;
      }

    protected:
      _Alloc _M_allocator;

      _Type*
      _M_allocate() const
      {
        return this->get_allocator().allocate(1);
      }

      void
      _M_deallocate(_Type* const __P) const
      {
        return this->get_allocator().deallocate(__P, 1);
      }
    };
}; // namespace Factory

#endif //include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
