/***************************************************************************
                           csearchindex.h  -  description
                             -------------------
    begin                : Mon May 14 2003
    copyright            : (C) 2003-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHINDEX_H
#define CSEARCHINDEX_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>

#pragma pack(1)

typedef struct filebaseobject {
	/** */
	unsigned int m_eFileType;
	/** */
	ulonglong m_nSize;
	/** */
	unsigned long m_nPathIndex;
	/** */
	unsigned long m_nFileIndex;
	/** */
	unsigned long m_nHashIndex;
	/** */
	time_t m_tModTime;
} filebaseobject;

typedef struct searchindexobject {
	/** */
	unsigned long m_nIndex;
	/** */
	unsigned long m_nFileIndex;
} searchindexobject;

typedef struct fileindexobject {
	/** */
	ulonglong m_nFileBaseIndex;
	/** */
	unsigned long m_nNext;
} fileindexobject;

typedef struct hashbaseobject {
	/** */
	ulonglong m_nSize;
	/** */
	unsigned long m_nPathIndex;
	/** */
	unsigned long m_nFileIndex;
	/** */
	unsigned long m_nHashIndex;
	/** */
	unsigned long m_nHashLeavesIndex;
	/** */
	time_t m_tModTime;
} hashbaseobject;

typedef struct long_s {
	/** */
	unsigned long n;
} long_s;

#pragma pack()

class CByteArray;

class DLL_EXPORT CSearchIndex : public CObject {

public:
	/** */
	CSearchIndex();
	/** */
	virtual ~CSearchIndex();

	/** */
	bool LoadIndex();
	/** */
	void SaveIndex();
	/** */
	void Reset();
	/** */
	void ResetIndex();
	/** */
	void ResetHashIndex();
	/** */
	void InitIndex();

	/** */
	CStringList * Search( CString s );
	/** */
	CStringList * SearchHash( unsigned char * hash );

	/** */
	bool GetFileBaseObject( ulonglong index, struct filebaseobject * fbo );
	/** */
	bool GetFileBaseObject( CString id, struct filebaseobject * fbo, CString & filename );

	/** */
	CString GetFileName( ulonglong i );
	/** */
	void AddIndex( CString & s, ulonglong filebaseindex );
	/** */
	unsigned long AddIndex( CFileInfo *fileinfo, CString path, eFileTypes filetype );
	/** */
	void UpdateIndex( ulonglong index, struct filebaseobject * fbo );
	/** */
	unsigned long IndexCount();
	
	/** */
	bool FindHash( unsigned char * hash, ulonglong * hi );
	/** */
	CString GetHash( ulonglong hbi );
	/** */
	bool HashBaseIndexFromHashIndex( ulonglong hi, ulonglong * hbi );
	/** */
	bool BaseIndexFromHashBaseIndex( ulonglong hbi, ulonglong * bi );
	/** */
	void AddHashIndex( ulonglong filebaseindex, unsigned char * hash, unsigned char * leaves, unsigned int lsize );
	/** */
	bool FindHashBaseIndex( struct filebaseobject * fbo, ulonglong * hbi );
	/** */
	bool Compare( struct filebaseobject * fbo, struct hashbaseobject * hbo );
	/** Get the TTH leaves for the given TTH */
	CByteArray * GetHashLeaves( CString tth );
	/** Opens the hashleaves file */
	bool OpenHashLeaves();
	/** Closes the hashleaves file */
	bool CloseHashLeaves();
	/** Rebuild the byte arrays, removing no longer needed data */
	void RebuildLists();

private:
	/** */
	struct searchindexobject * FindIndex( CString & s );
	/** */
	struct searchindexobject * SearchIndex( CString & s );

	/** */
	CByteArray * m_pFileBaseArray;
	/** */
	CByteArray * m_pPathBaseArray;
	/** */
	CByteArray * m_pBaseArray;
	/** */
	CByteArray * m_pSearchIndex;
	/** */
	CByteArray * m_pSearchFileIndex;
	/** */
	CByteArray * m_pSearchBase;
	/** */
	CByteArray * m_pSearchArray[0x100];
	/** */
	struct long_s * m_nSearchFileIndex;
	
	/** */
	CByteArray * m_pHashBaseArray;
	/** */
	CByteArray * m_pHashFileBaseArray;
	/** */
	CByteArray * m_pHashPathBaseArray;
	/** */
	CByteArray * m_pHashIndex;
	/** */
	CByteArray * m_pHashLeaves;
};

#endif
