/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "complearn-vcblocksort.h"

#include "complearn-vcblocksort-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 8 "complearn-vcblocksort.gob"

/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <assert.h>
#include <math.h>
#include <libintl.h>

#define MAXSTATES 13
#define CREDULITY 52
#define STATELOGBASE 1.532

#define _(O) gettext(O)

/*! \file ncblocksort.c */

struct BlockSortCompressionInstance {
  void *baseClass;
  int code2state[256];
  int nstates;
  int *x, *p, allocated;
};

void complearn_suffix_sort(int *x, int *p, int n, int k, int l);
static void resetStatistics(struct BlockSortCompressionInstance *bsci);

static void freeBSCI( struct BlockSortCompressionInstance *bsci)
{
  if (bsci->allocated > 0) {
    free(bsci->x);
    free(bsci->p);
    bsci->allocated = 0;
    bsci->x = NULL;
    bsci->p = NULL;
  }
  free(bsci);
}

static double bs_compress(struct BlockSortCompressionInstance *CI,
			  unsigned char *data, int size) {
  int *x, *p;
  int i, j, mass, av;
  unsigned char code2byte[256];
  int num[256], total[MAXSTATES], state, oldstate;
  int statetrans[MAXSTATES][MAXSTATES], ntrans[MAXSTATES];
  double cl = 0;

  /* Obtain workspace in x and p */
  if (CI->allocated < size+1) {
    CI->allocated = 10 + size * 1.2;
    CI->x = realloc(CI->x, CI->allocated * sizeof(int));
    CI->p = realloc(CI->p, CI->allocated * sizeof(int));
    if (CI->x==NULL || CI->p==NULL) { assert(0 && "blocksort logic error"); }
  }
  x = CI->x;
  p = CI->p;

  /* Suffix sort the data (permutes x and p) */
  for (i=0; i<size; i++) x[i] = data[i];
  complearn_suffix_sort(x, p, size, UCHAR_MAX+1, 0);

  /* Initialise state transition statistics */
  for (j=0; j<MAXSTATES; j++) {
    total[j]  = 0;
    ntrans[j] = MAXSTATES;
    for (i=0; i<MAXSTATES; i++) statetrans[j][i] = 1;
  }
  statetrans[0][0]--; ntrans[0]--;

  /* Initialise the move to front codebook and the symbol frequencies */
  for (i=0; i<256; i++) {
    code2byte[i] = i;
    num[i] = 1;
    total[CI->code2state[i]]++;
  }

  state = CI->nstates-1;

  /* Code the block sorted sequence */
  for (i=0; i<size+1; i++) {
    unsigned char c;
    unsigned char carry1, carry2;
    int code;

    c = p[i] ? data[(p[i]+size)%(size+1)] : code2byte[0];

    /* Move to front:
       - if the symbol is at position 1 of the code book, then move it
         to position 0
       - otherwise move it to position 1.
       (Why? Because it improves compression. Why? No-one knows.)
    */
    code = 0;
    carry2 = code2byte[0];
    if (carry2!=c) {
      carry1 = code2byte[++code];
      if (carry1==c) {
	code2byte[0] = (unsigned char)c;
	code2byte[1] = carry2;
      } else {
	code2byte[1] = (unsigned char)c;
	for (;;) {
	  carry2 = code2byte[++code];
	  code2byte[code] = carry1;
	  if (carry2 == c) break;
	  carry1 = code2byte[++code];
	  code2byte[code] = carry2;
	  if (carry1 == c) break;
	}
      }
    }


    /* Encoding takes place in three stages:

       1. Encode a state transition.
          The state depends on the symbol to be encoded through the
	  lookup table CI->code2state[]. We keep statistics on state
	  transition frequencies through statetrans[<state>][<state>]
	  and ntrans[<state>].

       2. Encode the symbol.
          Decoder already knows it must be one of the symbols that map
	  to the current state. We keep statistics on those as well,
	  this time through the arrays num[<symbol>] and total[<state>].
	  Notice that some states only contain a single symbol; if we are
	  in such a state then automatically zero bits are used in this
	  stage.

       3. Run length encode zeroes.
          If the symbol was a zero, then encode the number of zeroes that
          follow, instead of coding each of them separately. This is necessary
	  because often sequences of zeroes occur that are highly dependent:
	  the probability that the next symbol is also a zero is often much
	  higher if the previous TWO symbols are zero than if only the
	  previous symbol is a zero, etc.

    */

    /* Stage 1. Encode the state transition. */
    oldstate = state;
    state = CI->code2state[code];

    cl += -log(statetrans[oldstate][state])+log(ntrans[oldstate]);
    statetrans[oldstate][state]++;
    ntrans[oldstate]++;

    /* 2. Encode the symbol from the range that belongs to this state */
    cl += -log(num[code])+log(total[state]);

    mass = CREDULITY;
    for (j=code; j>=0 && num[j]*(code-j)<mass; j--)
      mass += num[j];
    av = mass / (code-j);
    for (j++; j<=code; j++) {
      total[CI->code2state[j]] += av - num[j];
      num[j] = av;
    }

    /* Stage 3. Run length encode zeroes.
       We take as a probability distribution on the integers: P(n)=1/(n(n+1))
       It is easy to check that this sums to one for 1 <= n < infinity.
       The corresponding code uses -log P(n) bits to encode n.
       Motivation: the codelength is logarithmic in n, so it can never be
       extremely inefficient. At the same time, a relatively high probability
       is assigned to low numbers.
    */
    if (code==0 && i<size) {
      int runlength = i;
      i++;
      while (i<size+1) {
	if (p[i] && data[(p[i]+size)%(size+1)] != code2byte[0]) break;
	i++;
      };
      runlength = i - runlength;
      i--;

      cl += log(runlength) + log(runlength+1);
    }
  }

  return (cl + log(size)) / M_LN2;
}

static double simple_bs_compress(const GString *inp)
{
  double result;
  struct BlockSortCompressionInstance *bsci;
  bsci = calloc(sizeof(*bsci), 1);
  resetStatistics(bsci);
  result = bs_compress(bsci, (unsigned char *) inp->str, inp->len);
  freeBSCI(bsci);
  return result;
}

static void resetStatistics(struct BlockSortCompressionInstance *bsci)
{
  int i, d, m, s;
  double prev, cur;
  m = 0;
  prev = 0;
  s = 0;
  for (i=0; i<256; i++) {
    cur = log(i+1.0)/log(STATELOGBASE);
    d = (int)cur-(int)prev;
    if (d>1) m+=(d-1);
    s = (int)cur - m;
    bsci->code2state[i] = s;
    prev = cur;
  }
  bsci->nstates = s+1;
  if (bsci->nstates > MAXSTATES) {
    assert(0 && "MAXSTATES should be larger.");
    exit(1);
  }
}


#line 275 "complearn-vcblocksort.c"
/* self casting macros */
#define SELF(x) COMPLEARN_VCBLOCKSORT(x)
#define SELF_CONST(x) COMPLEARN_VCBLOCKSORT_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_VCBLOCKSORT(x)
#define TYPE_SELF COMPLEARN_TYPE_VCBLOCKSORT
#define SELF_CLASS(x) COMPLEARN_VCBLOCKSORT_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_VCBLOCKSORT_GET_CLASS(x)

/* self typedefs */
typedef CompLearnVCBlockSort Self;
typedef CompLearnVCBlockSortClass SelfClass;

/* here are local prototypes */
static void complearn_vcblocksort_init (CompLearnVCBlockSort * o) G_GNUC_UNUSED;
static void complearn_vcblocksort_class_init (CompLearnVCBlockSortClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static CompLearnRealCompressorAdaptorClass *parent_class = NULL;

/* Short form macros */
#define self_new complearn_vcblocksort_new
#define self_compress complearn_vcblocksort_compress
#define self_decompress complearn_vcblocksort_decompress
#define self_blurb complearn_vcblocksort_blurb
#define self_name complearn_vcblocksort_name
#define self_compressor_version complearn_vcblocksort_compressor_version
#define self_binding_version complearn_vcblocksort_binding_version
#define self_compressed_size complearn_vcblocksort_compressed_size
#define self_is_just_size complearn_vcblocksort_is_just_size
#define self_clone complearn_vcblocksort_clone


static void
___CompLearn_Real_Compressor_init (CompLearnRealCompressorIface *iface)
{
#line 267 "complearn-vcblocksort.gob"
	iface->compress = self_compress;
#line 271 "complearn-vcblocksort.gob"
	iface->decompress = self_decompress;
#line 275 "complearn-vcblocksort.gob"
	iface->blurb = self_blurb;
#line 279 "complearn-vcblocksort.gob"
	iface->name = self_name;
#line 283 "complearn-vcblocksort.gob"
	iface->compressor_version = self_compressor_version;
#line 287 "complearn-vcblocksort.gob"
	iface->binding_version = self_binding_version;
#line 291 "complearn-vcblocksort.gob"
	iface->compressed_size = self_compressed_size;
#line 295 "complearn-vcblocksort.gob"
	iface->is_just_size = self_is_just_size;
#line 299 "complearn-vcblocksort.gob"
	iface->clone = self_clone;
#line 330 "complearn-vcblocksort.c"
}

GType
complearn_vcblocksort_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnVCBlockSortClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_vcblocksort_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnVCBlockSort),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_vcblocksort_init,
			NULL
		};

		static const GInterfaceInfo CompLearn_Real_Compressor_info = {
			(GInterfaceInitFunc) ___CompLearn_Real_Compressor_init,
			NULL,
			NULL
		};

		type = g_type_register_static (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR, "CompLearnVCBlockSort", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			COMPLEARN_TYPE_REAL_COMPRESSOR,
			&CompLearn_Real_Compressor_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnVCBlockSort *)g_object_new(complearn_vcblocksort_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnVCBlockSort * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnVCBlockSort *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnVCBlockSort *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnVCBlockSort *)g_object_new_valist (complearn_vcblocksort_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
complearn_vcblocksort_init (CompLearnVCBlockSort * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::init"
}
#undef __GOB_FUNCTION__
static void 
complearn_vcblocksort_class_init (CompLearnVCBlockSortClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::class_init"

	parent_class = g_type_class_ref (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR);

}
#undef __GOB_FUNCTION__



#line 262 "complearn-vcblocksort.gob"
GObject * 
complearn_vcblocksort_new (void)
#line 405 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::new"
{
#line 263 "complearn-vcblocksort.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    return G_OBJECT (ret);
  }}
#line 414 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 267 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_compress (CompLearnRealCompressor * rc, const GString * input)
#line 420 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::compress"
{
#line 268 "complearn-vcblocksort.gob"
	
    return NULL;
  }}
#line 428 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 271 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_decompress (CompLearnRealCompressor * rc, const GString * input)
#line 434 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::decompress"
{
#line 272 "complearn-vcblocksort.gob"
	
    return NULL;
  }}
#line 442 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 275 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_blurb (CompLearnRealCompressor * rc)
#line 448 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::blurb"
{
#line 276 "complearn-vcblocksort.gob"
	
    return g_string_new(_("non-coding blocksort with fractional bit return"));
  }}
#line 456 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 279 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_name (CompLearnRealCompressor * rc)
#line 462 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::name"
{
#line 280 "complearn-vcblocksort.gob"
	
    return g_string_new("blocksort");
  }}
#line 470 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 283 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_compressor_version (CompLearnRealCompressor * rc)
#line 476 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::compressor_version"
{
#line 284 "complearn-vcblocksort.gob"
	
    return g_string_new("0.0.0");
  }}
#line 484 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 287 "complearn-vcblocksort.gob"
GString * 
complearn_vcblocksort_binding_version (CompLearnRealCompressor * rc)
#line 490 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::binding_version"
{
#line 288 "complearn-vcblocksort.gob"
	
    return g_string_new("0.0.0");
  }}
#line 498 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 291 "complearn-vcblocksort.gob"
gdouble 
complearn_vcblocksort_compressed_size (CompLearnRealCompressor * rc, const GString * input)
#line 504 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::compressed_size"
{
#line 292 "complearn-vcblocksort.gob"
	
    return simple_bs_compress(input);
  }}
#line 512 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 295 "complearn-vcblocksort.gob"
gboolean 
complearn_vcblocksort_is_just_size (CompLearnRealCompressor * rc)
#line 518 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::is_just_size"
{
#line 296 "complearn-vcblocksort.gob"
	
    return TRUE;
  }}
#line 526 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__

#line 299 "complearn-vcblocksort.gob"
CompLearnRealCompressor * 
complearn_vcblocksort_clone (CompLearnRealCompressor * rc)
#line 532 "complearn-vcblocksort.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCBlockSort::clone"
{
#line 300 "complearn-vcblocksort.gob"
	
    CompLearnVCBlockSort *res = COMPLEARN_VCBLOCKSORT(complearn_vcblocksort_new());
    return COMPLEARN_REAL_COMPRESSOR(res);
    }}
#line 541 "complearn-vcblocksort.c"
#undef __GOB_FUNCTION__
