/*
 * dmnt.c -- SunOS mount functions for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.4 99/11/10 15:01:49 abe Exp $";
#endif


#include "lslk.h"


/*
 * readmnt() -- read mount table information
 */

int
readmnt()
{
	char c;
	dev_t dev;
	char *dn = NULL;
	int err, n, na, nl, v;
	MALLOC_S len;
	char *ln, *m, *o, *oo, *s;
	FILE *mfp;
	struct mntent me, *mp;
	struct stat sb;
/*
 * Open the mount table (usually /etc/mnttab).
 */
	if ((mfp = setmntent(MOUNTED, "r")) == NULL) {
	    (void) fprintf(stderr, "%s: can't access %s: %s\n",
		Pn, MOUNTED, strerror(errno));
	    return(1);
	}
/*
 * Read the mount table.
 */
	na = 0;
	while ((mp = getmntent(mfp)) != NULL) {

	/*
	 * Skip all but 4.2 devices -- i.e., the ones that have inodes.
	 */
	    if (strcmp(mp->mnt_type, MNTTYPE_42))
		continue;
	/*
	 * Get the MNTINFO_DEV mount option character address.  Use statsafely()	 * on mount entries without one.
	 */
	    if (!(oo = hasmntopt(mp, MNTINFO_DEV))) {

	    /*
	     * Interpolate a possible symbolic directory link.
	     */
		if (dn)
		    (void) free((MALLOC_P *)dn);
		if ((dn = (char *)malloc((MALLOC_S)(strlen(mp->mnt_dir) + 1)))
		== (char *)NULL) {
		    (void) fprintf(stderr,
			"%s: no space for mount at %s (%s)\n",
			Pn, mp->mnt_fsname, mp->mnt_dir);
		    Exit(1);
		}
		(void) strcpy(dn, mp->mnt_dir);
		if ((ln = Readlink(dn)) == NULL) {
		    if (Owarn) {
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    continue;
		}
		if (ln != dn) {
		    (void) free((MALLOC_P *)dn);
		    dn = ln;
		}
		if (statsafely(dn, &sb)) {
		    (void) fprintf(stderr,
			"%s: can't stat() %s file system: %s\n",
			Pn, mp->mnt_dir, strerror(errno));
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		    continue;
		}
		dev = sb.st_dev;
	    } else {

	    /*
	     * Convert the value after MNTOPT_DEV= to a hexadecimal device
	     * number.
	     */
		o = oo + strlen(MNTINFO_DEV) + 1;
		if (strncasecmp(o, "0x", 2) == 0)
		    o += 2;
		for (nl = (sizeof(dev_t) * 2), dev = err = n = 0; *o; o++) {
		    if (isdigit(*o))
			v = (unsigned char)(*o - 0);
		    else if (isalpha(*o) && (c = toupper(*o)) >= 'A'
			 && c <= 'F')
		    {
			v = (unsigned char)(c - 'A' + 10);
		    } else
			break;
		    if (++n > nl) {
			err = 1;
			break;
		    }
		    dev = (dev << 4) | (v & 0xf);
		}
		if (err) {
		    (void) fprintf(stderr,
			"%s: can't convert device (%s) for %s: %s\n",
			Pn, oo, mp->mnt_fsname, mp->mnt_dir);
		    return(1);
		}
	    }
	/*
	 * See if there's room in the local mount table for another entry.
	 */
	    if (NMnt >= na) {

	    /*
	     * Increase the space allocated to the local mount table and
	     * reserve space for the increase.
	     */
		na += 10;
		len = (MALLOC_S)(na * sizeof(struct mounts));
		if (Mnt)
		    Mnt = (struct mounts *)realloc((MALLOC_P *)Mnt, len);
		else
		    Mnt = (struct mounts *)malloc(len);
		if (!Mnt) {
		    (void) fprintf(stderr,
			"%s: no space for %d mount structures at %s: %s\n",
			Pn, na, mp->mnt_fsname, mp->mnt_dir);
		    (void) endmntent(mfp);
		    return(1);
		}
	    }
	/*
	 * Allocate space for what's been mounted (fsname) and where
	 * it's been mounted (dir).
	 */
	    if (!(m = (char *)malloc(strlen(mp->mnt_dir)+1))) {
		(void) fprintf(stderr, "%s: no room for directory: %s\n",
		    Pn, mp->mnt_dir);
		(void) endmntent(mfp);
		return(1);
	    }
	    (void) strcpy(m, mp->mnt_dir);
	    if (!(s = (char *)malloc(strlen(mp->mnt_fsname)+1))) {
		(void) fprintf(stderr, "%s: no room for fsname: %s\n",
			Pn, mp->mnt_fsname);
		(void) endmntent(mfp);
		return(1);
	    }
	    (void) strcpy(s, mp->mnt_fsname);
	/*
	 * Create the new local mount information entry.
	 */
	    Mnt[NMnt].dev = dev;
	    Mnt[NMnt].sp = s;
	    Mnt[NMnt].priv = (caddr_t)NULL;
	    Mnt[NMnt++].mntp = m;
	}
	(void) endmntent(mfp);
	return(0);
}
