
/*!
 ************************************************************************
 * \file mv-search.h
 *
 * \brief
 *   array definition for motion search
 *
 * \author
 *    Inge Lille-Langoy               <inge.lille-langoy@telenor.com>   \n
 *    Copyright (C) 1999  Telenor Satellite Services, Norway
 *
 ************************************************************************
 */

#ifndef _MV_SEARCH_H_
#define _MV_SEARCH_H_

//! convert from H.263 QP to H.264 quant given by: quant=pow(2,QP/6)
const int QP2QUANT[40]=
{
   1, 1, 1, 1, 2, 2, 2, 2,
   3, 3, 3, 4, 4, 4, 5, 6,
   6, 7, 8, 9,10,11,13,14,
  16,18,20,23,25,29,32,36,
  40,45,51,57,64,72,81,91
};

// Vertical MV Limits (integer/halfpel/quarterpel)
// Currently only Integer Pel restrictions are used, 
// since the way values are specified 
// (i.e. mvlowbound = (levelmvlowbound + 1) and the way
// Subpel me is performed subpel will always be within range.
 
const int LEVELMVLIMIT[17][6] =
{
  {  -63,  63,  -128,  127,  -256,  255},
  {  -63,  63,  -128,  127,  -256,  255},
  { -127, 127,  -256,  255,  -512,  511},
  { -127, 127,  -256,  255,  -512,  511},
  { -127, 127,  -256,  255,  -512,  511},
  { -127, 127,  -256,  255,  -512,  511},
  { -255, 255,  -512,  511, -1024, 1023},
  { -255, 255,  -512,  511, -1024, 1023},
  { -255, 255,  -512,  511, -1024, 1023},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047},
  { -511, 511, -1024, 1023, -2048, 2047}

  /*
  {  -64,  63,  -128,  127,  -256,  255},
  {  -64,  63,  -128,  127,  -256,  255},
  { -128, 127,  -256,  255,  -512,  511},
  { -128, 127,  -256,  255,  -512,  511},
  { -128, 127,  -256,  255,  -512,  511},
  { -128, 127,  -256,  255,  -512,  511},
  { -256, 255,  -512,  511, -1024, 1023},
  { -256, 255,  -512,  511, -1024, 1023},
  { -256, 255,  -512,  511, -1024, 1023},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047},
  { -512, 511, -1024, 1023, -2048, 2047}
  */
};
#endif

