/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandEnd: public LWParityCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) argc;
	(void) args;
	
	return NULL;
}

const gchar *getName ()
{
	return "end";
}	

gchar *getHint ()
{
	return _("Close logical block");
}

gboolean isOpen ()
{
	return FALSE;
}

void matchWith (LWCommand *cmd)
{
	if (g_strcasecmp (cmd->getName(), "begin"))
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
}

gboolean canBeSkiped ()
{
	return TRUE;
}

gboolean matchAsLastOne ()
{
	return TRUE;
}

};

LWSymbol *new_LWCommandEnd()
{
	return new LWCommandEnd();
}
