# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import gobject
from time import time

import config

from widget.misc import ScrolledWindow
from widget.progress import action_progress

from library import library_wrapper
from source.local_source import LocalSource
from source.ipod_source import IpodSource
from source.filesystem_source import FileSystemSource
from source._source import PlaylistSourceItem
#from source.daap_source import DaapSource

from source.audiocd_source import AudioCDSource
from source.info_source import *
from helper import helper
from hal import hal


TIME_BEFORE_AUTOSELECT = 500

class SourceUI(gtk.VBox):
    def __init__(self,player):
        super(SourceUI,self).__init__(False,12)


        
        #Source, item,name, pixbuf, height, sensitive
        model = gtk.ListStore(object,object,str,gtk.gdk.Pixbuf,int,bool,bool)

        self.tree = gtk.TreeView()
        self.tree.set_model(model)
        
        self.tree.set_headers_visible(False)

        #self.tree.insert_column_with_attributes(-1,"",,pixbuf=3,height=4)
        #self.tree.insert_column_with_attributes(-1,"",r,text=2,height=4,editable=5)
        
        rp = gtk.CellRendererPixbuf()
        rt = gtk.CellRendererText()
        rt.connect("edited",self.on_edition)
        col = gtk.TreeViewColumn()
        col.pack_start(rp,False)
        col.pack_start(rt,True)
        col.set_attributes(rp,pixbuf=3,height=4)
        col.set_attributes(rt,markup=2,height=4,editable=5)
        col.add_attribute(rt,"editable-set",6)
        
        self.tree.append_column(col)
        
        #self.tree.get_column(0).set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        #self.tree.get_column(0).set_fixed_width(30)
        self.tree.get_selection().connect("changed", self.on_selection)

        self.tree.set_enable_search(False)
        
        self.id_motion_drag = None
        self.is_in_drag_motion = False
        self.motion_drag_current_path = None
        self.real_selected_row = None
        
        targets = [("text/listen-songs", gtk.TARGET_SAME_APP, 1)]#,("text/uri-list", 0, 2)]
        self.tree.enable_model_drag_dest(targets, gtk.gdk.ACTION_COPY)
        self.tree.enable_model_drag_source(gtk.gdk.BUTTON1_MASK, targets, gtk.gdk.ACTION_COPY)
        self.tree.connect("drag-data-get", self.on_drag_data_get)
        self.tree.connect("drag-data-received", self.on_drag_data_received)
        self.tree.connect("row-activated", self.on_activated)
        
        """ Need found how show mouseover interaction  """
        #self.tree.connect("drag-motion",self.on_drag_motion)
        #self.tree.connect("drag-leave",self.on_drag_leave)
        
        
        self.tree.connect("key-press-event", self.on_key_press)
        self.tree.connect("popup-menu",self.__popup_menu)
        self.tree.connect('button-press-event', self.__button_press)
        
        self.tree.set_row_separator_func(self.row_separator)
        
        self.box_source = gtk.VBox()        
        box = gtk.VBox(spacing=6)
        box.pack_start(self.box_source,True,True)
        box.pack_start(action_progress,False,False)
        
        sep = gtk.VSeparator()
        self.pane = gtk.HPaned()
        self.pack_start(self.pane,True,True)
       
        self.pane.pack1(ScrolledWindow(self.tree), False, True)
        self.pane.pack2(box,True,True)
        
        self.pane.set_position(int(config.get("window","pos_organizer")))

        #FIXME: Ready to replace by a dynamic load
        self.source_class = [
                             LocalSource,
                             IpodSource,
                             ContextSource,
                             CurrentInfoSource,
                             LyricsSource,
                             WikiSource,
                             LastFmSource, 
                             FileSystemSource,
                             AudioCDSource,
#                             DaapSource
                             ]
                        
        tmp = [(source.load_priority,source.__name__,source) for source in self.source_class]
        tmp.sort()
        
        tmp2 =  {}
        for load_priority,name,source in tmp:
            tmp2[name] = source(player)
        
        tmp3  = [(source.__name__,tmp2[source.__name__]) for source in self.source_class]
        
        self.source_list = []
        self.source_by_name = {}
        for source in tmp3:
            self.source_list.append(source[1])
            self.source_by_name[source[0]] = source[1]
                             
        self.last_selected = None
        self.load(player)
        #gobject.timeout_add(2000,self.load,player)
        
        helper.connect("source-updated",self.populate)
        helper.connect("edit-source",self.on_edition_demand)
        helper.connect("edit-playlist",self.edit_playlist)
        helper.connect("show-wikipedia",self.select_wikipedia)
        helper.connect("show-lyrics",self.select_lyrics)
        
   
    def row_separator(self,model, iter):
        return model[iter][0] == None
    
    def save(self):
        for source in self.source_list:
            source.save()
        iter = self.tree.get_selection().get_selected()
        if not iter or not iter[1]: path=0
        else: path = self.tree.get_model().get_path(iter[1])[0]
        config.set("source","selected_index","%d"%path)
        config.set("window","pos_organizer","%d"%self.pane.get_position())
        
    def load(self,player):
        source_load = [(source.load_priority,source) for source in self.source_list]
        source_load.sort()
        for load_priority,source in source_load:
            gobject.idle_add(source.load,player)
        gobject.idle_add(self.__init_populate)

    def __init_populate(self):
        self.populate(init=True)
    
    def select_wikipedia(self,*args):
        self.force_select("wikipedia")
        
    def select_lyrics(self,*args):
        self.force_select("lyrics")
        
    def force_select(self,id):
        for i,row in enumerate(self.tree.get_model()):
            if row[0] and row[1].source_id == id:
                self.tree.get_selection().select_path(i)
                break
            
    def populate(self,helper=None,*param,**kwargs):
        model = self.tree.get_model()   
        model.clear()

        self.last_selected = None
        default_selected_iter = None
        
        for child in self.box_source.get_children():
            self.box_source.remove(child)    
        previous_item = None
        slist = [(s.display_index,s) for s in self.source_list]
        slist.sort()

        for display_index,source in slist:
            for item in source.get_items():
                if not item.is_hidden():

                    if previous_item and item.has_top_separateur and not previous_item.has_bottom_separateur:
                        model.append((None,None,"",None,-1,False,False))
                        
                    icon = self.tree.render_icon(stock_id=item.stock,size=gtk.ICON_SIZE_LARGE_TOOLBAR,detail=None)
                    iter = model.append((source,item,item.label,icon,26,item.editable,False))
                    
                    self.box_source.pack_start(item.widget,True,True)
                    item.widget.show_all()
                    item.widget.set_no_show_all(True)
                    item.widget.hide()
                    if item.has_bottom_separateur:
                        model.append((None,None,"",None,-1,False,False))
                        
                    previous_item = item
                    if item.default_selected:
                        default_selected_iter = iter
                    if item.selected:
                        self.last_selected = item
                        self.tree.get_selection().select_iter(iter)
            
        if not self.last_selected:
            if kwargs.has_key("init") and kwargs["init"]:
                path = (int(config.get("source","selected_index")),)
                self.tree.get_selection().select_path(path)
            else:
                if default_selected_iter:
                    self.tree.get_selection().select_iter(default_selected_iter)
                else:
                    self.tree.get_selection().select_path(0)
                


    def on_selection(self,treeselection):  
        model,iter = treeselection.get_selected()
        if iter!=None: 
            
            childs = self.box_source.get_children()    
            """
            if len(childs)>0:
                self.box_source.remove(childs[0])    
            self.box_source.pack_start(model[iter][1].widget,True,True)
            self.box_source.show_all()
            for child in childs:
                child.hide_all()
            """
            if self.last_selected:
                self.last_selected.selected = False
                self.last_selected.widget.hide()
            model[iter][1].widget.show()
            model[iter][1].selected = True

            self.last_selected = model[iter][1]
            
    def edit_playlist(self,helper,pl):
        path = None
        model = self.tree.get_model()
        for path in range(0,len(model)):
            item =  model[path][1]
            if isinstance(item,PlaylistSourceItem) and not item.is_hidden() and item.pl==pl:
                break;
        if path:
            self.tree.set_cursor(path, self.tree.get_column(0), True)    
        
    def on_edition_demand(self,*param):
        model,iter = self.tree.get_selection().get_selected()
        self.tree.set_cursor(model.get_path(iter), self.tree.get_column(0), True)
        
    def on_edition(self,cell,path, new_text):
        if self.tree.get_model()[path][1].on_edition(new_text):
            self.tree.get_model()[path][2] = new_text
            
        
    def on_activated(self,treeview, path, view_column):
        treeview.get_model()[path][1].on_activated()
            
    def on_drag_leave(self,widget, drag_context, timestamp):
        if self.id_motion_drag!=None:
            gobject.source_remove(self.id_motion_drag)
            self.id_motion_drag=None    
            
        
    def on_drag_motion(self,widget, drag_context, x, y, timestamp):
        
        drop_info = self.tree.get_dest_row_at_pos(x, y)
        if drop_info:
            path, position = drop_info
            path = path[0]
            #if position == gtk.TREE_VIEW_DROP_AFTER:
            #    path += 1
               
            #For automatic selection when drag drop 
            if self.id_motion_drag!=None:
                gobject.source_remove(self.id_motion_drag)
                self.id_motion_drag=None
            self.id_motion_drag = gobject.timeout_add(TIME_BEFORE_AUTOSELECT,self.on_drag_motion_cb, path)
            
            if self.tree.get_model()[path][1] and self.tree.get_model()[path][1].is_droppage:
                drag_context.drag_status(gtk.gdk.ACTION_COPY,0L)
                return True
            else:
                drag_context.drag_status(gtk.gdk.ACTION_PRIVATE,0L)
                return True
                
        else:
            drag_context.drag_status(gtk.gdk.ACTION_PRIVATE,0L)    
            return True

    def on_drag_motion_cb(self, path):
        self.tree.get_selection().select_path(path)
        if self.id_motion_drag!=None:
            gobject.source_remove(self.id_motion_drag)
            self.id_motion_drag=None
        

    def on_key_press(self, widget, event):
        model, row = self.tree.get_selection().get_selected()
        if row!=None:
            item = self.tree.get_model()[row][1]
            return item.on_key_press(event)
        else:
            return False
        
    def on_drag_data_get(self,treeview, context, selection, info, timestamp):
        self.is_in_drag_motion = False
        
        model, row = self.tree.get_selection().get_selected()
        if self.real_selected_row : row = self.real_selected_row
        self.real_selected_row = None
        if row!=None:
            item = self.tree.get_model()[row][1]
            return item.on_drag_data_get(context, selection, info)
        else:
            return False
        
        
    def on_drag_data_received(self,tree, context, x, y, selection, info, timestamp):
        self.is_in_drag_motion = False
            
        drop_info = tree.get_dest_row_at_pos(x, y)
        model = tree.get_model()
        #print selection.get_uris()
        if drop_info:
            path, position = drop_info
            path = path[0]
            if position == gtk.TREE_VIEW_DROP_AFTER:
                path += 1
        else:
            return
        if path >= len(model): return
        item = model[path][1]

        if not item or context.get_source_widget()==None :
            pass
        else:
            if selection.data:
                songs = []
                for uri in  selection.data.splitlines():
                    song = library_wrapper.get_song(uri)
                    if song :
                        songs.append(song)
                item.on_drag_song_received(songs)
        
        
    def __button_press(self, w,event):
        if event.button == 3:
            x, y = map(int, [event.x, event.y])
            try: path, col, cellx, celly = self.tree.get_path_at_pos(x, y)
            except TypeError: 
                self.__popup_default_menu()
                return True
            self.tree.grab_focus()
            selection = self.tree.get_selection()
            if not selection.path_is_selected(path):
                self.tree.set_cursor(path, col, 0)
            #else:
            col.focus_cell(col.get_cell_renderers()[0])
            self.tree.emit('popup-menu')
            return True

    def __popup_menu(self,w):
        model, iter = self.tree.get_selection().get_selected()
        if iter!=None:
            menu = model[iter][1].get_menu()
            if menu:
                menu.popup(None,None,None,0,gtk.get_current_event_time())
              
    def __popup_default_menu(self):
        
        menu = gtk.Menu()
        first = True
        for source in self.source_list:
            items = source.get_default_menu()
            if items:
                if not first: menu.append(gtk.SeparatorMenuItem())
                else: first = False
                for item in items:
                    menu.append(item)
        menu.show_all()
        menu.popup(None,None,None,0,gtk.get_current_event_time())    

