/* $Id: gtest.c,v 1.6 2005/03/24 10:17:36 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "../gtk/gtkdefs.h"
#include "../gtk/menu.h"
#include "../gtk/util.h"
#include "../li18n.h"

extern lingGtkMainWindow *main_app;

static guint id = 0;

const gchar* plugin_name (void);
const gchar* plugin_desc (void);
void plugin_init (void);
void plugin_free (void);

const gchar*
plugin_name (void)
{
     return "Test plugin";
}

const gchar*
plugin_desc (void)
{
     return "Test plugin for LingoTeach";
}

void
plugin_init (void)
{
     GtkAction *action = gtk_action_new ("TestAction", N_("Module Help"),
                                         NULL, NULL);
     g_signal_connect_swapped (G_OBJECT (action), "activate",
                               G_CALLBACK (util_open_link),
                               DOCDIR"/FIXME");

     /* add a menu entry in the help section for writing plugins */
     id = gtk_ui_manager_new_merge_id (main_app->menu);
     gtk_action_group_add_action_with_accel (main_app->actions, action, NULL);
     gtk_ui_manager_add_ui (main_app->menu, id, "ui/MainMenu/HelpMenu/",
                            "ModuleHelp", "TestAction",
                            GTK_UI_MANAGER_MENUITEM, FALSE);

     util_info (_("Take a look at the help menu now."));
     return;
}

void
plugin_free (void)
{
     gtk_action_group_remove_action
          (main_app->actions, gtk_action_group_get_action (main_app->actions,
                                                           "TestAction"));
     gtk_ui_manager_remove_ui (main_app->menu, id);
     return;
}
