/* $Id: custom.c,v 1.2 1999/07/01 01:39:58 fraserm Exp $
   $Log: custom.c,v $
   Revision 1.2  1999/07/01 01:39:58  fraserm
   word 0

   Revision 1.1  1999/05/26 23:51:20  fraserm
   Initial revision

*/

/* custom fields - i.e. incorporate external commands */

#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include "limo.h"

/* execute the command in cmdfmt with the file fname; assumes fname is a valid
   filename from current location */
char *get_custom(int argc, char *argv[], struct custcmd *cmdfmt, char *fname)
{
  char cmdbuf[CMDMAX];
  char output[CMDOUTMAX];
  char *retbuf = NULL;
  int p[2]; /* pipe file descriptors */
  FILE *f; /* the stdio'd version of the read side (p[0]) of the pipe */
  pid_t child;
  int status; /* status return of the child process */
  char *my_argv[4];
  int ch;
  int i, curr;
  ssize_t rv;

  /* make the command */
  if (snprintf(cmdbuf, CMDMAX, cmdfmt->cmd, fname) == -1) {
    retbuf = "Bad-Command";
  }
  else { /* made command ok */
    /* create a pipe */
    if (pipe(p) == -1) {
      fprintf(stderr, "%s: pipe: %s\n", argv[0], strerror(errno));
      retbuf =  "Pipe Error";
    }
    else { /* made pipe ok */
      /* printf("Pipe fds %d & %d\n", p[0], p[1]); */
      /* split into two processes */
      if ((child = fork()) == -1) {
	fprintf(stderr, "%s: fork: %s\n", argv[0], strerror(errno));
      }
      else { /* forked ok */
	if (child == 0) { /* in the child, dup() all the fds and run the
			     command */
	  /* make the writing end of the pipe the standard out and err for
	     this process */
	  if (dup2(p[1], 1) == -1 || dup2(p[1], 2) == -1) {
	    fprintf(stderr, "%s: dup2: %s\n", argv[0], strerror(errno));
	    close(p[1]);
	    exit(0); /* just exits the sub-process, mind! */
	  }
	  /* execute the command */
	  my_argv[0] = "sh";
	  my_argv[1] = "-c";
	  my_argv[2] = cmdbuf;
	  my_argv[3] = NULL;
	  execv("/bin/sh", my_argv);
	  exit(127);
	}
	else { /* in the parent, read the child's output */
	  /* let's make it into a standard IO object to make things simpler */
	  if ((f = fdopen(p[0], "r")) == NULL) {
	    fprintf(stderr, "%s: fdopen: %s\n", argv[0], strerror(errno));
	    retbuf = "Bad-Pipe-Read";
	  }
	  else { /* fdopened ok */
	    /* skip lines as required */
	    ch = fgetc(f);
	    for (curr = 1; curr < cmdfmt->linenum; ++curr) {
	      while (ch != EOF && ch != '\n') {
		ch = fgetc(f);
	      }
	    }
	    if (ch == EOF) {
	      retbuf = "Not-Enough-Lines";
	    }
	    else {
	      /* right, skip whitespace first */
	      while (ch != EOF
		     && (ch == ' ' || ch == '\r' || ch == '\t')) {
		ch = fgetc(f);
	      }
	      if (ch == EOF || ch == '\n') {
		retbuf = "Not-Enough-Lines";
	      }
	      else {
		if (cmdfmt->wordnum != 0) { /* 0 means the whole line */
		  /* skip enough words */
		  for (curr = 1; curr < cmdfmt->wordnum; ++curr) {
		    /* skip a word */
		    while (ch != EOF
			   && ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') {
		      ch = fgetc(f);
		    }
		    if (ch == EOF || ch == '\n') {
		      break; /* EOF or end-of-line is game over */
		    }
		    /* skip the whitespace following it */
		    while (ch  != EOF &&
			   (ch == ' ' || ch == '\r' || ch == '\t')) {
		      ch = fgetc(f);
		    }
		    if (ch == EOF || ch == '\n') {
		      break;
		    }
		  }
		}
		if (ch == EOF || ch == '\n') { /* must have hit something we
						  don't want */
		  retbuf = "Not-Enough-Words";
		}
		else {
		  if (ch != EOF) {
		    ungetc(ch, f); /* push the last one back */
		    /* read into the output buffer until we get a whitespace
		       or run out of buffer, or if wordnum is 0, until the
		       end of the line */
		    for (i = 0;
			 i < CMDOUTMAX-1 && (ch = fgetc(f)) != EOF;
			 ++i) {
		      if (ch == '\n' || ch == '\r'
			  || (cmdfmt->wordnum > 0
			      && (ch == ' ' || ch == '\t'))) {
			break;
		      }
		      output[i] = ch;
		    }
		    output[i] = '\0'; /* terminate the string properly */
		  }
		}
	      }
	    }
	    /* close this end of the pipe */
	    fclose(f);
	    /* wait for the process to terminate */
	    if (waitpid(child, &status, 0) != child) {
	      fprintf(stderr, "%s: waitpid: %s\n", argv[0], strerror(errno));
	    }
	    /* did command succeed? */
	    if (WEXITSTATUS(status) != 0) {
	      retbuf = "-";
	    }
	    else {
	      if (retbuf == NULL) {
		/* get a char buffer to return the output in */
		if ((retbuf = (char *) malloc(i+1)) == NULL) {
		  fprintf(stderr, "%s: malloc: %s\n", argv[0],
			  strerror(errno));
		  retbuf = "Bad-malloc";
		}
		else { /* malloced ok */
		  strcpy(retbuf, output);
		}
	      }
	    }
	  }
	}
      }
      close(p[0]); /* the reading side */
      close(p[1]); /* the writing side */
    }
  }
  return retbuf;
}
