#! /bin/sh

# Filter "underquoted definitions" warnings from aclocal output.  This
# should not be necessary in the distant future (today is 2004-09),
# when all the third party m4 macros will be properly quoted.

function filter {
  fgrep -v underquoted | fgrep -v "run info" | fgrep -v sources.redhat
  return 0
}

function run {
  echo -n Running `$1 --version | sed 1q`...
  $* 2>&1 | filter
  echo " done"
}

echo "Autotools versions are the following:"
autoconf --version |sed 1q
automake --version |sed 1q
libtool  --version |sed 1q

# Replace the following (which may not work for future versions of the
# autotools) with the appropriate use of the autoreconf script
#run aclocal \
#&& run libtoolize --automake \
#&& run automake --add-missing --copy \
#&& run autoconf

run autoreconf -vfi -I m4
