#include <qwidget.h>

#include "ModuleFactory.h"

#include "MainWin.h"
#include "Plot2DSimple.h"
#include "ImportDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"
#include "PstoEditDialog.h"
#include "ExportDialog.h"
#include "ProjectDialog.h"
#include "TitleDialog.h"
#include "LegendDialog.h"
#include "AxesDialog.h"
#include "ObjectDialog.h"

#include "AverageListDialog.h"
#include "CapabilityListDialog.h"
#include "CompressListDialog.h"
#include "ConvolutionListDialog.h"
#include "DifferencesListDialog.h"
#include "FFTListDialog.h"
#include "FitListDialog.h"
#include "GraphListDialog.h"
#include "HankelListDialog.h"
#include "HistListDialog.h"
#include "ImageListDialog.h"
#include "IntegrationListDialog.h"
#include "InterpolationListDialog.h"
#include "OperationsListDialog.h"
#include "PeakListDialog.h"
#include "PeriodicListDialog.h"
#include "PruneListDialog.h"
#include "RegressionListDialog.h"
#include "SeasonalListDialog.h"
#include "SmoothListDialog.h"
#include "WaveletListDialog.h"

#include "ArrangePlotDialog.h"
#include "OverlayPlotDialog.h"

#include "WorksheetDialog.h"
#include "PlotSettingsDialog.h"

ModuleFactory::ModuleFactory(MainWin *mw, QWorkspace *ws)
	: mw(mw), ws(ws)
{
#ifdef HAVE_QSA_FAC
	registerClass( "Spreadsheet");
	registerClass( "Worksheet");

	registerClass( "ImportDialog");
	registerClass( "PstoEditDialog");
	registerClass( "ImageMagickDialog");

	registerClass( "DataDialog");
	registerClass( "FunctionDialog");
	registerClass( "ExportDialog");
	registerClass( "ProjectDialog");
	registerClass( "TitleDialog");
	registerClass( "LegendDialog");
	registerClass( "AxesDialog");
	registerClass( "ObjectDialog");

	registerClass( "AverageListDialog");
	registerClass( "CapabilityListDialog");
	registerClass( "CompressListDialog");
	registerClass( "ConvolutionListDialog");
	registerClass( "DifferencesListDialog");
	registerClass( "FFTListDialog");
	registerClass( "FitListDialog");
	registerClass( "GraphListDialog");
	registerClass( "HankelListDialog");
	registerClass( "HistListDialog");
	registerClass( "ImageListDialog");
	registerClass( "IntegrationListDialog");
	registerClass( "InterpolationListDialog");
	registerClass( "OperationsListDialog");
	registerClass( "PeakListDialog");
	registerClass( "PeriodicListDialog");
	registerClass( "PruneListDialog");
	registerClass( "RegressionListDialog");
	registerClass( "SeasonalListDialog");
	registerClass( "SmoothListDialog");
	registerClass( "WaveletListDialog");
	
	registerClass( "ArrangePlotDialog");
	registerClass( "OverlayPlotDialog");
	
	registerClass( "WorksheetDialog");
	registerClass( "PlotSettingsDialog");
#endif
}

#ifdef HAVE_QSA_FAC
QObject *ModuleFactory::create( const QString &type, const QSArgumentList &args, QObject*) {
	kdDebug()<<"ModuleFactory::create()"<<endl;
	
	if ( type == "Spreadsheet" )
		return new Spreadsheet(ws, mw,"script");
	if ( type == "Worksheet" )
		return new Worksheet(ws, mw,"script");
	if ( type == "FunctionDialog" ) {
		PType type = P2D;
		if (args.count()>=1)
			type = (PType) args[0].variant().toInt();
		if(type == PVTK || type == PGRASS)	// not supported anymore
			type = P2D;
		return new FunctionDialog(mw,"script",0,-1,type);
	}
	if ( type == "ExportDialog" )
		return new ExportDialog(mw, "script", 0);
	if ( type == "ProjectDialog" )
		return new ProjectDialog(mw, "script");
	if ( type == "TitleDialog" )
		return new TitleDialog(mw, "script");
	if ( type == "LegendDialog" )
		return new LegendDialog(mw, "script");
	if ( type == "AxesDialog" ) {
		int nr=0;
		if (args.count()>=1)
			nr = args[0].variant().toInt();	
		return new AxesDialog(mw, "script", nr);
	}
	if ( type == "ObjectDialog" ) {
		int active=0, item=0;
		if (args.count() >= 1)
			active = args[0].variant().toInt();	
		if (args.count() > 1)
			item = args[0].variant().toInt();	
		return new ObjectDialog(mw, "script", active, item);
	}

	if ( type == "DataDialog" ) {
		PType type = P2D;
		if (args.count()>=1)
			type = (PType) args[0].variant().toInt();
		if(type == PVTK || type == PGRASS)	// not supported anymore
			type = P2D;
		return new DataDialog(mw,"script",0,-1,type);
	}
	if ( type == "ImportDialog" ) {
    		QString filename("1.dat");
		InputFilter filter=FUSER;
		if (args.count()>=1)
			filename=args[0].variant().toString();	
		if (args.count()>1)
			filter = (InputFilter) args[1].variant().toInt();
		return new ImportDialog(mw,filename,filter,"script");
	}
	if ( type == "PstoEditDialog" ) {
    		QString filename("out.pdf");
		int format=4, size=5;
		double scale=1.0, rotation=0.0;
		if (args.count()>0)
			filename=args[0].variant().toString();	
		if (args.count()>1)
			format=args[1].variant().toInt();
		if (args.count()>2)
			size=args[2].variant().toInt();
		if (args.count()>3)
			scale=args[3].variant().toDouble();
		if (args.count()>4)
			rotation=args[4].variant().toDouble();
		return new PstoEditDialog(mw, filename, format, size, scale, rotation, "script");
	}
	if ( type == "ImageMagickDialog" ) {
    		QString filename("out.8bim");
		int format=0, sizex=800, sizey=600;
		double rotation=0.0;
		if (args.count()>0)
			filename=args[0].variant().toString();	
		if (args.count()>1)
			format=args[1].variant().toInt();
		if (args.count()>2)
			sizex=args[2].variant().toInt();
		if (args.count()>3)
			sizey=args[3].variant().toInt();
		if (args.count()>4)
			rotation=args[4].variant().toDouble();
		return new PstoEditDialog(mw, filename, format, sizex, sizey, rotation, "script");
	}
	if ( type == "AverageListDialog" )
		return new AverageListDialog(mw, "script");
	if ( type == "CapabilityListDialog" )
		return new CapabilityListDialog(mw, "script");
	if ( type == "CompressListDialog" )
		return new CompressListDialog(mw, "script");
	if ( type == "ConvolutionListDialog" )
		return new ConvolutionListDialog(mw, "script");
	if ( type == "DifferencesListDialog" )
		return new DifferencesListDialog(mw, "script");
	if ( type == "FFTListDialog" )
		return new IntegrationListDialog(mw, "script");
	if ( type == "FitListDialog" )
		return new FitListDialog(mw, "script");
	if ( type == "GraphListDialog" )
		return new GraphListDialog(mw,"script");
	if ( type == "HankelListDialog" )
		return new HankelListDialog(mw, "script");
	if ( type == "HistListDialog" )
		return new HistListDialog(mw, "script");
	if ( type == "ImageListDialog" )
		return new ImageListDialog(mw, "script");
	if ( type == "IntegrationListDialog" )
		return new IntegrationListDialog(mw, "script");
	if ( type == "InterpolationListDialog" )
		return new InterpolationListDialog(mw, "script");
	if ( type == "OperationsListDialog" )
		return new OperationsListDialog(mw, "script");
	if ( type == "PeakListDialog" )
		return new PeakListDialog(mw, "script");
	if ( type == "PeriodicListDialog" )
		return new PeriodicListDialog(mw, "script");
	if ( type == "PruneListDialog" )
		return new PruneListDialog(mw, "script");
	if ( type == "RegressionListDialog" )
		return new RegressionListDialog(mw, "script");
	if ( type == "SeasonalListDialog" )
		return new SeasonalListDialog(mw, "script");
	if ( type == "SmoothListDialog" )
		return new SmoothListDialog(mw, "script");
	if ( type == "WaveletListDialog" )
		return new WaveletListDialog(mw, "script");
	if ( type == "ArrangePlotDialog" )
		return new ArrangePlotDialog(mw, "script");
	if ( type == "OverlayPlotDialog" )
		return new OverlayPlotDialog(mw, "script");

	if ( type == "WorksheetDialog" )
		return new WorksheetDialog(mw, "script");
	if ( type == "PlotSettingsDialog" )
		return new PlotSettingsDialog(mw, "script");

    return 0;
}
#endif
