/***************************************************************************
 *
 *  $Id: kzentracklistview.h,v 1.4 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENTRACKLISTVIEW_H
#define KZENTRACKLISTVIEW_H

#include <klistview.h>
#include <qevent.h>

#include "kzenglobal.h"
#include "kzentrack.h"

class KZenTrackView;

/**
@author Andreas Mussgiller
*/
class KZenTrackListView : public KListView , public KZen
{
  friend class KListViewItem;

  Q_OBJECT
  
 public:
 
  KZenTrackListView(KZenTrackView * view, QWidget * parent = 0, const char *name = 0);
  ~KZenTrackListView();

  void                        setViewMode(ViewMode vm) { fViewMode = vm; }

 protected:

  virtual QDragObject *       dragObject();
  virtual bool                acceptDrag(QDropEvent* event) const;
  virtual void                contentsDragMoveEvent(QDragMoveEvent *event);
  virtual void                contentsDropEvent(QDropEvent * event);

  virtual bool                decode(QMimeSource *s);

  ViewMode                    fViewMode;

  KZenTrackView              *fTrackView;

 signals:

  void                        filesDropped(const QStringList &, KZenPlayList *);
  void                        updatePlayList(KZenPlayList *, QStringList &);
};

#endif
