/***************************************************************************
 *
 *  $Id: kzentracklistview.cpp,v 1.4 2005/06/04 10:22:21 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qdragobject.h>
#include <qpoint.h>
#include <qheader.h>
#include <qpixmap.h>

#include <kurldrag.h>
#include <kiconloader.h>
#include <kdebug.h>

#include "kzenexplorerview.h"
#include "kzentracklistview.h"
#include "kzentrackview.h"

KZenTrackListView::KZenTrackListView(KZenTrackView *view, QWidget * parent, const char *name)
  :KListView(parent, name)
{
  fTrackView = view;

  setAllColumnsShowFocus(true);
  setShowSortIndicator(true);
  setAcceptDrops(true);
  setDragEnabled(true);
  setDropVisualizer(true);
  setSelectionMode(QListView::Extended);
  setResizeMode(QListView::NoColumn);
  header()->setMovingEnabled(false);
  setDefaultRenameAction(QListView::Reject);
}

KZenTrackListView::~KZenTrackListView()
{

}

QDragObject * KZenTrackListView::dragObject()
{
  QPtrList<QListViewItem> TrackList = KListView::selectedItems();

  QString trackIDs;
  QString temp;
  for (QPtrListIterator<QListViewItem> it(TrackList); it.current(); ++it) {
    if( it.current()->isSelected()) {
      KZenTrackItem * i = (KZenTrackItem*) it.current();
      temp.setNum(i->getTrack()->getTrackID());
      trackIDs += temp;
      trackIDs += "\n";
    }
  }
  
  QTextDrag * drag = new QTextDrag(trackIDs, fgTrackSource, "trackIDs");
  drag->setPixmap(SmallIcon("view_text", 16));

  return drag;
}

bool KZenTrackListView::acceptDrag(QDropEvent* event) const
{
  if (fViewMode==ViewModePlayList && event->source()==fgTrackSource) {
    //kdDebug() << "acceptDrag: ViewModePlayList fgTrackSource" << endl;
    return QTextDrag::canDecode(event);
  }
  if (event->source()!=fgTrackSource && event->source()!=fgNaviSource) {
    //kdDebug() << "acceptDrag: !fgTrackSource" << endl;
    return QTextDrag::canDecode(event);
  }
  return false;
}

void KZenTrackListView::contentsDragMoveEvent(QDragMoveEvent *event)
{
  if (fViewMode!=ViewModePlayList && event->source()==fgTrackSource) {
    //kdDebug() << "dragMoveEvent: !ViewModePlayList fgTrackSource" << endl;
    event->accept(false);
  }
  if (fViewMode==ViewModePlayList && event->source()==fgTrackSource) {
    //kdDebug() << "dragMoveEvent: ViewModePlayList fgTrackSource" << endl;
    event->accept(QTextDrag::canDecode(event));
  }
  if (event->source()!=fgTrackSource && event->source()!=fgNaviSource) {
    //kdDebug() << "dragMoveEvent: !fgTrackSource !fgNaviSource" << endl;
    event->accept(QTextDrag::canDecode(event));
  }
}

void KZenTrackListView::contentsDropEvent(QDropEvent * event)
{
  if (event->source()!=fgTrackSource) {
    //kdDebug() << "dropEvent: !fgTrackSource" << endl;
    event->accept(decode(event));
  } else {
    if (fViewMode==ViewModePlayList) {
      //kdDebug() << "dropEvent: fgTrackSource ViewModePlayList" << endl;
      
      QPoint vp = contentsToViewport(event->pos());
      QListViewItem * moveAfter =itemAt(vp);
      
      if(!moveAfter)
	moveAfter = lastItem();
      else if(vp.y() < moveAfter->itemPos() + moveAfter->height() / 2)
	moveAfter = moveAfter->itemAbove();
      
      QPtrList<QListViewItem> TrackList = KListView::selectedItems();
      
      for(QPtrListIterator<QListViewItem> it(TrackList); it.current(); ++it) {
	//kdDebug() << "current item: " << it.current()->text(0) << endl;
	if(!moveAfter) {
	  takeItem(it.current());
	  insertItem(it.current());
	} else {
	  //kdDebug() << "moveAfter " << moveAfter->text(0) << endl;
	  it.current()->moveItem(moveAfter);
	}
	
	moveAfter = it.current();
      }

      QStringList trackIDs;
      QString temp;
      KZenPlayList * PL = 0;
      for(KZenTrackPLItem * i = (KZenTrackPLItem*)firstChild();
	  i; 
	  i = (KZenTrackPLItem*)i->itemBelow()) {
	if (!PL) PL = i->getPlayList();
	temp.setNum(i->getTrack()->getTrackID());
	trackIDs.append(temp);
      }

      emit updatePlayList(PL,trackIDs);
    }
  }
}

bool KZenTrackListView::decode(QMimeSource *s)
{
  KURL::List urls;

  if(!KURLDrag::decode(s, urls) || urls.isEmpty())
    return false;

  QStringList fileList;
  
  for(KURL::List::Iterator it = urls.begin(); it != urls.end(); it++) {
    fileList.append((*it).url());
  }
  
  emit filesDropped(fileList,fTrackView->currentPlayList());

  return true;
}

#include "kzentracklistview.moc"
