/***************************************************************************
 *
 *  $Id: kzenexplorer.h,v 1.29 2005/07/03 17:01:48 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef _KZENEXPLORER_H_
#define _KZENEXPLORER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qptrlist.h>
#include <qlistview.h>
#include <qtimer.h>
#include <qstringlist.h>
#include <qevent.h>

#include <kmainwindow.h>
#include <kurl.h>
#include <kaction.h>
#include <kapplication.h>
#include <kcombobox.h>
#include <kconfig.h>

#include "kzenglobal.h"
#include "kzensplashscreen.h"
#include "kzenexplorerview.h"
#include "kzentrack.h"
#include "kzenartist.h"
#include "kzengenre.h"
#include "kzenplaylist.h"
#include "kzensmartplaylist.h"
#include "kzencommandthread.h"
#include "kzenprogressdialog.h"
#include "kzencategories.h"

class KZenTagEditor;
class KZenSmartPlayListDialog;
class KZenSearchDialog;
class KZenConfigDialog;

/**
 * @short Application Main Window
 * @author Andreas Mussgiller <muszilla@users.sourceforge.net>
 * @version 0.5
 */
class KZenExplorer : public KMainWindow , public KZen
{
  Q_OBJECT

 public:

  /**
   * Default Constructor
   */
  KZenExplorer(KZenSplashScreen * splash);

  /**
   * Default Destructor
   */
  virtual ~KZenExplorer();

  uint                        version() { return 1; }

  void                        setupActions();

  bool                        connectNJB();
  void                        disconnectNJB();

  KZenExplorerView *          getView() { return fView; }
  KZenTagEditor *             getEditor() { return fEditor; }
  void                        addPlayList(KZenPlayList *);
  void                        addSmartPlayList(KZenSmartPlayList *);
  QPtrList<KZenTrack> *       getTracks() { return fTrackList; }
  QPtrList<KZenArtist> *      getArtists() { return fArtistList; }
  QPtrList<KZenGenre> *       getGenres() { return fGenreList; }
  QPtrList<KZenPlayList> *    getPlayListList() { return fPlayLists; }
  QPtrList<KZenSmartPlayList> * getSmartPlayLists() { return fSmartPlayLists; }
  void                        emitRemoveTrackItem(KZenTrackItem *);
  void                        emitRemoveArtist(const char *);
  void                        emitRemoveGenre(const char *);
  void                        emitRemoveAlbum(const char *, const char *);
  void                        emitRemoveNaviItem(KZenItem *);
  void                        emitSelectNaviItem(KZenItem *);
  KZenProgressDialog *        progressDialog() { return fProgressDialog; }
  KZenConfigDialog *          configDialog();
  KZenSplashScreen *          splashScreen() { return fSplash; }
  KZenCommandThread *         commandThread() { return fCommandThread; }

  KZenArtist *                getVariousArtists() { return fVariousArtists; }

 public slots:

  void                        selectionChangedNavi(QListViewItem *);
  void                        filesDropped(const QStringList &, KZenPlayList *);
  void                        tracksDropped(const QStringList &, KZenPlayList *);

  void                        playTracks(QPtrList<KZenTrackItem> &);
  void                        queueTracks(QPtrList<KZenTrackItem> &);
  void                        stopPlay();
  void                        editTracks(QPtrList<KZenTrackItem> &);
  void                        saveTracks(QPtrList<KZenTrackItem> &);
  void                        deleteTracks(QPtrList<KZenTrackItem> &, KZenPlayList *);
  void                        destroyTracks(QPtrList<KZenTrackItem> &);
  
  void                        newPlayList();
  void                        newPlayListSelection();
  void                        newSmartPlayList();
  void                        updatePlayList(KZenPlayList *, QStringList &);
  
  void                        renamePlayList(KZenPlayListItem *);
  void                        editSmartPlayList(KZenSmartPlayListItem *);
  void                        refreshSmartPlayLists(KZenTrack * track);
  void                        refreshSmartPlayLists();
  void                        updateAllPlayLists();
  void                        updatePlayList(KZenPlayList *);
  void                        deleteNaviItem(KZenItem *);
  void                        destroyNaviItem(KZenItem *);

  void                        clearSearch();
  void                        searchChanged(const QString &);
  void                        advancedSearch();

  void                        findDuplicates(int);
  
  void                        setBusy(bool busy = true);

  void                        saveGlobalProperties(KConfig *);
  void                        readGlobalProperties(KConfig *);
  
  void                        setDestroyEnabled(bool e = true);
  void                        setUpdateEnabled(bool e = true);
  void                        setUpdateAllEnabled(bool e = true);
  void                        setTrackOpsEnabled(bool e = true);
  void                        setPlayListOpsEnabled(bool e = true);
  void                        setSmartPlayListOpsEnabled(bool e = true);
  
  void                        cancelRequest(bool t);

  void                        trackEdited(QListViewItem * item, const QString & text, int col);
  
  void                        browseLocalLib();
  void                        exportDB();
  void                        showConfigDialog();

  void                        playTimeOut();

  void                        synchronize();

 protected:

  bool                        queryExit();
  void                        customEvent(QCustomEvent * e);

  bool                        getTrackList();
  bool                        getPlayLists();

  KZenTrack *                 findTrack(const KURL &);
  void                        importDirectory(const KURL &, KZenPlayList * PL);
  void                        importPlayList(const KURL &);

  bool                        readTrackDBFile(const QString &);
  bool                        readTrackDB();
  void                        writeTrackDBFile(const QString &);
  void                        writeTrackDB();
  uint                        fDatabaseID;

  KZenExplorerView           *fView;

  QPtrList<KZenTrack>        *fTrackList;
  QPtrList<KZenTrack>        *fSearchTrackList;
  QPtrList<KZenArtist>       *fArtistList;
  QPtrList<KZenGenre>        *fGenreList;
  QPtrList<KZenPlayList>     *fPlayLists;
  QPtrList<KZenSmartPlayList> *fSmartPlayLists;
  KZenArtist                 *fVariousArtists;

  KAction                    *fPlayTracks;
  KAction                    *fQueueTracks;
  KAction                    *fStopPlay;
  KAction                    *fEditTracks;
  KAction                    *fSaveTracks;
  KAction                    *fDeleteTracks;
  KAction                    *fDestroyTracks;

  KAction                    *fNewPlayList;
  KAction                    *fNewSmartPlayList;
  KAction                    *fClearSearch;
  KAction                    *fAdvancedSearch;
  KAction                    *fFindDuplicatesTitle;
  KAction                    *fFindDuplicatesTitleArtist;
  KAction                    *fFindDuplicatesTitleArtistAlbum;
  KAction                    *fRenamePlayList;
  KAction                    *fEditSmartPlayList;
  KAction                    *fShufflePlayList;
  KAction                    *fUpdatePlayList;
  KAction                    *fUpdateAllPlayLists;
  KAction                    *fDeletePlayList;
  KAction                    *fDestroy;
  KAction                    *fIsCompilation;
  KAction                    *fShowDetails;
  KAction                    *fExportDB;
  KAction                    *fBrowseLocalLib;
  KAction                    *fConfigure;
  KAction                    *fQuit;

  KAction                    *fSelectAll;
  KAction                    *fPlayListFromSelection;

  KAction                    *fSynchronize;

  KZenSplashScreen           *fSplash;

  KZenTagEditor              *fEditor;
  KZenSmartPlayListDialog    *fSmartPlayListDialog;
  KZenProgressDialog         *fProgressDialog;
  KZenSearchDialog           *fSearchDialog;
  KZenConfigDialog           *fConfigDialog;
  KZenCategories              fCategories;

  bool                        fBusy;

  KZenCommandThread          *fCommandThread;

  QTimer                     *fPlayTimer;

 signals:

  void                        removeTrackItem(KZenTrackItem*);
  void                        removeNaviItem(KZenItem *);

  void                        selectNaviItem(KZenItem *);

  void                        removeArtist(const char *);
  void                        removeGenre(const char *);
  void                        removeAlbum(const char *, const char *);
};

extern KZenExplorer * gExplorer;

#endif // _KZENEXPLORER_H_
