/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <iostream>

using namespace std;

#include "tableiste.h"
#include "rcdatei.h"

#include "mysqlinterface.h"
#include "databasewrapper.h"

#include "cdidgenerator.h"
#include "freedbinterface.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "globals.h"
#include "genrehelper.h"

#include "musicbrainz-interface.h"


#include "playerinterface.h"


//global stuff

musicbrainzconnect *mbhelp;
databasewrapper *database;
playerinterface *playerlink;
tableiste *appwindow;
verzeichnis *verzeichnisbaum;
rcdatei settingsfile;
bool cdparanoia_exists;
QString genrefield[GENRECOUNT+1];

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char version[] = "0.4a3";

static KCmdLineOptions options[] =
    {
        KCmdLineLastOption
    };

int main( int argc, char *argv[] )
{
    KAboutData about("kyamo", I18N_NOOP("kyamo"), version, description,
                     KAboutData::License_GPL, "(C) 2005 Roland Weigert", 0, 0, "roweigert@t-online.de");
    about.addAuthor( "Roland Weigert", 0, "roweigert@users.sourceforge.net" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication *programm=new KApplication();
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    settingsfile.load();
    genrehelperinit();
    database=NULL;
    if (settingsfile.databasetype)
    {
        database=new databasewrapper();
        if (database->quit)
        {
            settingsfile.databasetype=0;
            cerr<<"Database-opening did not work"<<endl;
        }
        else if (database)
        {
            cerr<<"Database opened sucessfully. Using modell "<<settingsfile.databasetype<<endl;
        }
    }
    //This must be global and external, otherwise we loose all fetched data
    playerlink=new playerinterface();
    //playerlink->addTrack("/home/roland/neue CDs/Crossover/Disillusion/Gloria/06-The Hole We Are In.mp3");
    //playerlink->startplaying();
    mbhelp=new musicbrainzconnect();
    cdparanoia_exists=checkfiles();
    tableiste *appwindow=new tableiste();
    programm->setMainWidget( appwindow );
    appwindow->show();
    appwindow->initapplication();
    args->clear();
    int returnvalue=programm->exec();
    delete mbhelp;
    if (database)
        delete database;
    delete appwindow;
    delete programm;
    return returnvalue;
}
