/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*This class can search google for cd-covers with given searchstring
  It Pops up a dialog to the user, where covers are selectable
It emits signals if a cover is selected or when dialog is aborted*/

using namespace std;

#ifndef _COVERFINDER2_H_
#define _COVERFINDER2_H_

#include <iostream>

#include <qdialog.h>
#include <qstringlist.h>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qhttp.h>
#include <qbuttongroup.h>
#include <qfile.h>

#include <klocale.h>
#include <kapp.h>
#include <kiconloader.h>

class coverhelper2;
struct linkitem;

class coverfinder2 : public QDialog
{
    Q_OBJECT
public:
    coverfinder2(QString);
    ~coverfinder2();
    void closeEvent(QCloseEvent*);
private:
    QHttp *url;
    int transactionid;
    int selectedcover;
    int covernumber;
    int coverindex;
    QPtrList<linkitem> linklist;
    QPtrList<coverhelper2> coverlist;
    QString coverstring;
    QStringList imagelinks;
    QPtrList<QImage> imagelist;
    QVBox *coverfinderlayout;
    QGroupBox *coverselectorlayout;
    QGroupBox *buttonbox;
    QPushButton *cancelbutton;
    QPushButton *okbutton;
    QButtonGroup *radiogroup;
    void getpicturelinks();
    void getlink(QString);//pull out the pictures from links in the html-code
signals:
    void abort();
    void pictureselected(QImage);
    void googlequeryready();
    void newpicturereceived(QImage);
private slots:
    void cancelslot();
    void checkokslot(int);
    void getpicturelist(int,bool);
    void okslot();
    void fetchcoverlist();
    void addpicturetolayout(QImage);
    void getfinished(int,bool);
};

struct linkitem
{
    QHttp *url;
    QString link;
    int transactionid;
};

/*We need a helper-class, that holds all widgets that are needed for the
  organisation of the covers. (Radio,Label,Image itself)
  So we can gather them together into a QPtrList, and easily get controll over the
  lifetime of everything.*/

class coverhelper2 
{
public:
    QGroupBox *covergroup;
    QRadioButton *coverradio;
    QLabel *sizelabel;
    QLabel *coverpicture;
    QImage realpicture;
    coverhelper2(QWidget *);
    ~coverhelper2();
    void show();
};


#endif //_COVERFINDER2_H_
