#ifndef _KVI_BIFF_SOCKET_H_INCLUDED_
#define _KVI_BIFF_SOCKET_H_INCLUDED_

// =============================================================================
//
//        --- kvi_biff_socket.h ---
//
//   Authors:
//       Szymon Stefanek <stefanek@tin.it>
//       Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qobject.h>

#include "kvi_string.h"
#include "kvi_dns.h"

class QSocketNotifier;

class KviBiffMailbox;

class KviBiffSocket : public QObject
{
	Q_OBJECT
public:
	KviBiffSocket();
	~KviBiffSocket();
protected:
	int connectToHost(const char *addr);

	int                m_fd;
	QSocketNotifier   *m_pNotifier;
	KviStr             m_szHostIp;
	KviDns            *m_pDNS;
	KviBiffMailbox    *m_pMailbox;
	unsigned short int m_uPort;
	KviStr             m_szUsername;
	KviStr             m_szPassword;
	KviStr             m_szHostname;
	KviStr             m_lastCommand;
public:
	const char *hostname()    const;
	const char *hostIp()      const;
	unsigned short int port() const;
	bool run(KviBiffMailbox *box);

protected slots:
	void finished(KviDnsData *dns);
	void writeNotifierFired(int fd);
	void  readNotifierFired(int fd);

signals:
	void resolving();
	void connected();            // Emitted to signal the connection established
	void loggedIn();
	                             // The following two signals are critical:
	                             // Cannot rely on the this pointer after these have been emitted
	void error(const char *err); // Emitted in case of critical errors
	void jobDone();              // Emitted when the update job has been terminated
};

#endif // _KVI_BIFF_SOCKET_H_INCLUDED_
