/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLAINTEXTPLUGIN_H
#define PLAINTEXTPLUGIN_H

#include <dictionary/dictionaryplugin.h>

#ifndef NOPTIMIZE
#include <qvaluelist.h>
#include <time.h>
#endif

class QString;
class QFile;

class PlainTextPlugin :public KTranslator::DictionaryPlugin
{
public:
    PlainTextPlugin( QObject *parent, const char* name, const QStringList& );

    // search the word in Freedict dictionary
    QString search( const QString &word );
    QWidget *confPage();
    void applyConf( QWidget * );
#ifndef NOPTIMIZE
    void loadDictionary();
#endif
    int size();

private:
    QString dictName;
    QFile *dictFile;
#ifndef NOPTIMIZE
    typedef QMap<QString, long>Dictionary;
    Dictionary dic;
    time_t fileTime;
#endif
};


#endif /* PLAINTEXTPLUGIN_H */

