/***************************************************************************
                          xplanetwrapper.h  -  description
                             -------------------
    begin                : Mon Apr 29 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XPLANETWRAPPER_H
#define XPLANETWRAPPER_H

#include <qwidget.h>
#include <qfile.h>
#include <qlist.h>
#include <qstringlist.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <kprocess.h>

#include "globals.h"
#include "satellite.h"

/**Class around xplanet
  *@author Luc Langehegermann
  */

// this struct is used to store an rectangle of the map we want to show

typedef struct {
  double minlon;
  double maxlon;
  double minlat;
  double maxlat;
} s_rectangle;

class xplanetWrapper : public QWidget  {
   Q_OBJECT
public: 
	xplanetWrapper(QWidget *parent=0, const char *name=0);
	~xplanetWrapper();
  /** No descriptions */
  void setSatList(QList<satellite> s);
  /** No descriptions */
  void writeArcFile();
  /** No descriptions */
  double arccos(double x, double y);
  /** No descriptions */
  double convertlong(double longitude) ;
  /** sets the observer qth */
  void setObsQth(obsQTH* q);
  /** sets the satellite we highlight (that is being tracked) */
  void setTrackingSatellite(satellite* sat);
  /** set additional xplanet parameters */
  void setParameters(s_xplanet* parms);
  /** Opens an file for xplanet message logging */
  void openLogFile();
  /** closes the log file */
  void closeLogFile();;
private:
  QStringList searchdirlist;
  int updateInterval; // set the update intervall
  KProcess proc;
  QPixmap pixmap;
  QList<satellite> satlist;
  obsQTH* qth;
  satellite* trackingSatellite;   // we are tracking this satellite
  s_xplanet* parameters;
private slots: // Private slots
  /** No descriptions */
  void callXplanet();
  /** No descriptions */
  void newImage(KProcess* p);
  /** No descriptions */
  void xplanetError(KProcess* proc, char* buffer, int buflen);
private: // Private methods
  /** No descriptions */
  void paintEvent(QPaintEvent*);
  int screen_width, screen_height;
  s_rectangle rectangle;
  QTextStream logstream;
  QFile logfile;
};

#endif
