/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005
// Johannes Bergmeier <Johannes.Bergmeier@gmx.net>, Francesco Rossi <redsh@email.it> (C) 2006-2007
//

#include "ksudoku.h"

#include <qdragobject.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <ksavefile.h>

#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kstatusbar.h>
#include <kaccel.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kactionclasses.h>
#include <krun.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>

#include "gameopt.h"
#include "print.h"
#include "exportdlg.h"
#include "puzzlefactory.h"
#include "ksview.h"

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

#include "puzzle.h" // TODO
#include "serializer.h"
#include <ktabwidget.h>

#include <ktar.h>
#include <qdir.h>
#include <kstandarddirs.h>
#include <kio/job.h>

#include <qvbox.h>

// bool guidedMode;

void KSudoku::onCompleted(bool isCorrect, const QTime& required, bool withHelp) {
	if(!isCorrect) {
		KMessageBox::information(this, i18n("Sorry the solution you entered is not correct.\nIf you want to see error check Options->Guided mode please."));
		return;
	}
	
	QString msg;
 	int secs = QTime(0,0).secsTo(required);
 	int mins = secs / 60;
 	secs = secs % 60;

	if(withHelp)
		msg = i18n("Congratulations! You made it in %1 minutes and %2 seconds. With some tricks.").arg(mins).arg(secs);
	else
		msg = i18n("Congratulations!!!! You made it in %1 minutes and %2 seconds.").arg(mins).arg(secs);

	KMessageBox::information(this, msg);
	
}

void KSudoku::updateStatusBar()
{
	QString m;

// 	QWidget* current = m_tabs->currentPage();
// 	if(KsView* view = dynamic_cast<KsView*>(current))
// 		m = view->status();
	if(currentView())
		m = currentView()->status();

	statusBar()->message(m);
}

// KSudoku::KSudoku(ksudoku::Game* game)
// 	: KMainWindow(0,"ksudoku"), m_tabs(0)
// {
// 	m_tabs = new KTabWidget(this);
// 	m_tabs->setHoverCloseButton(true);
// 	m_tabs->show();
// 	setCentralWidget(m_tabs);
// 	
// 	readProperties( KApplication::kApplication()->config());
// 	setupActions();
// 	
// 	statusBar()->show();
// 	
// 	setupGUI();
// 	
// 	addGame(game);
// 	
// 	QTimer *timer = new QTimer( this );
//     connect( timer, SIGNAL(timeout()), this, SLOT(updateStatusBar()) );
//     timer->start( 1000, false ); // 2 seconds single-shot timer	
// }

KSudoku::KSudoku()
	: KMainWindow( 0, "ksudoku" )
// 	, m_tabs(0)
	, m_autoDelCentralWidget(false)
{
// 	m_tabs = new KTabWidget(this);
// 	m_tabs->setHoverCloseButton(true);
// 	m_tabs->show();
// 	m_tabs->hide();
// 	setCentralWidget(m_tabs);
	
    // then, setup our actions
	readProperties( KApplication::kApplication()->config());
	setupActions();

    // and a status bar
	statusBar()->show();

	// Apply the create the main window and ask the mainwindow to
	// automatically save settings if changed: window size, toolbar
	// position, icon size, etc.  Also to add actions for the statusbar
	// toolbar, and keybindings if necessary.
	setupGUI();

// 	newGame();

// 	connect(this, SIGNAL(currentChanged(QWidget*)), this, SLOT(adaptActions2View(QWidget*)));

	// Setup Welcome Screen
// 	m_tabs->insertTab(new QLabel("Welcome to KSudoku (FAKE WELCOME)", this), "Welcome");
// <<<<<<< .mine
	m_gameSelDlg = new GameSelectionDialog(this);
// 	m_tabs->insertTab(m_gameSelDlg, "Welcome");
// 	m_gameSelDlg->show();
// 	setCentralWidget(m_gameSelDlg);
// =======
// 	gameSelDlg = new GameSelectionDialog(this);
// 	m_tabs->insertTab(gameSelDlg, "Welcome");
// >>>>>>> .r110
	QString title = i18n("Start a Game");
	m_gameSelDlg->addEntry("play-sudoku", i18n("Sudoku"), title);
	m_gameSelDlg->addEntry("play-roxdoku", i18n("Roxdoku (3D)"), title);
	updateCustomShapesList();
	title = i18n("Create your own Game");
	m_gameSelDlg->addEntry("edit-sudoku", i18n("Sudoku"), title);
	m_gameSelDlg->addEntry("edit-roxdoku", i18n("Roxdoku (3D)"), title);
// 	gameSelDlg->addEntry("edit-sudoku", i18n("Sudoku"), title);
// 	gameSelDlg->addEntry("edit-roxdoku", i18n("Roxdoku (3D)"), title);
	title = i18n("MORE GAMES");
	m_gameSelDlg->addEntry("shape-download", i18n("Download new shapes"), title);
	m_gameSelDlg->addEntry("shape-load", i18n("Load shapes manually"), title);
// 	m_gameSelDlg->showOptions();
	connect( m_gameSelDlg, SIGNAL( gameSelected(const QString&) ), this, SLOT( dlgSelectedGame(const QString&) ));
	connect(m_gameSelDlg, SIGNAL(gameSelected(const QString&)), this, SLOT(selectGameType(const QString&)));
	
	setCentralWidget(m_gameSelDlg, false);
	
	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL(timeout()), this, SLOT(updateStatusBar()) );
	timer->start( 1000, false ); // 2 seconds single-shot timer
}

//This is only a testing stub
QString KSudoku::getShapeName(QString path)
{
	int left  = path.findRev('/');
	int right = path.findRev('.');
	int len = right - left;
	return path.mid(left+1, len-1);
}

void KSudoku::updateCustomShapesList()
{
	QString title = i18n( "Start a Game" );
	QStringList mdirs = KGlobal::dirs()->findDirs( "data", "ksudoku/" );
	if ( mdirs.isEmpty() ) return;
	QStringList files;

	for ( QStringList::Iterator it =mdirs.begin(); it !=mdirs.end(); ++it ) 
	{
		QDir dir(*it);
//		printf("%s\n", (*it).latin1());
		QStringList temp;
		temp += dir.entryList(QDir::Files, QDir::Name );
		for (QStringList::Iterator it2 =temp.begin(); it2 !=temp.end(); ++it2 ) 
			if(*it2 != QString( "ksudokuui.rc"))files += dir.absFilePath( *it2 );
	}

	for ( QStringList::Iterator it =files.begin(); it !=files.end(); ++it ) 
	{
		if( !m_shapes.contains(getShapeName(*it)) )
		{
			QString err;
			KURL url;
			url.setPath(*it);
			//SKSolver* sol = ksudoku::GraphCustom::createCustomSolver((*it));
			SKSolver* sol = ksudoku::Serializer::loadCustomShape(url, this, 0);

			if(sol != NULL)
			{
				m_shapes.insert(getShapeName(*it),  sol);
				m_gameSelDlg->addEntry( "custom-"+getShapeName(*it), getShapeName(*it), title );
			}
			else
			{
//				printf("Error: file %s is not a valid shape file.\n", (*it).latin1());
				//TODO Error Message?
			}
		}
	}
	emit m_gameSelDlg->UPDATE();
	
}

KSudoku::~KSudoku()
{
}

void KSudoku::addGame(const Game& game) {
	GameType type = game.puzzle()->gameType(); //game solver()->g->sizeZ() > 1) ? 1 : 0;
	KsView* view = 0;

	switch(type){
		case sudoku: { //curly braces needed to avoid "crosses initialization" compile error
			ksudokuView* v = new ksudokuView(this, false);
			v->setup(game);
			connect( v, SIGNAL(changedSelectedNum()), this, SLOT(updateStatusBar()) );
			view = v;
			break;     }
		case roxdoku: {
			view = new RoxdokuView(game, this, "ksudoku-3dwnd");
			break;      }
		case custom:{
// 			SKPuzzle* puzzle = game.puzzle()->puzzle();
			//GraphCustom* gc = game.puzzle()->solver()->g;
			ksudokuView* v = new ksudokuView(this, true);
			v->setup(game);
			connect( v, SIGNAL(changedSelectedNum()), this, SLOT(updateStatusBar()) );
			view = v;
		}
		default:
			///@todo if here, BUG => throw exception (??)
			break;
	}
// 	m_tabs->insertTab(view, "Test");
// 	m_tabs->showPage(view);
	if(ksudokuView* view2 = dynamic_cast<ksudokuView*>(view)) 
	{
		setCentralWidget((ksudokuView*)view, true);
	}
	else if (RoxdokuView* view2 = dynamic_cast<RoxdokuView*>(view)) 
	{
		setCentralWidget((RoxdokuView*)view, true);
	}
	else
	{
		//error
	}
}

void KSudoku::dlgSelectedGame(const QString& name)
{
// 	int order =  m_gameSelDlg->order;
// 	int difficulty = m_gameSelDlg->difficulty;
// 	int symmetry = m_gameSelDlg->symmetry;
// 
// 	if( name == QString("play-sudoku") )
// 	{
// 		stateChanged("dubbing", StateReverse);
// 		Game game = Game(PuzzleFactory().create_instance(sudoku, order, difficulty, symmetry));
// 		addGame(game);
// 	}
// 	else if( name == QString("play-roxdoku") )
// 	{
// 		stateChanged("dubbing", StateReverse);
// 		Game game = Game(PuzzleFactory().create_instance(roxdoku, order, difficulty, 1));
// 		addGame(game);
// 	}
// 	else if( name == QString("edit-sudoku") )
// 	{
// 		stateChanged("dubbing");
// 		Game game(PuzzleFactory().create_instance(sudoku, order, 0, 0, true));
// 		addGame(game);
// 	}
// 	else if( name == QString("edit-roxdoku") )
// 	{
// 		stateChanged("dubbing");
// 		Game game(PuzzleFactory().create_instance(sudoku, order, 0, 0, true));
// 		addGame(game);
// 	}
// 	else if( name == QString("shape-download") )
// 	{
// // 		KSudokuNewStuff* mNewStuff = new KSudokuNewStuff( this );
// // 		mNewStuff->download();
// 	}
// 	else if( name == QString("shape-load") )
// 	{
// // 		loadCustomShapeFromPath();
// 	}
// 	else
// 	{
// 		int l = name.find('-');
// 		if(l==-1) return; //error
// 		QString shape = name.right(name.length()-l-1);
// 
// 		if(m_shapes.contains(shape))
// 		{
// 			if(m_shapes[shape] != NULL)
// 			{
// 				stateChanged("dubbing", StateReverse);
// 				Game game(PuzzleFactory().create_instance(custom, 0, difficulty, 1, false, m_shapes[shape]));
// 				addGame(game);
// 			}
// 			else
// 			{
// 				//TODO error
// 				printf("error1\n");
// 				return;
// 			}
// 		}
// 		else
// 		{
// 			//TODO error
// 			printf("error2\n");
// 			return;
// 		}
// 
// 		
// 	}
}

// TODO will be deprecated
void KSudoku::newGame() {
	selectGameType(m_defaultAction);
}

void KSudoku::loadGame(const KURL& url) {
	QString errorMsg;
	Game game = ksudoku::Serializer::load(url, this, &errorMsg);
	if(!game.isValid()) {
		KMessageBox::information(this, errorMsg);
		return;
	}
	
	addGame(game);
}

void KSudoku::setCentralWidget(QWidget* widget, bool autoDel) {
	QWidget* oldWidget = centralWidget();
	if(oldWidget) oldWidget->hide();
	if(m_autoDelCentralWidget) delete oldWidget; //moving up here fixes a roxdoku window bug
	m_autoDelCentralWidget = autoDel;

	QMainWindow::setCentralWidget(widget);
	widget->show();

	readProperties( KApplication::kApplication()->config()); //correct order: otherwise settings are not loaded
	adaptActions2View();
}

void KSudoku::showWelcomeScreen() {
	m_gameOptionsDlg = 0;
	setCentralWidget(m_gameSelDlg, false);
}

// <<<<<<< .mine
void KSudoku::selectGameType(const QString& type) {
	// TODO do this in an integrated dialog
	int typev = 0;
	int order = 0;
	bool noSymmetry = false;
	bool dub = false;
	QString shapeName;
	
	if(type == "play-sudoku") {
		typev = 0;
	} else if(type == "play-roxdoku") {
		typev = 1;
		noSymmetry = true;
	} else if(type == "edit-sudoku") {
		typev = 0;
		dub = true;
	} else if(type == "edit-roxdoku") {
		typev = 1;
		dub = true;
	} else if(type == "shape-download") {
		KSudokuNewStuff* mNewStuff = new KSudokuNewStuff( this );
		mNewStuff->download();
		return;
	} else if(type == "shape-load") {
		loadCustomShapeFromPath();
		return;
	} else if(type.startsWith("custom-")) {
		shapeName = type.mid(QString("custom-").length());
		if(m_shapes.contains(shapeName) && m_shapes[shapeName]) {
			typev = 2;
			order = -1;
			noSymmetry = true;
		} else {
			shapeName =  QString();
		}
	} else {
		return;
	}
	
	m_defaultAction = type;
	
	QVBox* page = new QVBox(this);
	GameOptionsDialog* options = new GameOptionsDialog(page, dub, typev);
	page->setStretchFactor(options, 1);
	options->setShapeName(shapeName);
	if(noSymmetry) options->setSymmetry(-1);
	if(order != 0) options->setOrder(order);
	m_gameOptionsDlg = options;
	
	QHButtonGroup* btns = new QHButtonGroup(page);
	QPushButton* btnBack = new QPushButton(i18n("To Welcomescreen"), btns);
	connect(btnBack, SIGNAL(clicked()), this, SLOT(showWelcomeScreen()));
	QPushButton* btnStart = 0;
	if(dub) {
		btnStart = new QPushButton(i18n("Edit Game"), btns);
		m_optionEnterOwnGame = true;
	} else {
		btnStart = new QPushButton(i18n("Start Game"), btns);
		m_optionEnterOwnGame = false;
	}
	connect(btnStart, SIGNAL(clicked()), this, SLOT(startSelectedGame()));
	
	setCentralWidget(page, true);
}

void KSudoku::startSelectedGame() {
	uint order = m_gameOptionsDlg->order();
	int difficulty = m_gameOptionsDlg->difficulty();
	uint type = m_gameOptionsDlg->type();
	uint symmetry = m_gameOptionsDlg->symmetry();
	QString shapeName = m_gameOptionsDlg->shapeName();
	
	m_gameOptionsDlg->writeSettings();
	
	if(m_optionEnterOwnGame) {
		stateChanged("dubbing", StateReverse);
		if(type == 0) {
			Game game(PuzzleFactory().create_instance(sudoku, order, 0, 0, true));
			addGame(game);
		} else if(type == 1) {
			Game game(PuzzleFactory().create_instance(roxdoku, order, 0, 0, true));
			addGame(game);
		}
	} else {
		stateChanged("dubbing");
		if(type == 0) {
			Game game(PuzzleFactory().create_instance(sudoku, order, difficulty, symmetry));
			addGame(game);
		} else if(type == 1) {
			Game game(PuzzleFactory().create_instance(roxdoku, order, difficulty, SIMMETRY_NONE));
			addGame(game);
		} else if(type == 2) {
			Game game(PuzzleFactory().create_instance(custom, 0, difficulty, 1, false, m_shapes[shapeName]));
			addGame(game);
		}
	}
}

void KSudoku::mouseOnlySuperscript()
{
// 	QWidget* current = m_tabs->currentPage();
//	QWidget* current = (QWidget*)currentView();
	if(ksudokuView* view = dynamic_cast<ksudokuView*>(currentView()))
		view->mouseOnlySuperscript = !view->mouseOnlySuperscript;
	else return;

	saveProperties( KApplication::kApplication()->config());
}

void KSudoku::setGuidedMode()
{
// 	QWidget* current = m_tabs->currentPage();
//	QWidget* current = (QWidget*) currentView();
	
	if(KsView* view = dynamic_cast<ksudokuView*>(currentView())) {
		((ksudokuView*)view)->toggleGuided();
		((ksudokuView*)view)->update();
		
	//	/// TODO fix this (rerender through reinit); ???
	//	view->setGame(view->game());
	}
	else
		return;

	saveProperties( KApplication::kApplication()->config());
}

void KSudoku::homepage()
{
	KRun::runURL (KURL("http://ksudoku.sourceforge.net/"), "text/html");
}
void KSudoku::support()
{
	KRun::runURL (KURL("http://sourceforge.net/project/project_donations.php?group_id=147876"), "text/html");
}
void KSudoku::sendComment()
{
	KRun::runURL (KURL("http://ksudoku.sourceforge.net/newcomment.php"), "text/html");
}

void KSudoku::checkForUpdates()
{
	QString name;
	char buf[16];
	QString myVer = "0.3";
	KIO::NetAccess::download(KURL("http://ksudoku.sourceforge.net/latest.php"), name, this);
		
	FILE *fp;
	
	if (!(fp = fopen(QFile::encodeName(name), "r"))) 
	{
		KMessageBox::information(this, "Could not get the response from server.");
		return;
	}

	fscanf(fp, "%s", buf);
	if(QString(&buf[0]) == myVer)
		KMessageBox::information(this, "Your program is at the latest version");
	else
	{
		QString msg;
		msg.sprintf("Your program version is %s, the latest version is %s.\nDo you want to update?",  myVer.ascii(), &buf[0]);
		if(KMessageBox::questionYesNo(this, msg) == KMessageBox::Yes)
			KRun::runURL (KURL("http://ksudoku.sourceforge.net/3.htm"), "text/html");
	}
	//close(fp);
	KIO::NetAccess::removeTempFile( name );
}

void KSudoku::giveHint()
{
	Game game = currentGame();
	if(!game.isValid()) return;
	game.giveHint();
}

void KSudoku::autoSolve()
{
	Game game = currentGame();
	if(!game.isValid()) return;
	game.autoSolve();
}
	
void KSudoku::dubPuzzle()
{
	Game game = currentGame();
	
	if(!game.isValid()) return;
	
	if(!game.simpleCheck()) {
		KMessageBox::information(this, i18n("The puzzle you entered contains some errors."));
		return;
	}

	int forks = 0;
	ksudoku::Puzzle* puzzle = game.puzzle()->dubPuzzle();
	int state = puzzle->init(game.allValues(), &forks);
		
	if(state <= 0) {
		KMessageBox::information(this, i18n("Sorry, No solutions have been found."));
		return;
	} else if(state == 1) {
		KMessageBox::information(this, i18n("The Puzzle you entered has only one solution. (Forks required: %1)").arg(forks));
	} else {
		KMessageBox::information(this, i18n("The Puzzle you entered has multiple solutions."));
	}
	
	if(KMessageBox::questionYesNo(this, i18n("Do you want to play the puzzle now?")) == 3)
	{
		ksudoku::Game* newGame = new ksudoku::Game(puzzle);
			
	// 		(new KSudoku(newGame))->show();
		addGame(*newGame);
		delete newGame;
	}
	else
	{
		delete puzzle;
	}
	
	return;
}
	
void KSudoku::genMultiple()
{
	//KMessageBox::information(this, i18n("Sorry, this feature is under development."));
}

void KSudoku::selectNumber(uint value) {
// 	QWidget* current = m_tabs->currentPage()<
	if(ksudokuView* view = dynamic_cast<ksudokuView*>( currentView())) {
		view->current_selected_number = value;
	} else if (RoxdokuView* view = dynamic_cast<RoxdokuView*>( currentView())) {
		view->selected_number = value;
	/*} else if (ksudokuCustomView* view = dynamic_cast<ksudokuCustomView*>(current)) {
		view->current_selected_number = value;*/
	} else return;
	updateStatusBar();
}

void KSudoku::set0 () { selectNumber(0); }
void KSudoku::set1 () { selectNumber(1); }
void KSudoku::set2 () { selectNumber(2); }
void KSudoku::set3 () { selectNumber(3); }
void KSudoku::set4 () { selectNumber(4); }
void KSudoku::set5 () { selectNumber(5); }
void KSudoku::set6 () { selectNumber(6); }
void KSudoku::set7 () { selectNumber(7); }
void KSudoku::set8 () { selectNumber(8); }
void KSudoku::set9 () { selectNumber(9); }
void KSudoku::set10 () { selectNumber(10); }
void KSudoku::set11 () { selectNumber(11); }
void KSudoku::set12 () { selectNumber(12); }
void KSudoku::set13 () { selectNumber(13); }
void KSudoku::set14 () { selectNumber(14); }
void KSudoku::set15 () { selectNumber(15); }
void KSudoku::set16 () { selectNumber(16); }

void KSudoku::set17 () { selectNumber(17); }
void KSudoku::set18 () { selectNumber(18); }
void KSudoku::set19 () { selectNumber(19); }
void KSudoku::set20 () { selectNumber(20); }
void KSudoku::set21 () { selectNumber(21); }
void KSudoku::set22 () { selectNumber(22); }
void KSudoku::set23 () { selectNumber(23); }
void KSudoku::set24 () { selectNumber(24); }
void KSudoku::set25 () { selectNumber(25); }

void KSudoku::setupActions()
{
	setAcceptDrops(true);
	
	KStdAction::openNew(this, SLOT(fileNew()),    actionCollection());
	KStdAction::open   (this, SLOT(fileOpen()),   actionCollection());
	KStdAction::save   (this, SLOT(fileSave()),   actionCollection());
	KStdAction::saveAs (this, SLOT(fileSaveAs()), actionCollection());
	KStdAction::print  (this, SLOT(filePrint()),  actionCollection());
	KStdAction::quit   (kapp, SLOT(quit()),       actionCollection());

	KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

	new KAction(i18n("&Export"), 0, this, SLOT(fileExport()), actionCollection(), "file_export");

	(void)new KAction(i18n("del"), 0, this, SLOT(set0()), actionCollection(), "0");
	(void)new KAction(i18n("1"), 0, this, SLOT(set1 ()), actionCollection(), "1");
	(void)new KAction(i18n("2"), 0, this, SLOT(set2 ()), actionCollection(), "2");
	(void)new KAction(i18n("3"), 0, this, SLOT(set3 ()), actionCollection(), "3");
	(void)new KAction(i18n("4"), 0, this, SLOT(set4 ()), actionCollection(), "4");
	(void)new KAction(i18n("5"), 0, this, SLOT(set5 ()), actionCollection(), "5");
	(void)new KAction(i18n("6"), 0, this, SLOT(set6 ()), actionCollection(), "6");
	(void)new KAction(i18n("7"), 0, this, SLOT(set7 ()), actionCollection(), "7");
	(void)new KAction(i18n("8"), 0, this, SLOT(set8 ()), actionCollection(), "8");
	(void)new KAction(i18n("9"), 0, this, SLOT(set9 ()), actionCollection(), "9");
	(void)new KAction(i18n("j"), 0, this, SLOT(set10()), actionCollection(), "j");
	(void)new KAction(i18n("k"), 0, this, SLOT(set11()), actionCollection(), "k");
	(void)new KAction(i18n("l"), 0, this, SLOT(set12()), actionCollection(), "l");
	(void)new KAction(i18n("m"), 0, this, SLOT(set13()), actionCollection(), "m");
	(void)new KAction(i18n("n"), 0, this, SLOT(set14()), actionCollection(), "n");
	(void)new KAction(i18n("o"), 0, this, SLOT(set15()), actionCollection(), "o");
	(void)new KAction(i18n("p"), 0, this, SLOT(set16()), actionCollection(), "p");

	(void)new KAction(i18n("q"), 0, this, SLOT(set17()), actionCollection(), "q");
	(void)new KAction(i18n("r"), 0, this, SLOT(set18()), actionCollection(), "r");
	(void)new KAction(i18n("s"), 0, this, SLOT(set19()), actionCollection(), "s");
	(void)new KAction(i18n("t"), 0, this, SLOT(set20()), actionCollection(), "t");
	(void)new KAction(i18n("u"), 0, this, SLOT(set21()), actionCollection(), "u");
	(void)new KAction(i18n("v"), 0, this, SLOT(set22()), actionCollection(), "v");
	(void)new KAction(i18n("w"), 0, this, SLOT(set23()), actionCollection(), "w");
	(void)new KAction(i18n("y"), 0, this, SLOT(set24()), actionCollection(), "x");
	(void)new KAction(i18n("x"), 0, this, SLOT(set25()), actionCollection(), "y");

	(void)new KAction(i18n("a"), 0, this, SLOT(set1()), actionCollection(), "a");
	(void)new KAction(i18n("b"), 0, this, SLOT(set2()), actionCollection(), "b");
	(void)new KAction(i18n("c"), 0, this, SLOT(set3()), actionCollection(), "c");
	(void)new KAction(i18n("d"), 0, this, SLOT(set4()), actionCollection(), "d");
	(void)new KAction(i18n("e"), 0, this, SLOT(set5()), actionCollection(), "e");
	(void)new KAction(i18n("f"), 0, this, SLOT(set6()), actionCollection(), "f");
	(void)new KAction(i18n("g"), 0, this, SLOT(set7()), actionCollection(), "g");
	(void)new KAction(i18n("h"), 0, this, SLOT(set8()), actionCollection(), "h");
	(void)new KAction(i18n("i"), 0, this, SLOT(set9()), actionCollection(), "i");

	//History
	KStdAction::undo   (this, SLOT(undo()),       actionCollection(), "move_undo");
	KStdAction::redo   (this, SLOT(redo()),       actionCollection(), "move_redo");
	(void)new KAction(i18n("Push checkpoint (add)"), CTRL+Key_A, this, SLOT(push()), actionCollection(), "move_add_group");
	(void)new KAction(i18n("Pop checkpoint (extract)"), CTRL+Key_E, this, SLOT(pop()), actionCollection(), "move_undo_group");
	
	// TODO replace this with KStdGameAction members when having libkdegames
	(void)new KAction(i18n("Give Hint!"),  0, this, SLOT(giveHint()), actionCollection(), "move_hint"); //DONE
	(void)new KAction(i18n("Solve!"), 0, this, SLOT(autoSolve()), actionCollection(), "move_solve");	//DONE
	//(void)new KAction(i18n("Generate Multiple"), 0, this, SLOT(genMultiple()), actionCollection(), "genMultiple");
	(void)new KAction(i18n("Check"), 0, this, SLOT(dubPuzzle()), actionCollection(), "move_dub_puzzle");

	//WEB
	(void)new KAction(i18n("Check for updates"), 0, this, SLOT(checkForUpdates()), actionCollection(), "checkForUpdates");
	(void)new KAction(i18n("Home page"), 0, this, SLOT(homepage()), actionCollection(), "Home_page");
	(void)new KAction(i18n("Support this project"), 0, this, SLOT(support()), actionCollection(), "support");
	(void)new KAction(i18n("Send comment"), 0, this, SLOT(sendComment()), actionCollection(), "SendComment");

	//Settings
	KToggleAction* a;
  	a = new KToggleAction(i18n("Mouse-Only superscript mode"), 0, this, SLOT(mouseOnlySuperscript()), actionCollection(), "mouseOnlySuperscript");
	a->setChecked(false);
	a->setEnabled(false);
	
	a=new KToggleAction(i18n("Guided mode (mark wrong red)"), 0, this, SLOT(setGuidedMode()), actionCollection(), "guidedMode");
	a->setChecked(false);
	a->setEnabled(false);

	a=new KToggleAction(i18n("Show tracker"), 0, this, SLOT(setShowTracker()), actionCollection(), "showTracker");
	a->setChecked(true);
	a->setEnabled(false);

}

void KSudoku::adaptActions2View() {
	// TODO This whole function is only a temporary hack, views should have their own UI
	
	ksudoku::KsView* current = currentView();
	
	if(ksudokuView* view = dynamic_cast<ksudokuView*>(current)) {
		KToggleAction* a;
		if((a = dynamic_cast<KToggleAction*>(action("mouseOnlySuperscript")))) {
			a->setEnabled(true);
			a->setChecked(view->mouseOnlySuperscript);
		}
		if((a = dynamic_cast<KToggleAction*>(action("guidedMode")))) {
			a->setEnabled(true);
			a->setChecked(view->guidedMode());
		}
		if((a = dynamic_cast<KToggleAction*>(action("showTracker")))) {
			a->setEnabled(true);
			a->setChecked(view->showTracker);
		}
	} else if(RoxdokuView* view = dynamic_cast<RoxdokuView*>(current)) {
		KToggleAction* a;
		if((a = dynamic_cast<KToggleAction*>(action("mouseOnlySuperscript")))) {
			a->setEnabled(false);
			a->setChecked(false);
		}
		if((a = dynamic_cast<KToggleAction*>(action("guidedMode")))) {
			a->setEnabled(true);
			a->setChecked(view->guidedMode());
		}
		if((a = dynamic_cast<KToggleAction*>(action("showTracker")))) {
			a->setEnabled(false);
			a->setChecked(false);
		}
	} else {
		KToggleAction* a;
		if((a = dynamic_cast<KToggleAction*>(action("mouseOnlySuperscript")))) {
			a->setEnabled(false);
			a->setChecked(false);
		}
		if((a = dynamic_cast<KToggleAction*>(action("guidedMode")))) {
			a->setEnabled(false);
			a->setChecked(false);
		}
		if((a = dynamic_cast<KToggleAction*>(action("showTracker")))) {
			a->setEnabled(false);
			a->setChecked(false);
		}
	}
	
	Game game = currentGame();
	if(game.isValid()) {
		action("file_save")->setEnabled(true);
		action("file_save_as")->setEnabled(true);
		
		action("move_undo")->setEnabled(game.canUndo());
		action("move_redo")->setEnabled(game.canRedo());
		action("move_add_group")->setEnabled(game.canAddCheckpoint());
		action("move_undo_group")->setEnabled(game.canUndo2Checkpoint());
		
		action("move_hint")      ->setEnabled(   game.puzzle()->hasSolution());
		action("move_solve")     ->setEnabled(   game.puzzle()->hasSolution());
		action("move_dub_puzzle")->setEnabled( ! game.puzzle()->hasSolution());
	} else {
		action("file_save")->setEnabled(false);
		action("file_save_as")->setEnabled(false);
		
		action("move_undo")->setEnabled(false);
		action("move_redo")->setEnabled(false);
		action("move_add_group")->setEnabled(false);
		action("move_undo_group")->setEnabled(false);
	
		action("move_hint")->setEnabled(false);
		action("move_solve")->setEnabled(false);
		action("move_dub_puzzle")->setEnabled(false);
	}
}

void KSudoku::onModified(bool /*isModified*/) {
	Game game = currentGame();
	if(game.isValid()) {
		action("move_undo")->setEnabled(game.canUndo());
		action("move_redo")->setEnabled(game.canRedo());
		action("move_add_group")->setEnabled(game.canAddCheckpoint());
		action("move_undo_group")->setEnabled(game.canUndo2Checkpoint());
	}
}

void KSudoku::undo() {
	Game game = currentGame();
	if(!game.isValid()) return;
	
	game.interface()->undo();
	
	if(!game.canUndo()) {
		action("move_undo")->setEnabled(false);
	}
}

void KSudoku::redo() {
	Game game = currentGame();
	if(!game.isValid()) return;
	
	game.interface()->redo();
	
	if(!game.canRedo()) {
		action("move_redo")->setEnabled(false);
	}
}

void KSudoku::push()
{
	// TODO replace this with history
// 	if(type == 0) {if(m_view) m_view->push();return;}
// 	if(glwin) glwin->push();
}

void KSudoku::pop()
{
	// TODO replace this with history
// 	if(type == 0) {if(m_view)  m_view->pop(); return;}
// 	if(glwin) glwin->pop();
}

void KSudoku::setShowTracker()
{
// 	QWidget* current = m_tabs->currentPage();
//	QWidget* current = (QWidget*) currentView();
	if(ksudokuView* view = dynamic_cast<ksudokuView*>(currentView())) {
		view->showTracker = !view->showTracker;
	} else return;
	
	saveProperties( KApplication::kApplication()->config());
}

void KSudoku::saveProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored

// 	config->writeEntry("lastURL", (type == 0) ? m_view->currentURL() : "");
// 	QWidget* current = m_tabs->currentPage();
//	QWidget* current = (QWidget*) currentView();
	if(ksudokuView* view = dynamic_cast<ksudokuView*>(currentView())) {
		config->writeEntry("guidedMode", view->guidedMode());
		config->writeEntry("mouseOnlySuperscript",  view->mouseOnlySuperscript);
		config->writeEntry("showTracker", view->showTracker );
	} else if(RoxdokuView* view = dynamic_cast<RoxdokuView*>(currentView())) {
		config->writeEntry("guidedMode", view->guidedMode());
	}

	config->writeEntry("FIRSTRUN0.3", 1);
	config->sync();
}

void KSudoku::readProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'

    QString url = config->readEntry("lastURL");
	if(config->readBoolEntry("FIRSTRUN0.3") == 0)
	{	
// 		QWidget* current = m_tabs->currentPage();
//		QWidget* current = (QWidget*) currentView();
		if(ksudokuView* view = dynamic_cast<ksudokuView*>(currentView())) {
			view->setGuidedMode(true);
			view->mouseOnlySuperscript = true;
			view->showTracker = true;
		} else if(RoxdokuView* view = dynamic_cast<RoxdokuView*>(currentView())) {
			view->setGuidedMode(true);
		}
		saveProperties(config);
		return;
	}

// 	QWidget* current = m_tabs->currentPage();
//	QWidget* current = (QWidget*) currentView();
	if(ksudokuView* view = dynamic_cast<ksudokuView*>(currentView())) {
		view->setGuidedMode(config->readBoolEntry("guidedMode"));
		view->showTracker = config->readBoolEntry("showTracker");
   		view->mouseOnlySuperscript = config->readBoolEntry("mouseOnlySuperscript");
	} else if(RoxdokuView* view = dynamic_cast<RoxdokuView*>(currentView())) {
		view->setGuidedMode(config->readBoolEntry("guidedMode"));
	}
}

void KSudoku::dragEnterEvent(QDragEnterEvent *event)
{
    // accept uri drops only
    event->accept(KURLDrag::canDecode(event));
}

void KSudoku::dropEvent(QDropEvent *event)
{
    // this is a very simplistic implementation of a drop event.  we
    // will only accept a dropped URL.  the Qt dnd code can do *much*
    // much more, so please read the docs there
    KURL::List urls;

    // see if we can decode a URI.. if not, just ignore it
    if (KURLDrag::decode(event, urls) && !urls.isEmpty())
    {
        // okay, we have a URI.. process it
        const KURL &url = urls.first();
		
		Game game = ksudoku::Serializer::load(url, this);
// 		if(game)
// 			(new KSudoku(game))->show();
		if(game.isValid())
			addGame(game);
// 		delete game;
    }
}

void KSudoku::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

	// TODO onyl show this when there is a game running
	if(KMessageBox::questionYesNo(this, i18n("Do you really want to end this game in order to start a new one")) != KMessageBox::Yes)
		return;
	
	newGame();
}

void KSudoku::fileOpen()
{
	// this slot is called whenever the File->Open menu is selected,
	// the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
	// button is clicked
	// standard filedialog
	KURL url = KFileDialog::getOpenURL(QString::null, QString::null, this, i18n("Open Location"));
	
	if (!url.isEmpty() && url.isValid())
	{
		Game game = ksudoku::Serializer::load(url, this);
		if(!game.isValid()) {
			KMessageBox::error(this, i18n("Couldn't load game."));
			return;
		}
		
		game.setURL(url);
// 		(new KSudoku(game))->show();
		addGame(game);
// 		delete game;
	}	
}

void KSudoku::fileSave()
{
    // this slot is called whenever the File->Save menu is selected,
    // the Save shortcut is pressed (usually CTRL+S) or the Save toolbar
    // button is clicked

    // save the current file
	
	Game game = currentGame();
	if(!game.isValid()) return;

	if(game.getURL().isEmpty()) game.setURL(KFileDialog::getSaveURL());
    if (!game.getURL().isEmpty() && game.getURL().isValid())
		ksudoku::Serializer::store(game, game.getURL(), this);
}

void KSudoku::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
	Game game = currentGame();
	if(!game.isValid()) return;
	
	game.setURL(KFileDialog::getSaveURL());
    if (!game.getURL().isEmpty() && game.getURL().isValid())
    	fileSave();
}


void KSudoku::filePrint()
{
    // this slot is called whenever the File->Print menu is selected,
    // the Print shortcut is pressed (usually CTRL+P) or the Print toolbar
    // button is clicked

// 	Game* game = currentGame();
	ksudoku::KsView* view = currentView();
	if(view)
		ksudoku::Print p(*view);// *game, game->solver()->g->sizeZ() > 0);
	//else ??? give message noting to print with hint what is printable ??
}

void KSudoku::fileExport()
{
	Game game = currentGame();
	if(!game.isValid()) return;
	
	ksudoku::ExportDlg e(*game.puzzle(), *game.symbols() );

	e.exec();
}

void KSudoku::optionsPreferences()
{
    // popup some sort of preference dialog, here
/*    ksudokuPreferences dlg;
    if (dlg.exec())
    {
        // redo your settings
    }*/
}

void KSudoku::changeStatusbar(const QString& text)
{
    // display the text on the statusbar
    statusBar()->message(text);
}

void KSudoku::changeCaption(const QString& text)
{
    // display the text on the caption
    setCaption(text);
}

Game KSudoku::currentGame() const {
	ksudoku::KsView* view = currentView();

	if(view)
		return view->game();
	else
		return Game();
}

ksudoku::KsView* KSudoku::currentView() const{
// 	if(ksudoku::KsView* view = dynamic_cast<KsView*>(m_tabs->currentPage()))
// 		return view;
// 	else
// 		return 0;
	return dynamic_cast<KsView*>(centralWidget());
}

void KSudoku::loadCustomShapeFromPath()
{
	KURL url = KFileDialog::getOpenURL( QString::null, QString::null, this, i18n("Open Location") );
	
	if ( url.isEmpty() || !url.isValid() )
	{
		//TODO ERROR
		return;
	}	
	
	QString tmpFile;
	bool success = false;
	QDomDocument doc;
	if(!KIO::NetAccess::download( url, tmpFile, this )) 
	{
		//TODO ERROR
		return;	
	}
	
	KStandardDirs myStdDir;
	const QString destDir = myStdDir.saveLocation( "data", kapp->instanceName() + "/", true );
	KStandardDirs::makeDir( destDir );

	KTar archive( tmpFile );

	if ( archive.open( IO_ReadOnly ) )
	{
		const KArchiveDirectory *archiveDir = archive.directory();
		archiveDir->copyTo( destDir );
		archive.close();
	}
	else
	{
		//just copy
		KIO::file_copy (url, destDir);
	}

	KIO::NetAccess::removeTempFile(tmpFile);
	updateCustomShapesList();
}


KSudokuNewStuff::KSudokuNewStuff( KSudoku* v ) :
        KNewStuff( "ksudoku", (QWidget*) v )
{
	parent = v;
}

bool KSudokuNewStuff::install( const QString &fileName )
{
	KTar archive( fileName );
	if ( !archive.open( IO_ReadOnly ) )
		return false;

	const KArchiveDirectory *archiveDir = archive.directory();
	KStandardDirs myStdDir;
	const QString destDir = myStdDir.saveLocation("data", kapp->instanceName() + "/", true);
	KStandardDirs::makeDir(destDir);

	archiveDir->copyTo(destDir);
	archive.close();
	//find custom shapes
	parent->updateCustomShapesList();
	return true;
}

bool KSudokuNewStuff::createUploadFile( const QString &fileName )
{
	return true;
}



#include "ksudoku.moc"
