/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ksociogramaMainWindow.h"
#include <kstdaction.h>
#include <kaction.h>
#include "ksociograma.h"
#include <kaboutdata.h>
#include <qfiledialog.h>
#include <kstandarddirs.h> //para  locate
#include <qapplication.h>
#include <qiconset.h>
#include <kapplication.h> //para el font

#include <qfontmetrics.h>
#include <iostream.h> // para sacar con cout
#include <qtextstream.h> // para las qWarning

ksociogramaMainWindow::ksociogramaMainWindow() : KMainWindow (0,"ksociogramaMainWindow"), myksociograma(new ksociograma(this,0,0,new sociometricTest(), 
KStdAction::openNew (this, SLOT(slotFileNew()), actionCollection() ),
KStdAction::open (this, SLOT(slotFileOpen()), actionCollection() ),
KStdAction::save (this, SLOT(slotFileSave()), actionCollection() ),
KStdAction::print (this, SLOT(slotFilePrint()), actionCollection() ),
KStdAction::quit (this, SLOT(slotFileQuit()), actionCollection() ),
new KAction(i18n("&Test form"), QIconSet( QPixmap(locate ("data", "ksociograma/pics/testIcon32.xpm")) ), Qt::CTRL+Qt::Key_T, this, SLOT(slotOpenQuestionnaire() ), actionCollection(), "openquestionnaire_action")
))
{






// accept dnd
setAcceptDrops(true);
// tell the KMainWindow that this is indeed the main widget
setCentralWidget(myksociograma);


//TODO para tener control de las kaction, las paso a la clase ksociograma y desde all las controlo, pero no me gusta el mtodo tan barbaro. Pensar otra forma de implementar esto (funciones amigas?)
/*
actOpenNew = KStdAction::openNew (this, SLOT(slotFileNew()), actionCollection() );
actOpen = KStdAction::open (this, SLOT(slotFileOpen()), actionCollection() );
actSave = KStdAction::save (this, SLOT(slotFileSave()), actionCollection() );
actSaveAs = KStdAction::saveAs (this, SLOT(slotFileSaveAs()), actionCollection() );
actPrint = KStdAction::print (this, SLOT(slotFilePrint()), actionCollection() );
actClose = KStdAction::close (this, SLOT(slotFileClose()), actionCollection() );
actQuit = KStdAction::quit (this, SLOT(slotFileQuit()), actionCollection() );

actCut = KStdAction::cut (this, SLOT(slotEditCut()), actionCollection() );
actCopy = KStdAction::copy (this, SLOT(slotEditCopy()), actionCollection() );
actPaste = KStdAction::paste (this, SLOT(slotEditPaste()), actionCollection() );

actPreferences = KStdAction::preferences (this, SLOT(slotSettingPreferences()), actionCollection() );
actConfigureToolbars = KStdAction::configureToolbars (this, SLOT(slotSettingConfigureToolbars()), actionCollection() );

openQuestionnaire = new KAction(i18n("&Test form"), Qt::CTRL+Qt::Key_T, this, SLOT(slotOpenQuestionnaire()), actionCollection(), "openquestionnaire_action");
*/


//createGUI("ksociogramaui.rc"); 
createGUI();




//slot para el control del tamao de la fuente
KApplication::connect( kapp, SIGNAL(kdisplayFontChanged ()), this, SLOT(slotFontChanged()) );

//hay que llamar una primera vez al slot para ajustar el tamao de las fuente
//al arrancar el programa
slotFontChanged();
}



ksociogramaMainWindow::~ksociogramaMainWindow()
{}

/*$SPECIALIZATION$*/
void ksociogramaMainWindow::slotHelpReportBug() 
{}

void ksociogramaMainWindow::slotSettingConfigureToolbars() 
{}

void ksociogramaMainWindow::slotSettingPreferences() 
{}

void ksociogramaMainWindow::slotEditPaste() 
{}

void ksociogramaMainWindow::slotEditCopy() 
{}

void ksociogramaMainWindow::slotEditCut() 
{}

void ksociogramaMainWindow::slotFileQuit() 
{
QWidget::close();
}

void ksociogramaMainWindow::slotFileClose() 
{}

void ksociogramaMainWindow::slotFilePrint() 
{
myksociograma->printTest();
}

void ksociogramaMainWindow::slotFileSaveAs() 
{

}

void ksociogramaMainWindow::slotFileSave() 
{
myksociograma->saveTest();
}

void ksociogramaMainWindow::slotFileNew() 
{
myksociograma->newTest();
}

void ksociogramaMainWindow::slotFileOpen() 
{
myksociograma->loadTest();
}


/*!
    \fn ksociogramaMainWindow::slotOpenQuestionnaire()
 */
void ksociogramaMainWindow::slotOpenQuestionnaire()
{
myksociograma->openQuestionnaire();
}


void ksociogramaMainWindow::closeEvent(QCloseEvent* event)
{
myksociograma->closeAplication(event);
}

void ksociogramaMainWindow::timeOut()
{
this->showMaximized();
}





/*!
    slot para control del cambio de fuente
 */
void ksociogramaMainWindow::slotFontChanged()
{
 //control del tamao de letra para que no aparezca muy grande y se salga de
//los objetos. Se usa la letra por defecto que el usuario usa en KDE


QFont myFont = QFont( ); //default applicattion font
QFontMetrics myFontMetric = QFontMetrics( myFont );
//int pixelWidth = myFontMetric.width( " KSOCIOGRAMA, ksociograma. " );
//QString pw;
//qWarning(pw.setNum(pixelWidth));

//pixel de resolucion horizontal de pantalla
QRect qRect(QApplication::desktop()->screenGeometry());
double horiz=qRect.width();
//qWarning(pw.setNum(206.00*horiz/1024.00));


while (myFontMetric.width( " KSOCIOGRAMA, ksociograma. " ) > 206.00*horiz/1024.00)
	{
	myFont.setPointSize( myFont.pointSize()-1 );
	KApplication::setFont ( myFont, TRUE);
	myFontMetric = QFontMetrics( myFont );
	}

}
