//
// C++ Implementation: showheaderdialog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "showheaderdialog.h"

ShowHeaderDialog::ShowHeaderDialog( QWidget * parent, QString & caption, QString & subject, QString header ) :
    KDialogBase( parent, "showheaderdialog", true, caption, KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true )
{
  //create main widget
  QWidget* mainWidget = new QWidget( this );
  setMainWidget( mainWidget );

  //this layout seperates meta data area (subject) from the mail header area
  QVBoxLayout* layMain = new QVBoxLayout( mainWidget, 0, spacingHint() );

  //this layout arranges the labels and lines for the meta datas
  QHBoxLayout* layMetaDatas = new QHBoxLayout( layMain, spacingHint() );

  //create label for subject
  QLabel* lblSubject = new QLabel( i18n( "Subject:" ), mainWidget, "lblSubject" );
  layMetaDatas->addWidget( lblSubject );

  //create line edit for subject
  KLineEdit* liSubject = new KLineEdit( subject, mainWidget, "liSubject" );
  liSubject->setReadOnly( true );
  layMetaDatas->addWidget( liSubject );

  //create text edit for the header
  KTextEdit* txtHeader = new KTextEdit( mainWidget );

  txtHeader->setText( header );
  txtHeader->setMinimumSize( WIDTH_VIEW_MAILHEADER, HEIGHT_VIEW_MAILHEADER );

  layMain->addWidget( txtHeader );
}



ShowHeaderDialog::~ShowHeaderDialog()
{
}


#include "showheaderdialog.moc"
