/***************************************************************************
                          filterelem.h  -  description
                             -------------------
    begin                : Die Sep 23 2003
    copyright            : (C) 2003 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERELEM_H
#define FILTERELEM_H

#include "showrecordelem.h"

/**
  *@author Eggert Ehmke
  */

class ShowRecordElem;

class FilterRecord
{
  public:
  // this sequence must not be changed. See FilterEntryDlg.ui
  enum filterType {from, subject, header, size, to};
  enum expressionType {contains, contains_not, equals, equals_not, greater, less};

  FilterRecord ();
  FilterRecord (filterType type, expressionType expression, const QString& match, bool CaseSensitive, bool regExp);
  bool matches (ShowRecordElem*);
  QString toString () const;

  filterType _type;
  expressionType _expression;
  QString _match;
  bool _CaseSensitive;
  bool _RegExp;
};

class FilterElem {
public:
  // this sequence must not be changed. See FilterEntryDlg.ui
  enum secondCondition {noSecondCondition, condAnd, condOr};

	FilterElem();
  FilterElem (const FilterRecord&);
  FilterElem (const FilterElem&);
  void setSecondCondition (secondCondition scnd, const FilterRecord&);

  ~FilterElem();
  QString toString () const;

  FilterRecord _filter1;
  FilterRecord _filter2;

  secondCondition _secondCondition;

  bool matches (ShowRecordElem*);

  /**
   * Returns the number of mail deletions which was caused by this filter.
   * @return number of deleted mails
   */
  unsigned int getCounter();

  /**
   * Sets the deleted mail counter.
   * @param number number of mail deletions caused by this filter
   */
  void setCounter( unsigned int number );

  /**
   * Increments the deleted mail counter.
   */
  void incCounter();

  private:

    /**
     * Number of mails its deletion was caused by this filter.
     */
    unsigned int _counter;
};

#endif
