/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktcategoryview.h"
#include "kktcategoryitem.h"

#include <kdebug.h>
#include <klocale.h>

#include <kstandarddirs.h>
#include <qfile.h>
#include <qdom.h>

using namespace KKTemplate;

KKTCategoryView::KKTCategoryView( QWidget* parent, const char* name )
	: KListView( parent, name )
{
	addColumn( i18n( "Category" ) );
// 	addColumn( i18n( "Sort" ) );
	setFullWidth( true );
	setRootIsDecorated( true );
	setSorting( 1 );
	readData();
}

KKTCategoryView::~KKTCategoryView()
{
}

void KKTCategoryView::readData()
{
	QString path = KGlobal::dirs()->findResource( "data", KGlobal::instance()->instanceName() + "/templates/" );
	QString datafile = KGlobal::dirs()->findResource( "data", KGlobal::instance()->instanceName() + "/template.xml" );

	QDomDocument doc( "kktemplate" );
	QFile file( datafile );
	if( file.open( IO_ReadOnly ) )
	{
		if( !doc.setContent( &file ) )
		{
			kdError() << i18n( "Can't analize %1" ).arg( datafile ) << endl;
			file.close();
			return;
		}
		file.close();
	}
	else
	{
		kdError() << i18n( "Can't open %1" ).arg( datafile ) << endl;
		return;
	}
	int i = 0;
	for( QDomNode node = doc.documentElement().firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		( new KKTCategoryItem( this, node.toElement(), path ) )->setText( 1, QString( "%1" ).arg( i++, 3 ) );
	}
}
