/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkacontactdata.h"

#include "kkahomeaddress.h"
#include "kkaofficeaddress.h"

using namespace KKAddressBook;

KKAContactData::KKAContactData( QObject* parent )
 : KKAPersonalData( parent )
 , m_home( NULL )
 , m_office( NULL )
{
	m_home = new KKAHomeAddress( this );
	m_office = new KKAOfficeAddress( this );
	connect( m_home, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	connect( m_office, SIGNAL( updated() ), this, SIGNAL( updated() ) );
}

KKAContactData::KKAContactData( QObject* parent
							  , const QString& prefix
							  , const QString& name
							  , const QString& suffix
							  )
 : KKAPersonalData( parent
				  , prefix
				  , name
				  , suffix
				  )
 , m_home( NULL )
 , m_office( NULL )
{
	m_home = new KKAHomeAddress( this );
	m_office = new KKAOfficeAddress( this );
	connect( m_home, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	connect( m_office, SIGNAL( updated() ), this, SIGNAL( updated() ) );
}

KKAContactData::KKAContactData( QObject* parent, QDomElement e )
 : KKAPersonalData( parent, e )
{
	for( QDomNode child = e.lastChild(); !child.isNull(); child = child.previousSibling() )
	{
		QDomElement elem = child.toElement();
		switch( elem.attribute( "locationType" ).toInt() )
		{
			case KKAAddressData::Home:
				m_home = new KKAHomeAddress( this, elem );
				break;
			case KKAAddressData::Office:
				m_office = new KKAOfficeAddress( this, elem );
				break;
		}
	}
	if( !m_home ) m_home = new KKAHomeAddress( this );
	if( !m_office ) m_office = new KKAOfficeAddress( this );
	connect( m_home, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	connect( m_office, SIGNAL( updated() ), this, SIGNAL( updated() ) );
}

QDomElement KKAContactData::toElement( QDomDocument& doc )
{
	QDomElement elem = KKAPersonalData::toElement( doc );
	elem.appendChild( m_home->toElement( doc ) );
	elem.appendChild( m_office->toElement( doc ) );
	return elem;
}

KKAAddressData* KKAContactData::current()
{
	if( m_home->preference() ) return m_home;
	if( m_office->preference() ) return m_office;
	m_home->setPreference( true );
	return m_home;
	return NULL;
}

const KKAAddressData* KKAContactData::const_current() const
{
	if( m_home->preference() ) return m_home;
	if( m_office->preference() ) return m_office;
	m_home->setPreference( true );
	return m_home;
	return NULL;
}

void KKAContactData::setCurrent( KKAAddressData::LocationType l )
{
	m_home->setPreference( m_home->locationType() == l );
	m_office->setPreference( m_office->locationType() == l );
	emit updated();
}
