/**************************************************************************
*   Copyright (C) 2005 by Conrad Hoffmann                                 *
*   conrausch@gmx.de                                                      *
*   http://conrausch.doesntexist.org                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/


#ifndef KOPETEDESKLISTROOTWIDGET_H
#define KOPETEDESKLISTROOTWIDGET_H

#include <qwidget.h>


class KRootPixmap;
class QVBoxLayout;
class QMouseEvent;
class KopeteDesklistItem;


class KopeteDesklistRootWidget : public QWidget
{
	Q_OBJECT
public:
	enum HGrowth { Left, Right };
	enum VGrowth { Top, Bottom, Both };

	KopeteDesklistRootWidget( QWidget* parent = 0, const char* name = 0 );
	~KopeteDesklistRootWidget();

	void reposition();
	QVBoxLayout* rootLayout();

private:
	QVBoxLayout* m_rootLayout;
	KRootPixmap *m_rootPixmap;
};


#endif
