#ifndef XOSD_H_
#define XOSD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qwidget.h>
#include <qfont.h>

#include <netwm.h>
#include <kwin.h>

class xosd : public QWidget
{
Q_OBJECT
   public:
      xosd(QWidget* parent=0, const char *name=0);

      virtual ~xosd();
      void setText(QString t);
      void setFont(QString font);
      void setItalic();
      void setBold();
      void setSize(int size);
      void setColor(QString color);
      void setShadowColor(QString color);
      void setShadowOffset(int off);
      int fontSize;
      int w, h;
      int fontStyle;
      QString fontFamily;

   private:
      NETWinInfo *info;
      QString text;
      QFont f;
      QString fontColor;
      QString shadowColor;
      int shadowOffset;

   protected:
      void paintEvent(QPaintEvent *);
};
#endif // XOSD_H_
