/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kdialogbase.h>
#include <kstandarddirs.h>
#include <kpushbutton.h>
#include <kdirselectdialog.h>
#include <kmessagebox.h>
#include <kurl.h>
#include <kuser.h>
#include <kconfig.h>

#include <qtoolbutton.h>
#include <qtable.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qwidgetstack.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qcombobox.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qradiobutton.h>

#include "kompileprofilewidget.h"
#include "kompileprofileselectionwidget.h"


KompileProfileWidget::KompileProfileWidget(QWidget *parent, const char *name)
    :KompileProfileWidgetBase(parent, name)
{
  init();
}

KompileProfileWidget::KompileProfileWidget(QString& profile_name, QWidget *parent, const char *name) : KompileProfileWidgetBase(parent, name)
{
  init();
  loadProfile(profile_name);
}

KompileProfileWidget::~KompileProfileWidget()
{
  /*
  delete tblFeatures->cellWidget(0,1);
  delete tblFeatures->cellWidget(1,1);
  delete tblFeatures->cellWidget(2,1);
  delete tblFeatures->cellWidget(3,1);
  delete tblFeatures->cellWidget(4,1);
  delete tblFeatures->cellWidget(5,1);
  delete tblFeatures->cellWidget(6,1);
  delete tblFeatures->cellWidget(7,1);
  delete tblFeatures->cellWidget(8,1);
  delete tblFeatures->cellWidget(9,1);
  delete tblFeatures->cellWidget(10,1);
  delete tblFeatures->cellWidget(11,1);
  delete tblFeatures->cellWidget(12,1);
  delete tblFeatures->cellWidget(13,1);
  delete tblFeatures->cellWidget(14,1);
  delete tblFeatures->cellWidget(15,1);
  delete tblFeatures->cellWidget(16,1);
  delete tblFeatures->cellWidget(17,1);
  delete tblFeatures->cellWidget(18,1);
  delete tblFeatures->cellWidget(19,1);
  delete tblFeatures->cellWidget(20,1);
  delete tblFeatures->cellWidget(21,1);
  delete tblFeatures->cellWidget(22,1);
  delete tblFeatures->cellWidget(23,1);
  delete tblPackages->cellWidget(0,1);
  delete tblPackages->cellWidget(1,1);
  delete tblPackages->cellWidget(8,1);
  */
}

void KompileProfileWidget::init()
{
  btnBrowseTarball->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnBrowseInstallationDir->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnBrowseDecompression->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnBrowseCheckinstallDir->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnCC->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnCXX->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnFF->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));
  btnBrowseUserInstallDir->setIconSet(KGlobal::iconLoader()->loadIcon("folder", KIcon::Desktop, 16));

  lblPackageState->hide();

  tblDirectories->setLeftMargin(0);
  tblProgram->setLeftMargin(0);
  tblFeatures->setLeftMargin(0);
  tblPackages->setLeftMargin(0);

  tblDirectories->setColumnReadOnly(0, TRUE);
  tblDirectories->setColumnReadOnly(2, TRUE);
  tblProgram->setColumnReadOnly(0, TRUE);
  tblProgram->setColumnReadOnly(2, TRUE);
  tblFeatures->setColumnReadOnly(0, TRUE);
  tblFeatures->setColumnReadOnly(2, TRUE);
  tblPackages->setColumnReadOnly(0, TRUE);
  tblPackages->setColumnReadOnly(2, TRUE);

  KUser * whoami = new KUser();
  if (!whoami->isSuperUser())
    bgUserChoice->setEnabled(TRUE);
  delete whoami;

  loadConfigOptions();
}


void KompileProfileWidget::switchToExpertMode()
{
  wgtConfiguration->raiseWidget(1);

  if (chkPrefix->isChecked())
    tblDirectories->setText(0, 1, txtInstallationDir->text());

  if (chkDebug->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(1,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(1,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkProfiling->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(5,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(5,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkEmbedded->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(17,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(17,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkQtopia->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(18,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(18,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkMac->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(19,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(19,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkFinal->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(9,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(9,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  if (chkWarnings->isChecked())
    ((QComboBox *) tblFeatures->cellWidget(4,1))->setCurrentText(tr2i18n(tr2i18n("yes")));
  else
    ((QComboBox *) tblFeatures->cellWidget(4,1))->setCurrentText(tr2i18n(tr2i18n("no")));

  tblDirectories->adjustColumn(1);
  tblFeatures->adjustColumn(1);
}

void KompileProfileWidget::switchToNormalMode()
{
  wgtConfiguration->raiseWidget(0);

  if (!tblDirectories->text(0, 1).stripWhiteSpace().isEmpty())
  {
    chkPrefix->setChecked(TRUE);
    txtInstallationDir->setText(tblDirectories->text(0, 1));
  }
  else
  {
    chkPrefix->setChecked(FALSE);
    txtInstallationDir->clear();
  }

  if (((QComboBox *) tblFeatures->cellWidget(1,1))->currentText() == tr2i18n("yes"))
    chkDebug->setChecked(TRUE);
  else
    chkDebug->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(5,1))->currentText() == tr2i18n("yes"))
    chkProfiling->setChecked(TRUE);
  else
    chkProfiling->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(17,1))->currentText() == tr2i18n("yes"))
    chkEmbedded->setChecked(TRUE);
  else
    chkEmbedded->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(19,1))->currentText() == tr2i18n("yes"))
    chkQtopia->setChecked(TRUE);
  else
    chkQtopia->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(19,1))->currentText() == tr2i18n("yes"))
    chkMac->setChecked(TRUE);
  else
    chkMac->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(9,1))->currentText() == tr2i18n("yes"))
    chkFinal->setChecked(TRUE);
  else
    chkFinal->setChecked(FALSE);

  if (((QComboBox *) tblFeatures->cellWidget(4,1))->currentText() == tr2i18n("yes"))
    chkWarnings->setChecked(TRUE);
  else
    chkWarnings->setChecked(FALSE);

}

void KompileProfileWidget::chkExpertConfiguration_stateChanged(int state)
{
  if (chkExpertConfiguration->isChecked())
    switchToExpertMode();
  else
    switchToNormalMode();
}

void KompileProfileWidget::bgDecmpress_clicked(int button)
{
  gbUserDir->setEnabled(button == 1);

}

void KompileProfileWidget::btnBrowseTarball_clicked()
{
  QString tarball = KFileDialog::getOpenFileName("", "*.tar *.tar.gz *.tar.gz2 *.tgz *.tar.bz *.tar.bz2|" + tr2i18n("Source Tarball Archives"), this, "TarballSelectDialog");

  if (tarball.isEmpty())
    return;

  txtTarballDir->setText(tarball);

  QStringList path_tokens = QStringList::split("/", tarball);
  QStringList file_tokens = QStringList::split(".t", path_tokens[path_tokens.count() - 1]);
  QStringList tarball_datas = QStringList::split("-", file_tokens[0]);

  txtName->setText(tarball_datas[0]);
  if (tarball_datas.count() > 1)
    txtVersion->setText(tarball_datas[1]);
  else
    txtVersion->clear();

  if (tarball_datas.count() > 2)
    txtRelease->setText(tarball_datas[2]);
  else
    txtRelease->clear();
}

void KompileProfileWidget::chkPrefix_toggled(bool toggled)
{
  gbInstallationDir->setEnabled(toggled);
}

void KompileProfileWidget::chkNoInstall_toggled(bool toggled)
{
  gbCheckinstall->setEnabled(!toggled);

  KUser * whoami = new KUser();
  if (!whoami->isSuperUser())
    bgUserChoice->setEnabled(!toggled);
  delete whoami;
}

void KompileProfileWidget::btnBrowseInstallationDir_clicked()
{
  KURL path_url = KDirSelectDialog::selectDirectory(txtInstallationDir->text());

  if (path_url.path().length() > 0)
    txtInstallationDir->setText(path_url.path());
}

void KompileProfileWidget::btnBrowseDecompression_clicked()
{
  KURL path_url = KDirSelectDialog::selectDirectory(txtDecompressionDir->text());

  if (path_url.path().length() > 0)
    txtDecompressionDir->setText(path_url.path());
}


void KompileProfileWidget::txtCheckinstallDir_textChanged(const QString&)
{
  QFileInfo tarball(txtCheckinstallDir->text());

  bgCheckinstallPackage->setEnabled(tarball.exists() && tarball.isExecutable());
}

void KompileProfileWidget::loadConfigOptions()
{
  tblDirectories->setText(0,0,"--prefix");
  tblDirectories->setText(0,2,tr2i18n("install architecture-independent files in PREFIX [/opt/kde]"));
  tblDirectories->setText(1,0,"--exec-prefix");
  tblDirectories->setText(1,2,tr2i18n("install architecture-dependent files in EPREFIX [PREFIX]"));
  tblDirectories->setText(2,0,"--bindir");
  tblDirectories->setText(2,2,tr2i18n("user executables [EPREFIX/bin]"));
  tblDirectories->setText(3,0,"--sbindir");
  tblDirectories->setText(3,2,tr2i18n("system admin executables [EPREFIX/sbin]architecture-dependent files in EPREFIX [PREFIX]"));
  tblDirectories->setText(4,0,"--libexecdir");
  tblDirectories->setText(4,2,tr2i18n("program executables [EPREFIX/libexec]"));
  tblDirectories->setText(5,0,"--datadir");
  tblDirectories->setText(5,2,tr2i18n("read-only architecture-independent data [PREFIX/share]"));
  tblDirectories->setText(6,0,"--sysconfdir");
  tblDirectories->setText(6,2,tr2i18n("read-only single-machine data [PREFIX/etc]"));
  tblDirectories->setText(7,0,"--sharedstatedir");
  tblDirectories->setText(7,2,tr2i18n("modifiable architecture-independent data [PREFIX/com]"));
  tblDirectories->setText(8,0,"--localstatedir");
  tblDirectories->setText(8,2,tr2i18n("modifiable single-machine data [PREFIX/var]"));
  tblDirectories->setText(9,0,"--libdir");
  tblDirectories->setText(9,2,tr2i18n("object code libraries [EPREFIX/lib]"));
  tblDirectories->setText(10,0,"--includedir");
  tblDirectories->setText(10,2,tr2i18n("C header files [PREFIX/include]"));
  tblDirectories->setText(11,0,"--oldincludedir");
  tblDirectories->setText(11,2,tr2i18n("C header files for non-gcc [/usr/include]"));
  tblDirectories->setText(12,0,"--infodir");
  tblDirectories->setText(12,2,tr2i18n("info documentation [PREFIX/info]"));
  tblDirectories->setText(13,0,"--mandir");
  tblDirectories->setText(13,2,tr2i18n("man documentation [PREFIX/man]"));
  tblDirectories->adjustColumn(0);
  tblDirectories->adjustColumn(1);
  tblDirectories->adjustColumn(2);

  tblProgram->setText(0,0,"--program-prefix");
  tblProgram->setText(0,2, tr2i18n("prepend PREFIX to installed program names"));
  tblProgram->setText(1,0,"--program-suffix");
  tblProgram->setText(1,2, tr2i18n("append SUFFIX to installed program names"));
  tblProgram->setText(2,0,"--program-transform-name");
  tblProgram->setText(2,2, tr2i18n("run sed PROGRAM on installed program names"));
  tblProgram->setText(3,0,"--build");
  tblProgram->setText(3,2, tr2i18n("configure for building on BUILD [guessed]"));
  tblProgram->setText(4,0,"--host");
  tblProgram->setText(4,2, tr2i18n("cross-compile to build programs to run on HOST [BUILD]"));
  tblProgram->setText(5,0,"--target");
  tblProgram->setText(5,2, tr2i18n("configure for building compilers for TARGET [HOST]"));
  tblProgram->adjustColumn(0);
  tblProgram->adjustColumn(1);
  tblProgram->adjustColumn(2);

  tblFeatures->setText(0,0,"--disable-fast-perl");
  tblFeatures->setCellWidget(0,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(0,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(0,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(0,2, tr2i18n("disable fast Makefile generation (needs perl)"));
  tblFeatures->setText(1,0,"--enable-debug");
  tblFeatures->setCellWidget(1,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(1,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(1,1))->insertItem(tr2i18n(tr2i18n("yes")));
  ((QComboBox *) tblFeatures->cellWidget(1,1))->insertItem("full");
  tblFeatures->setText(1,2, tr2i18n("enables debug symbols (yes|no|full) default=no"));
  tblFeatures->setText(2,0,"--disable-debug");
  tblFeatures->setCellWidget(2,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(2,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(2,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(2,2, tr2i18n("disables debug output and debug symbols default=no"));
  tblFeatures->setText(3,0,"--enable-strict");
  tblFeatures->setCellWidget(3,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(3,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(3,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(3,2, tr2i18n("compiles with strict compiler options (may not work!)"));
  tblFeatures->setText(4,0,"--disable-warnings");
  tblFeatures->setCellWidget(4,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(4,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(4,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(4,2, tr2i18n("disables compilation with -Wall and similiar"));
  tblFeatures->setText(5,0,"--enable-profile");
  tblFeatures->setCellWidget(5,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(5,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(5,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(5,2, tr2i18n("creates profiling infos default=no"));
  tblFeatures->setText(6,0,"--disable-dependency-tracking");
  tblFeatures->setCellWidget(6,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(6,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(6,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(6,2, tr2i18n("speeds up one-time build"));
  tblFeatures->setText(7,0,"--enable-dependency-tracking");
  tblFeatures->setCellWidget(7,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(7,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(7,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(7,2, tr2i18n("do not reject slow dependency extractors"));
  tblFeatures->setText(8,0,"--enable-pch");
  tblFeatures->setCellWidget(8,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(8,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(8,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(8,2, tr2i18n("enables precompiled header support (currently only KCC) default=no"));
  tblFeatures->setText(9,0,"--enable-final");
  tblFeatures->setCellWidget(9,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(9,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(9,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(9,2, tr2i18n("build size optimized apps (experimental - needs lots of memory)"));
  tblFeatures->setText(10,0,"--enable-closure");
  tblFeatures->setCellWidget(10,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(10,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(10,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(10,2, tr2i18n("delay template instantiation"));
  tblFeatures->setText(11,0,"--enable-nmcheck");
  tblFeatures->setCellWidget(11,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(11,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(11,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(11,2, tr2i18n("enable automatic namespace cleanness check"));
  tblFeatures->setText(12,0,"--enable-shared");
  tblFeatures->setCellWidget(12,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(12,1))->insertItem(tr2i18n(tr2i18n("yes")));
  ((QComboBox *) tblFeatures->cellWidget(12,1))->insertItem(tr2i18n(tr2i18n("no")));
  tblFeatures->setText(12,2, tr2i18n("build shared libraries [default=yes]"));
  tblFeatures->setText(13,0,"--enable-static");
  tblFeatures->setCellWidget(13,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(13,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(13,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(13,2, tr2i18n("build static libraries [default=no]"));
  tblFeatures->setText(14,0,"--enable-libsuffix");
  tblFeatures->setCellWidget(14,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(14,1))->insertItem("");
  ((QComboBox *) tblFeatures->cellWidget(14,1))->insertItem("64");
  ((QComboBox *) tblFeatures->cellWidget(14,1))->insertItem("32");
  tblFeatures->setText(14,2, tr2i18n("/lib directory suffix (64,32,none=default)"));
  tblFeatures->setText(15,0,"--enable-fast-install");
  tblFeatures->setCellWidget(15,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(15,1))->insertItem(tr2i18n(tr2i18n("yes")));
  ((QComboBox *) tblFeatures->cellWidget(15,1))->insertItem(tr2i18n(tr2i18n("no")));
  tblFeatures->setText(15,2, tr2i18n("optimize for fast installation [default=yes]"));
  tblFeatures->setText(16,0,"--disable-libtool-lock");
  tblFeatures->setCellWidget(16,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(16,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(16,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(16,2, tr2i18n("avoid locking (might break parallel builds)"));
  tblFeatures->setText(17,0,"--enable-embedded");
  tblFeatures->setCellWidget(17,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(17,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(17,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(17,2, tr2i18n("link to Qt-embedded, don't use X"));
  tblFeatures->setText(18,0,"--enable-qtopia");
  tblFeatures->setCellWidget(18,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(18,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(18,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(18,2, tr2i18n("link to Qt-embedded, link to the Qtopia Environment"));
  tblFeatures->setText(19,0,"--enable-mac");
  tblFeatures->setCellWidget(19,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(19,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(19,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(19,2, tr2i18n("link to Qt/Mac (don't use X)"));
  tblFeatures->setText(20,0,"--disable-mt");
  tblFeatures->setCellWidget(20,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(20,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(20,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(20,2, tr2i18n("link to non-threaded Qt (deprecated)"));
  tblFeatures->setText(21,0,"--disable-threading");
  tblFeatures->setCellWidget(21,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(21,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(21,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(21,2, tr2i18n("disables threading even if libpthread found"));
  tblFeatures->setText(22,0,"--disable-rpath");
  tblFeatures->setCellWidget(22,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(22,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(22,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(22,2, tr2i18n("do not use the rpath feature of ld"));
  tblFeatures->setText(23,0,"--disable-path-check");
  tblFeatures->setCellWidget(23,1,new QComboBox());
  ((QComboBox *) tblFeatures->cellWidget(23,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblFeatures->cellWidget(23,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblFeatures->setText(23,2, tr2i18n("don't try to find out, where to install"));
  tblFeatures->adjustColumn(0);
  tblFeatures->adjustColumn(1);
  tblFeatures->adjustColumn(2);

  tblPackages->setText(0,0,"--with-gnu-ld");
  tblPackages->setCellWidget(0,1,new QComboBox());
  ((QComboBox *) tblPackages->cellWidget(0,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblPackages->cellWidget(0,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblPackages->setText(0,2, tr2i18n("assume the C compiler uses GNU ld [default=no]"));
  tblPackages->setText(1,0,"--with-pic");
  tblPackages->setCellWidget(1,1,new QComboBox());
  ((QComboBox *) tblPackages->cellWidget(1,1))->insertItem(tr2i18n(tr2i18n("no")));
  ((QComboBox *) tblPackages->cellWidget(1,1))->insertItem(tr2i18n(tr2i18n("yes")));
  tblPackages->setText(1,2, tr2i18n("try to use only PIC/non-PIC objects [default=no]"));
  tblPackages->setText(2,0,"--with-tags");
  tblPackages->setText(2,2, tr2i18n("include additional configurations [automatic]"));
  tblPackages->setText(3,0,"--with-extra-includes");
  tblPackages->setText(3,2, tr2i18n("adds non standard include paths"));
  tblPackages->setText(4,0,"--with-extra-libs");
  tblPackages->setText(4,2, tr2i18n("adds non standard library paths"));
  tblPackages->setText(5,0,"--with-qt-dir");
  tblPackages->setText(5,2, tr2i18n("where the root of Qt is installed"));
  tblPackages->setText(6,0,"--with-qt-includes");
  tblPackages->setText(6,2, tr2i18n("where the Qt includes are."));
  tblPackages->setText(7,0,"--with-qt-libraries");
  tblPackages->setText(7,2, tr2i18n("where the Qt library is installed."));
  tblPackages->setText(8,0,"--without-arts");
  tblPackages->setCellWidget(8,1,new QComboBox());
  ((QComboBox *) tblPackages->cellWidget(8,1))->insertItem(tr2i18n(tr2i18n("yes")));
  ((QComboBox *) tblPackages->cellWidget(8,1))->insertItem(tr2i18n(tr2i18n("no")));
  tblPackages->setText(8,2, tr2i18n("build without aRts default=yes"));
  tblPackages->adjustColumn(0);
  tblPackages->adjustColumn(1);
  tblPackages->adjustColumn(2);
}

void KompileProfileWidget::chkBuilding_toggled(bool toggle)
{
  tabBuilding->setEnabled(toggle);
}

KConfig * KompileProfileWidget::getProfile()
{
  KConfig * profile;
  if (txtName->text().isEmpty())
  {
    profile = new KConfig(locateLocal("appdata", "") + "/default-profile.komprof");
    profile->writeEntry( "installed", "false" );
  }
  else
  {
    QString profile_file(locateLocal("appdata", "") + "/" + txtName->text());
    if (!txtVersion->text().stripWhiteSpace().isEmpty())
      profile_file.append("-" + txtVersion->text());
    if (!txtRelease->text().stripWhiteSpace().isEmpty())
      profile_file.append("-" + txtRelease->text());

    profile_file.append(".komprof");

    profile = new KConfig(profile_file);
  }

  // General
  profile->writeEntry("name", txtName->text());
  profile->writeEntry("version", txtVersion->text());
  profile->writeEntry("release", txtRelease->text());
  profile->writeEntry("license", cmbLicense->currentText());
  profile->writeEntry("description", txtDescription->text());
  profile->writeEntry("tarball", txtTarballDir->text());

  if (chkArchiveTarball->isChecked())
    profile->writeEntry("archive_tarball", "true");
  else
    profile->writeEntry("archive_tarball", "false");

  // Decompression
  profile->writeEntry("use_decompression_user_dir", rbUserDir->isChecked());
  profile->writeEntry("decompression_user_dir", txtDecompressionDir->text());
  profile->writeEntry("remove_decompression_user_dir", chkRemoveUserDir->isChecked());

  // Configuration
  switchToExpertMode();
  QStringList * options = new QStringList();
  for (int row = 0; row < tblDirectories->numRows(); row++)
  {
    if (!tblDirectories->text(row, 1).stripWhiteSpace().isEmpty())
      options->append(tblDirectories->text(row, 0) + "=" + tblDirectories->text(row, 1).stripWhiteSpace());
  }

  for (int row = 0; row < tblProgram->numRows(); row++)
  {
    if (!tblProgram->text(row, 1).stripWhiteSpace().isEmpty())
      options->append(tblProgram->text(row, 0) + "=" + tblProgram->text(row, 1).stripWhiteSpace());
  }

  for (int row = 0; row < tblFeatures->numRows(); row++)
  {
    if (((QComboBox *) tblFeatures->cellWidget(row, 1))->currentText() == tr2i18n("yes"))
      options->append(tblFeatures->text(row, 0));
  }

  for (int row = 0; row < tblPackages->numRows(); row++)
  {
    if (row == 0 || row == 1 || row == 8)
    {
      if (((QComboBox *) tblPackages->cellWidget(row, 1))->currentText() == tr2i18n("yes"))
        options->append(tblPackages->text(row, 0));
    }
    else
    {
      if (!tblPackages->text(row, 1).stripWhiteSpace().isEmpty())
        options->append(tblPackages->text(row, 0) + "=" + tblPackages->text(row, 1).stripWhiteSpace());
    }
  }

  profile->writeEntry("configuration_options", options->join(" "));
  delete options;

  // Building
  profile->writeEntry("CPP", txtCPP->text().stripWhiteSpace());
  profile->writeEntry("CC", txtCC->text().stripWhiteSpace());
  profile->writeEntry("CFLAGS", txtCFLAGS->text().stripWhiteSpace());
  profile->writeEntry("CXXCPP", txtCXXCPP->text().stripWhiteSpace());
  profile->writeEntry("CXX", txtCXX->text().stripWhiteSpace());
  profile->writeEntry("CXXFLAGS", txtCXXFLAGS->text().stripWhiteSpace());
  profile->writeEntry("CPPFLAGS", txtCPPFLAGS->text().stripWhiteSpace());
  profile->writeEntry("FF", txtFF->text().stripWhiteSpace());
  profile->writeEntry("FFLAGS", txtFFLAGS->text().stripWhiteSpace());
  profile->writeEntry("LDFLAGS", txtLDFLAGS->text().stripWhiteSpace());

  // Installing
  profile->writeEntry("do_not_install", chkNoInstall->isChecked());
  profile->writeEntry("use_checkinstall", gbCheckinstall->isChecked());
  profile->writeEntry("checkinstall_path", txtCheckinstallDir->text());
  QString packages_type[3] = {"debian", "rpm", "slackware"};
  profile->writeEntry("checkinstall_package_type", packages_type[bgCheckinstallPackage->selectedId()]);
  profile->writeEntry("simple_user_install_path", txtCheckinstallDir->text());
  QString user_install_mode[3] = {"su", "ask", "dir"};
  profile->writeEntry("simple_user_install_mode", user_install_mode[bgUserChoice->selectedId()]);

  return profile;
}

QString KompileProfileWidget::getProfileFile()
{
  if (txtName->text().isEmpty())
  {
    return ("default-profile");
  }

  QString profile_name(txtName->text());

  if (!txtVersion->text().stripWhiteSpace().isEmpty())
    profile_name.append("-" + txtVersion->text());

  if (!txtRelease->text().stripWhiteSpace().isEmpty())
    profile_name.append("-" + txtRelease->text());

  return profile_name;
}

bool KompileProfileWidget::saveProfile()
{
  if (txtName->text().stripWhiteSpace().isEmpty())
  {
    KMessageBox::error(this, tr2i18n("Actual profile doesn't has name.\n Unable to save unknow profile"), tr2i18n("Profile name not found"));
    return false;
  }

  KConfig * profile = getProfile();
  profile->sync();
  delete profile;
  return true;
}

bool KompileProfileWidget::saveDefaultProfile()
{
  KConfig * profile = getProfile();
  profile->sync();
  delete profile;
  return true;
}

void KompileProfileWidget::loadProfile()
{
  KDialogBase * load_profile = new KDialogBase(this, "LoadProfile", TRUE, tr2i18n("Select existing profile"), KDialogBase::Ok|KDialogBase::Cancel);

  KompileProfileSelectionWidget * wgt = new KompileProfileSelectionWidget(load_profile);
  load_profile->setMainWidget(wgt);
  load_profile->adjustSize();
  if (load_profile->exec() == QDialog::Accepted)
    loadProfile(wgt->selectedProfile());

  delete wgt;
  delete load_profile;
}

void KompileProfileWidget::loadProfile(QString& profile_name)
{
  KConfig * profile = new KConfig(locateLocal("appdata", "") + "/" + profile_name + ".komprof");

  // General
  if (profile_name.compare("default-profile") != 0)
  {
    txtName->setText(profile->readEntry("name", ""));
    txtVersion->setText(profile->readEntry("version", ""));
    txtRelease->setText(profile->readEntry("release", ""));
    cmbLicense->setCurrentText(profile->readEntry("license", ""));
    txtDescription->setText(profile->readEntry("description", ""));
    txtTarballDir->setText(profile->readEntry("tarball", ""));

    if (profile->readEntry("installed", "false") == "true")
      lblPackageState->setText("<font color=#66AA66>" + tr2i18n("Package is installed") + "</font>");
    else
      lblPackageState->setText("<font color=#6666AA>" + tr2i18n("Package isn't installed") + "</font>");

    lblPackageState->show();
  }
  else
  {
    txtTarballDir->setEnabled(FALSE);
    cmbLicense->setEnabled(FALSE);
    txtDescription->setEnabled(FALSE);
    btnBrowseTarball->setEnabled(FALSE);
  }

  if (profile->readEntry("archive_tarball", "false") == "true")
  {
    chkArchiveTarball->setChecked(TRUE);
  }



  // Decompression
  rbUserDir->setChecked(profile->readEntry("use_decompression_user_dir", "false") == "true");
  txtDecompressionDir->setText(profile->readEntry("decompression_user_dir", "/tmp/kompile-tmp/"));
  chkRemoveUserDir->setChecked(profile->readEntry("remove_decompression_user_dir", "true") == "true");


  // Configuration
  switchToExpertMode();
  QStringList options = QStringList::split(" ", profile->readEntry("configuration_options", "").stripWhiteSpace());

  for (int row = 0; row < tblDirectories->numRows(); row++)
  {
    QStringList element = options.grep(tblDirectories->text(row, 0));

    if (!element.isEmpty())
    {
      int founded_at = options.findIndex(element[0]);
      QStringList option = QStringList::split("=", element[0]);
      tblDirectories->setText(row, 1, option[1]);
      options.remove(options.at(founded_at));
    }

  }

  for (int row = 0; row < tblProgram->numRows(); row++)
  {
    QStringList element = options.grep(tblProgram->text(row, 0));

    if (!element.isEmpty())
    {
      int founded_at = options.findIndex(element[0]);
      QStringList option = QStringList::split("=", element[0]);
      tblProgram->setText(row, 1, option[1]);
      options.remove(options.at(founded_at));
    }
  }

  for (int row = 0; row < tblFeatures->numRows(); row++)
  {
    QStringList element = options.grep(tblFeatures->text(row, 0));

    if (!element.isEmpty())
    {
      int founded_at = options.findIndex(element[0]);
      ((QComboBox *) tblFeatures->cellWidget(row, 1))->setCurrentText(tr2i18n(tr2i18n("yes")));
      options.remove(options.at(founded_at));
    }
  }

  for (int row = 0; row < tblPackages->numRows(); row++)
  {
    QStringList element = options.grep(tblPackages->text(row, 0));

    if (!element.isEmpty())
    {
      if (row == 0 || row == 1 || row == 8)
      {
        int founded_at = options.findIndex(element[0]);
        ((QComboBox *) tblPackages->cellWidget(row, 1))->setCurrentText(tr2i18n(tr2i18n("yes")));
        options.remove(options.at(founded_at));
      }
      else
      {
        int founded_at = options.findIndex(element[0]);
        QStringList option = QStringList::split("=", element[0]);
        tblPackages->setText(row, 1, option[1]);
        options.remove(options.at(founded_at));
      }
    }
  }

  switchToNormalMode();

  // Building
  txtCPP->setText(profile->readEntry("CPP", ""));
  txtCC->setText(profile->readEntry("CC", ""));
  txtCFLAGS->setText(profile->readEntry("CFLAGS", ""));
  txtCXXCPP->setText(profile->readEntry("CXXCPP", ""));
  txtCXX->setText(profile->readEntry("CXX", ""));
  txtCXXFLAGS->setText(profile->readEntry("CXXFLAGS", ""));
  txtCPPFLAGS->setText(profile->readEntry("CPPFLAGS", ""));
  txtFF->setText(profile->readEntry("FF", ""));
  txtFFLAGS->setText(profile->readEntry("FFLAGS", ""));
  txtLDFLAGS->setText(profile->readEntry("LDFLAGS", ""));

  // Installing
  chkNoInstall->setChecked(profile->readEntry("do_not_install", "false") == "true");
  gbCheckinstall->setChecked(profile->readEntry("use_checkinstall", "false") == "true");
  txtCheckinstallDir->setText(profile->readEntry("checkinstall_path", ""));


  QString package_type = profile->readEntry("checkinstall_package_type", "debian");
  if (package_type == "rpm")
    bgCheckinstallPackage->setButton(1);
  else if (package_type == "slackware")
    bgCheckinstallPackage->setButton(2);
  else
    bgCheckinstallPackage->setButton(0);

  txtSimpleInstallationDir->setText(profile->readEntry("simple_user_install_path", ""));
  QString user_install_mode = profile->readEntry("simple_user_install_mode", "su");

  if (user_install_mode == "ask")
    bgUserChoice->setButton(1);
  else if (user_install_mode == "dir")
    bgUserChoice->setButton(2);
  else
    bgUserChoice->setButton(0);

  delete profile;

}

void KompileProfileWidget::btnCC_clicked()
{
  QString bin = KFileDialog::getOpenFileName(KStandardDirs::findExe("gcc","/usr/bin/",FALSE), "gcc|" + tr2i18n("GNU C Compiler executable"), this, tr2i18n("Select GNU C Compiler Executable"));

  if (bin)
    txtCC->setText(bin);
}

void KompileProfileWidget::btnCXX_clicked()
{
  QString bin = KFileDialog::getOpenFileName(KStandardDirs::findExe("g++","/usr/bin/",FALSE), "g++|" + tr2i18n("GNU C++ Compiler executable"), this, tr2i18n("Select GNU C++ Compiler Executable"));

  if (bin)
    txtCXX->setText(bin);
}

void KompileProfileWidget::btnFF_clicked()
{
  QString bin = KFileDialog::getOpenFileName(KStandardDirs::findExe("gfortran","/usr/bin/",FALSE), "gfortran|" + tr2i18n("GNU Fortran Compiler executable"), this, tr2i18n("Select GNU Fortran Compiler Executable"));

  if (bin)
    txtFF->setText(bin);
}

void KompileProfileWidget::bgUserChoice_clicked(int)
{
  gbDirectory->setEnabled(bgUserChoice->selectedId() == 2);
}

void KompileProfileWidget::btnBrowseUserInstallDir_clicked()
{
  KURL path_url = KDirSelectDialog::selectDirectory(txtSimpleInstallationDir->text());

  if (path_url.path().length() > 0)
    txtSimpleInstallationDir->setText(path_url.path());
}

void KompileProfileWidget::btnLoadDefault_clicked()
{
  QString def("default-profile" );
  loadProfile( def );
}

void KompileProfileWidget::btnBrowseCheckinstallDir_clicked()
{
  QString bin = KFileDialog::getOpenFileName(KStandardDirs::findExe("checkinstall","/usr/local/sbin/",FALSE), "checkinstall|" + tr2i18n("Checkinstall executable"), this, tr2i18n("Select Checkinstall Executable"));

  if (bin)
    txtCheckinstallDir->setText(bin);
}

void KompileProfileWidget::txtDecompressionDir_lostFocus()
{
  if (!txtDecompressionDir->text().endsWith("/"))
    txtDecompressionDir->setText(txtDecompressionDir->text() + "/");
}










#include "kompileprofilewidget.moc"
