/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kstandarddirs.h>

#include <qtable.h>
#include <qdir.h>


#include "kompileprofileselectionwidget.h"

KompileProfileSelectionWidget::KompileProfileSelectionWidget(QWidget *parent, const char *name)
    :KompileProfileSelectionWidgetBase(parent, name)
{
  selected = "";
  QDir * dir =  new QDir(locateLocal("appdata", ""));
  QStringList profiles = dir->entryList("*.komprof");
  delete dir;
  tblProfiles->setLeftMargin(0);
  tblProfiles->setNumRows(profiles.count() - 1);
  tblProfiles->setReadOnly(TRUE);
  int row = 0;

  for ( QStringList::Iterator profile = profiles.begin(); profile != profiles.end(); ++profile )
  {
    QStringList tokens = QStringList::split(".komprof", *profile);
    QStringList app = QStringList::split("-", tokens[0]);

    if (app[0] == "default")
      continue;

    tblProfiles->setText(row, 0, app[0]);

    if (app.count() > 1)
      tblProfiles->setText(row, 1, app[1]);

    if (app.count() > 2)
      tblProfiles->setText(row, 2, app[2]);

    row++;
  }

  if (tblProfiles->numRows() > 0)
    tblProfiles->selectRow(0);

  adjustSize();
}

QString& KompileProfileSelectionWidget::selectedProfile()
{
  return selected;
}

void KompileProfileSelectionWidget::tblProfiles_selectionChanged()
{
  selected = tblProfiles->text(tblProfiles->selection(0).topRow(), 0);

  if (!tblProfiles->text(tblProfiles->selection(0).topRow(), 1).isEmpty())
    selected.append("-" + tblProfiles->text(tblProfiles->selection(0).topRow(), 1));

  if (!tblProfiles->text(tblProfiles->selection(0).topRow(), 2).isEmpty())
    selected.append("-" + tblProfiles->text(tblProfiles->selection(0).topRow(), 2));
}



#include "kompileprofileselectionwidget.moc"
