/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QGridLayout>
#include <QToolButton>

#include "itemview.h"

ItemView::ItemView( QWidget *parent )
  : QWidget( parent )
{
  QGridLayout *layout = new QGridLayout( this );
  layout->setMargin( 0 );
  layout->setSpacing( 0 );

  mListView = new QListView( this );
  layout->addWidget( mListView, 0, 0, 3, 1 );

  QToolButton *addButton = new QToolButton( this );
  addButton->setFixedSize( 25, 25 );
  addButton->setText( "+" );
  layout->addWidget( addButton, 0, 1 );

  mRemoveButton = new QToolButton( this );
  mRemoveButton->setFixedSize( 25, 25 );
  mRemoveButton->setText( "-" );
  layout->addWidget( mRemoveButton, 1, 1 );

  connect( addButton, SIGNAL( clicked() ), this, SLOT( add() ) );
  connect( mRemoveButton, SIGNAL( clicked() ), this, SLOT( remove() ) );

  setSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum );
  setMinimumHeight( 150 );
}

void ItemView::setModel( QAbstractItemModel *model )
{
  mListView->setModel( model );
  connect( model, SIGNAL( rowsInserted( const QModelIndex&, int, int ) ), this, SLOT( viewUpdated() ) );
  connect( model, SIGNAL( rowsRemoved( const QModelIndex&, int, int ) ), this, SLOT( viewUpdated() ) );
  connect( model, SIGNAL( dataChanged( const QModelIndex&, const QModelIndex& ) ), this, SLOT( viewUpdated() ) );
  connect( model, SIGNAL( layoutChanged() ), this, SLOT( viewUpdated() ) );

  viewUpdated();
}

QAbstractItemModel *ItemView::model() const
{
  return mListView->model();
}

void ItemView::add()
{
  doAdd();
}

void ItemView::remove()
{
  QItemSelectionModel *selectionModel = mListView->selectionModel();
  const QModelIndex currentIndex = selectionModel->currentIndex();

  if ( currentIndex.isValid() ) {
    mListView->model()->removeRow( currentIndex.row() );
  }
}

void ItemView::viewUpdated()
{
  if ( model()->rowCount() == 0 )
    mRemoveButton->setEnabled( false );
  else
    mRemoveButton->setEnabled( true );
}

void ItemView::doAdd()
{
}
