/***************************************************************************
                          board_base.h  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by The Knights Project
    email                : knights-general@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOARD_BASE_H
#define BOARD_BASE_H

#include <stdlib.h>
#include <qwidget.h>
#include "definitions.h"

/**
  *@author The Knights Project
  */

class resource;
class logic;

class board_base : public QWidget
{
	Q_OBJECT

	public: 
											board_base(QWidget *parent=0, const char *name=0, resource *Rsrc=0, logic *Lgc=0);
		virtual						~board_base();
		virtual void			drawMove( const ChessMove &chessMove, const bool &reverse=FALSE );
		virtual void			setPremovePositions( const int&, const int& );
		virtual void			redrawLights( void );

	public slots:
		virtual void 			resizeBoard( void );
		virtual void			redrawAll( void );
		virtual void			setPaused( const bool& );
		virtual void			setLocalArmy( const bool& );
		virtual void			drawPosition( const int& );
		virtual void			commit( void );
		void							flipBoard( void );

	signals:
		void							leftClick( int );
		void							rightClick( int );

	protected:
		resource					*myResource;
		logic							*myLogic;
		bool							paused;
		bool							localArmy;
		bool							flip;

	protected:
		inline bool				color( const int &rank, const int &file )
														{ return abs( ( rank % 2 ) - ( file % 2 ) ); }
};

#endif
