/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WIFISCANDIALOG_H
#define WIFISCANDIALOG_H

#include "wifiscan.h"
#include "knetdockif.h"
#include "wifinetdetailsdialog.h"

#include <qlabel.h>
#include <qlistview.h>
//#include <kwallet.h>

// class NetViewLabel : public QLabel
// {
// 	NetViewLabel();
// 
// private:
// 	QPixmap *pix;
// };

class NetListViewItem : public QListViewItem
{
public: 
	NetListViewItem(QListView * parent);
	void setIndex(int index);
	int getIndex() const;
private:
	int index_pos;
};

class WifiScanDialog : public WifiScan
{
  Q_OBJECT

public:
  WifiScanDialog(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~WifiScanDialog();
	void renderData(const WifiNetworkList& list);
	void clearData();
	void setDeviceName(const QString& dev_name);
public slots:
	void rescan();
	void details();
	void changeSelection(QListViewItem *);
	void wifiConnect();
	
signals:
	void refresh();


private:
	//KWallet::Wallet *m_wallet;
	QString dev_name;
	WifiNetworkList list;
	WifiNetDetailsDialog *wdetails;
};

#endif

