/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KNETDOCKIF_H
#define KNETDOCKIF_H

typedef unsigned long long __u64;

extern "C"{

#include <asm/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/sockios.h>

#include <arpa/inet.h>

#include <linux/netdevice.h>
#include <linux/rtnetlink.h>
#include <linux/wireless.h>
}

#include <qobject.h>

#include <qstring.h>
#include <qdict.h>


enum DEVTYPE {LOOP=0, PPP,  ETHER,  WIFI };
enum DEVSTATE { UP=0, NOLINK, DOWN };
enum DEVPRESENCE { NOTFOUND=0, PRESENT, CHECKING };

typedef struct IfStat
{
	Q_ULLONG bytes;
	Q_ULLONG bytes_in;
	Q_ULLONG bytes_out;
	Q_ULLONG speed;
	Q_ULLONG speed_in;
	Q_ULLONG speed_out;
};

typedef struct AddrStat
{
	QString ip;
	QString mask;
	QString mac;
	QString ptp;
};

typedef struct WiFiStat
{
	double signal_level;
	double noise_level;
	bool dbm;
	double link_qual;
	int bitrate;
	QString essid;
	QString ap;
	int mode;
	int txpow;
};

typedef struct WifiNetwork
{
	QString ap_mac;
	QString essid;
	QString protocol;
	QString mode;
	int channel;
	QString freq;
	bool encryption;
	int quality;
	QString level;
	QString bitrates;
	QString extra;
	QString full;
	int index_pos;
};

typedef QDict<WifiNetwork> WifiNetworkList;

/**
	@author Todor Gyumyushev <yodor@developer.bg>
*/
class KNetDockIf : public QObject
{
Q_OBJECT
public:
    KNetDockIf(QObject *parent = 0, const char *name = 0);

    ~KNetDockIf();

	IfStat total;
	IfStat oldstat;
	WiFiStat wstat;
	AddrStat addrstat;
	DEVTYPE devtype;
	DEVSTATE devstate;
	DEVPRESENCE devpresence;
	int iconstatus;
	QString if_name;
	net_device_stats stats;
	int port;
	QString mtu;
	bool useBPS;


	void initDevice(const QString& if_name);
};

typedef QDict<KNetDockIf> DeviceList;


#endif
