#ifndef rcsid
static const char rcsid[]="$Id: timersetup.cpp 80 2003-11-06 15:39:10Z ral $";
#endif

#include "timersetup.h"
#include "settings.h"
#include "qspinbox.h"

#define Inherited timersetupData

timersetup::timersetup( QWidget* parent, const char* name )
    : Inherited( parent, name )
{
    int time = GlobalSettings.ThreadPolltime();
    m_ThreadTimeoutEdit->setValue(time);
    m_ThreadTime = time;
    time = GlobalSettings.StatusPolltime();
    m_StatusTimeoutEdit->setValue(time);
    m_StatusTime = time;
}

timersetup::~timersetup()
{
}

int timersetup::Threadtime()
{
    return m_ThreadTime;
}

int timersetup::Statustime()
{
    return m_StatusTime;
}

void timersetup::statusTimeChanged(int value)
{
    m_StatusTime = value;
//    emit statusTime(m_StatusTime);
}

void timersetup::threadTimeChanged(int value)
{
    m_ThreadTime = value;
//    emit threadTime(m_ThreadTime);
}

void timersetup::threadTimeChanged(const QString&s)
{
    threadTimeChanged(s.toInt());
}

void timersetup::statusTimeChanged(const QString&s)
{
    statusTimeChanged(s.toInt());
}
