#ifndef __EDITSENTRY_H
#define __EDITSENTRY_H

#include <string>
#include <qstring.h>
#include <qwidget.h>
#include <qcombobox.h>
#include <qcheckbox.h>

class EditEntry
{
protected:
    QWidget*edit;
    QComboBox*list;
    QCheckBox*checkbox;
    std::string column_name;
    bool m_Displayonly;
    std::string old_value;
public:
    EditEntry(const QString&aName="",
            QWidget*aEdit = 0,
            QComboBox*aBox = 0,
            QCheckBox*aCheck = 0,
            bool aDisplayonly = false)
    {
        edit=aEdit;
        list=aBox;
        checkbox = aCheck;
        column_name=QT_TO_STL_STRING(aName);
        m_Displayonly = aDisplayonly;
        old_value = "";
    }
    EditEntry(const std::string&aName="",
            QWidget*aEdit = 0,
            QComboBox*aBox = 0,
            QCheckBox*aCheck = 0,
            bool aDisplayonly = false)
    {
        edit=aEdit;
        list=aBox;
        checkbox = aCheck;
        column_name=aName;
        m_Displayonly = aDisplayonly;
        old_value = "";
    }
    EditEntry(const EditEntry&old)
    {
        edit=old.edit;
        list=old.list;
        column_name=old.column_name;
        checkbox=old.checkbox;
        m_Displayonly = old.m_Displayonly;
        old_value = old.old_value;
    }
    virtual ~EditEntry(){};
    virtual void setEdit(QWidget*aedit){edit=aedit;}
    virtual void setList(QComboBox*alist){list=alist;}
    virtual void setName(const std::string&aName){column_name = aName;}
    virtual void setCheck(QCheckBox*aCheck){checkbox = aCheck;}
    virtual QWidget*getEdit(){return edit;}
    virtual QComboBox*getList(){return list;}
    virtual const std::string&getName()const{return column_name;}
    virtual QCheckBox*getCheck(){return checkbox;}
    virtual void setDisplayOnly(bool how){m_Displayonly=how;}
    virtual bool getDisplayOnly()const{return m_Displayonly;}
    virtual void setOldvalue(const std::string&aValue){old_value = aValue;}
    virtual const std::string&getOldValue(){return old_value;}
};

#endif
