/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditstate.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditorstate.h"

namespace KMF {
KMFRuleOptionEditState::KMFRuleOptionEditState(QObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditState::KMFRuleOptionEditState(QObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorState( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}

KMFRuleOptionEditState::~KMFRuleOptionEditState() {}

void KMFRuleOptionEditState::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditState::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const QString& KMFRuleOptionEditState::optionEditName() const {
	return *( new QString( i18n("State Option") ) );
}
const QString& KMFRuleOptionEditState::description() const {
	return *( new QString( i18n("This plugin manages the State options for iptables rules.") ) );
}

void KMFRuleOptionEditState::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditState::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleOptionEditState::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditState::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}


// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditStateFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditStateFactory::s_about = 0L;

KMFRuleOptionEditStateFactory::KMFRuleOptionEditStateFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditStateFactory" );
}

QObject* KMFRuleOptionEditStateFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleOptionEditState( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditStateFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditStateFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_state() {
		return new KMFRuleOptionEditStateFactory;
	}
}

}


#include "kmfruleoptioneditstate.moc"
