/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GSMDATACONTAINER_H
#define GSMDATACONTAINER_H

#include <qobject.h>
#include <kabc/addressbook.h>
#include <kabc/stdaddressbook.h> 

#include "device.h"
#include "c_sms.h"
#include "c_smslist.h"
#include "c_config.h"

/**
@author Marco Gulino
*/
class GsmDataContainer : public QObject
{
Q_OBJECT
public:
    GsmDataContainer(QObject *parent = 0, const char *name = 0);
    ~GsmDataContainer();
	
	// Get Variables
	int  getCharging() { return i_charging; }
	int  getSignal()   { return i_signal; }
	int  getCharge()   { return i_battery; }
	bool getCalling()  { return b_calling; }
	KABC::AddressBook* getAddressBook() { return addressbook; }

protected:
	KABC::AddressBook* addressbook;
	c_SMSList* smsList;
	int i_battery, i_signal, i_charging;
	bool b_calling;
};

class GsmInterfaceSkeleton
{
public:
	GsmInterfaceSkeleton(QObject *parent = 0, const char *name = 0);
	~GsmInterfaceSkeleton();

protected:
};

#endif
