/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras*
 *   sngeorgaras@otenet.gr *
 * *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or *
 *   (at your option) any later version.   *
 * *
 *   This program is distributed in the hope that it will be useful,   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of*
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the *
 *   GNU General Public License for more details.  *
 * *
 *   You should have received a copy of the GNU General Public License *
 *   along with this program; if not, write to the *
 *   Free Software Foundation, Inc.,   *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 ***************************************************************************/

#ifndef _KMHTCONVERT_H_
#define _KMHTCONVERT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qlayout.h>
#include <qlabel.h>
#include <qrect.h>
#include <qtimer.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qkeysequence.h>
#include <qtooltip.h>

#include <kglobalsettings.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <kpushbutton.h>
#include <klineedit.h> 
#include <kpushbutton.h> 
#include <kcombobox.h>
#include <kconfig.h>
#include <stdlib.h>

#include "iconload.h"

//extern QString fName;
//exrtern KAboutData* ab;

class QGroupBox;
class KLineEdit;
class KPushButton;
class KListBox;
class KHistoryCombo;
class QListBoxItem;
class KPushButton;
class QCheckBox;

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QLabel;

class KConfig;

class iconload;

//class QProgressBar;
/**
 * @short Application Main Window
 * @author Spiros Georgaras <sngeorgaras@otenet.gr>
 * @version 0.1
 */
class kmhtConvert : public QWidget
{
Q_OBJECT
public:
	/**
	* Default Constructor
	*/
	kmhtConvert();
	kmhtConvert(QString dir, bool hInfo, bool hAttachments);
	void addMessageToList(int pixId, QString message);
	void enableConversion(bool convert){canConvert=convert;};
	/**
	* Default Destructor
	*/
	virtual ~kmhtConvert();
	iconload* ic;
    QGroupBox* groupBox1;
    KLineEdit* txtFile;
    KPushButton* cmbFile;
    QGroupBox* groupBox1_2;
    //KLineEdit* txtFolder;
		KHistoryCombo* txtFolder;
    KPushButton* cmbFolder;
    QGroupBox* groupMHT;
    QCheckBox* chkSave;
    QCheckBox* chkView;
		QCheckBox* chkLast;
    QLabel* textLabel2;
    KListBox* lstAction;
    KPushButton* cmbAbout;
    KPushButton* cmbOk;
    KPushButton* cmbCancel;
		QGroupBox* groupEML;
		QVBoxLayout* groupEMLLayout;
		QCheckBox* chkInfo;
		QCheckBox* chkAtt;
public slots:
	void slotFileOpened();
	void slotFilesInArchive(int num);
	void slotExtractingFile(QString file);
	void slotOutputFileCreated(QString file);
	void slotErrorAppeared(int err);
private slots:
	void exitForm();
	void convertIt();
	void getSaveFolder();
	void getArchive();
	void txtFolderChanged();
	void showAboutWindow();
	void chkSavestateChanged(int status);
	void chkViewstateChanged(int status);
	void calcCanConvert(int status);
	void setLastUsed(int status);
	void viewWar();
private:

    QVBoxLayout* Form1Layout;
    QHBoxLayout* groupBox1Layout;
    QVBoxLayout* groupBox1_2Layout;
    QHBoxLayout* layout2;
    QVBoxLayout* groupMHTLayout;
    QHBoxLayout* layout33;
    QSpacerItem* spacer1;
    QHBoxLayout* layout5;


	QString inputFile;
	QString lastInputFile;
	QString outputFolder;
	QString lastOutputFolder;
	QTimer counter;
	QLabel *lblCur;
	KProgress *prog;
	int delay;
	void loadIcons();
	void iconLoadError(QString str);
	QString defaultFolder();
	void findMode();
	int mode;
	//	0	no file specified
	//	1	mht -> war
	//	2	war -> mht
	bool canConvert;
	bool outputFileCreated;
	bool canExit;
	virtual void keyReleaseEvent ( QKeyEvent * e );
	bool justShowed;
	void saveLastState();
	void keyPressEvent( QKeyEvent *e );
	int lastState;
	int currentState;
};

#endif // _KMHTCONVERT_H_
