/***************************************************************************
                          passivepopupwidget.h -  Defines the passive
                          popups widget
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PASSIVEPOPUPWIDGET_H
#define PASSIVEPOPUPWIDGET_H

#include <kpassivepopup.h>



/**
  * @brief Passive popups widget
  *
  * This class inherits KPassivePopup to allow distinction between
  * clicks of left and right mouse buttons in the popup.
  *
  * @author Valerio Pilo <amroth@coldshock.net>
  */
class PassivePopupWidget : public KPassivePopup
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    PassivePopupWidget( QWidget *parent );
    // Class destructor
    ~PassivePopupWidget();

  signals:
    // Emitted when the user left-clicks on the popup balloon: triggers the popup's action
    void   leftClicked();
    // Emitted when the user right-clicks on the popup balloon: does nothing
    void   rightClicked();
    // Emitted when it's being destroyed, to remove this popup from the stack
    void dying();

  private: // Private methods
    // Handles mouse events for the balloon
    void   mouseReleaseEvent( QMouseEvent *e );

};

#endif
