/***************************************************************************
                          xmlfunctions.cpp -  description
                             -------------------
    begin                : Sun Jul 24 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlfunctions.h"
#include "../../kmessdebug.h"

#include <qstringlist.h>


// Helper function, get a specific node
QDomNode XmlFunctions::getNode( const QDomNode &rootNode, const QString &path )
{
#ifdef KMESSTEST
  ASSERT( ! rootNode.isNull() );
  ASSERT( ! path.isEmpty()    );
#endif

  QStringList pathItems = QStringList::split( "/", path, false );
  QDomNode    childNode = rootNode.namedItem( pathItems[0] );  // can be a null node

  uint i = 1;
  while( i < pathItems.count() )
  {
    if( childNode.isNull() )
    {
      break;
    }

    childNode = childNode.namedItem( pathItems[ i ] );
    i++;  // not using for loop so i is always correct for kdDebug() below.
  }

#ifdef KMESSDEBUG_XMLFUNCTIONS
  if( childNode.isNull() ) {
      kdDebug() << "XmlFunctions::getNode() - notice: node '" << pathItems[ i - 1 ] << "'"
                << " does not exist (root=" << rootNode.nodeName() << " path=" << path << ")." << endl;
  }
#endif

  return childNode;
}



// Helper function, get the attribute text of a node
QString XmlFunctions::getNodeAttribute( const QDomNode &node, const QString &attribute )
{
#ifdef KMESSTEST
  ASSERT( ! node.isNull()       );
  ASSERT( ! attribute.isEmpty() );
#endif

  // Writing this is not funny
  return node.attributes().namedItem( attribute ).toAttr().value();
// node.toElement().attribute( attribute );  does not work for const nodes.
}



// Helper function, get a specific child node
QDomNode XmlFunctions::getNodeChildByKey( const QDomNodeList &childNodes, const QString &keyTagName, const QString &keyValue )
{
#ifdef KMESSTEST
  ASSERT( ! keyTagName .isEmpty() );
  ASSERT( ! keyValue   .isEmpty() );
#endif

  for( uint i = 0; i < childNodes.count(); i++ )
  {
//    kdDebug() << "node " << childNodes.item(i).nodeName() << "/" << keyTagName
//              << "="     << childNodes.item(i).namedItem(keyTagName).toElement().text() << " == " << keyValue << "?" << endl;

      // If the node has an childname with a certain value... e.g. <childNodes> <item><name>value</name></item> .. </childNodes>
    if( childNodes.item( i ).namedItem( keyTagName ).toElement().text() == keyValue)
    {
        // Return the node
      return childNodes.item( i );
    }
  }
  
  // Return a null node (is there a better way?)
  return childNodes.item( childNodes.count() );
}



// Helper function, get the text value of a node
QString XmlFunctions::getNodeValue( const QDomNode &rootNode, const QString &path )
{
#ifdef KMESSTEST
  ASSERT( ! rootNode.isNull() );
  ASSERT( ! path.isEmpty()    );

  // Added code to avoid more assertion errors, and trace the cause.
  if( rootNode.isNull() )
  {
    kdWarning() << "XmlFunctions::getNodeValue: Attempted to request '" << path << "' on null root node." << endl;
    return QString::null;
  }
#endif

  // Because writing node.namedItem("childItem").namedItem("child2").toElement().text() is not funny.
  return getNode( rootNode, path ).toElement().text();
}


// Helper function, get the source XML of a node.
QString XmlFunctions::getSource( const QDomNode &node, int indent )
{
  QString source;
  QTextStream textStream( &source, IO_WriteOnly );
  node.save( textStream, indent );
  return source;
}

