/***************************************************************************
                          group.cpp  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "group.h"

#include <kapp.h>
#include <kconfig.h>
#include <kdebug.h>

#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "../specialgroups.h"

// The constructor
Group::Group(QString id, QString name)
 : id_(id),
   isExpanded_(true),
   name_(name),
   sortPosition_(0)
{
  // Only have test this once.
  isSpecialGroup_ = ( id_ == SpecialGroups::ONLINE      ) ||
                    ( id_ == SpecialGroups::OFFLINE     ) ||
                    ( id_ == SpecialGroups::ALLOWED     ) ||
                    ( id_ == SpecialGroups::REMOVED     ) ||
                    ( id_ == SpecialGroups::INDIVIDUALS );

  readProperties();
}



// The destructor
Group::~Group()
{
#ifdef KMESSDEBUG_GROUP
  kdDebug() << "DESTROYED Group [handle=" << name_ << ", id=" << id_ << "]" << endl;
#endif
}



// Return the group ID
const QString& Group::getId() const
{
  return id_;
}




// Return the group name
const QString& Group::getName() const
{
  return name_;
}



// Return the sort value
int Group::getSortPosition() const
{
  return sortPosition_;
}



// Return true if this group is expanded.
bool Group::isExpanded() const
{
  return isExpanded_;
}



// Return true if this is a special group
bool Group::isSpecialGroup() const
{
  return isSpecialGroup_;
}



// Read in group properties
void Group::readProperties()
{
  KConfig *config = kapp->config();

  if(! isSpecialGroup())
  {
    config->setGroup("Profile_" + CurrentAccount::instance()->getHandle());
    sortPosition_ = config->readNumEntry ( "group_" + id_ + "_sortPosition", 0 );
  }
  else
  {
    config->setGroup("Profile_GENERAL");
    sortPosition_ = 9999;  // Special groups have no sorting.
  }

  isExpanded_   = config->readBoolEntry( "group_" + id_ + "_isexpanded",   true );
}



// Save group properties
void Group::saveProperties(KConfig *config)
{
  if( CurrentAccount::instance()->isGuestAccount() )
  {
    kdWarning() << "ContactList: Request to save properties, but account is a temporary guest account!" << endl;
  }

  if(! isSpecialGroup())
  {
    config->setGroup("Profile_" + CurrentAccount::instance()->getHandle());
    config->writeEntry("group_" + id_ + "_sortPosition", sortPosition_);
  }
  else
  {
    config->setGroup("Profile_GENERAL");
    // Special groups have no sorting.
  }

  config->writeEntry("group_" + id_ + "_isexpanded",   isExpanded_);
}



// Change the group name
void Group::setName(const QString& newName)
{
#ifdef KMESSTEST
  ASSERT( newName != "" );
  ASSERT( ( id_ != SpecialGroups::ONLINE ) && ( id_ != SpecialGroups::OFFLINE ) && ( id_ != SpecialGroups::ALLOWED ) && ( id_ != SpecialGroups::REMOVED ) );
#endif

  if ( ( name_ != newName ) && ( newName != "" ) )
  {
    name_ = newName;
    emit nameChanged();
  }
}



// Change the sort position
void Group::setSortPosition(int sortPosition)
{
#ifdef KMESSDEBUG_GROUP
  kdDebug() << "Group " << name_ << " new sort position = " << sortPosition << endl;
#endif

  sortPosition_ = sortPosition;
  emit sortPositionChanged();
}



// Change the expanded state
void Group::setExpanded(bool expanded)
{
  isExpanded_ = expanded;
  emit expandedStateChanged();
}



#include "group.moc"
