/***************************************************************************
                          contactframe.h  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTFRAME_H
#define CONTACTFRAME_H

#include <qimage.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qdatetime.h>

#include "contactframeinterface.h"

// Forward declarations
class Contact;
class ContactBase;
class CurrentAccount;
class KAction;
class KActionMenu;
class KPopupMenu;

/**The frame displaying contact information.
  *@author Mike K. Bennett
  */

class ContactFrame : public ContactFrameInterface
{
  Q_OBJECT

  public:
    // The constructor
  	                 ContactFrame(QWidget *parent=0, const char *name=0);
    // The destructor
  	                ~ContactFrame();
    // Activate the frame by giving it a contact
    void             activate(ContactBase *contact);
    // Deactivate (grey-out) the frame when a contact leaves the chat
    void             deactivate();
    // Reactivate the frame when a contact rejoins the chat
    void             reactivate();
    // Return the handle of this frame's contact
    QString          getHandle() const;
    // Initialize the contact popup
    bool             initContactPopup();
    // Whether or not the frame has been activated
    bool             isActivated() const;
    // The user received a message from this contact
    void             messageReceived();
    // Receive notice that the contact is typing
    void             startTyping();

  private: // Private methods
    // Set whether or not the widgets are enabled or disabled
    void             enableWidgets(bool doEnable);
    // The personal status message received an event.
    bool             eventFilter( QObject *obj, QEvent *event );
    // Update all the widgets based on the given contact
    void             updateWidgets();

  private slots: // Private slots
    // Allow this contact to see our MSN status
    void             allowContact();
    // Copy some details of the contact to the clipboard
    void             copyText();
    // Email the contact
    void             sendEmail();
    // Update and show the contact popup menu
    void             showContactPopup( const QPoint &point );
    // Show the contact's profile
    void             showProfile();
    // Disable the typing label when the timer has timed out
    void             stopTyping();
    // Change the contact's added/removed status
    void             toggleContactAdded();
    // Change the contact's blocked/unblocked status
    void             toggleContactBlocked();
    // Update the contact picture
    void             updatePicture();
    // Update the status widgets
    void             updateStatusWidgets();

  private: // Private attributes
    // Whether or not the frame has been activated
    bool             activated_;
    // The contact whom the frame represents
    ContactBase     *contact_;
    // The menu of actions possible to perform on a given contact
    KPopupMenu      *contactActionPopup_;
    // The contact's image
    QPixmap          contactPicture_;
    // The contact picture date
    QDateTime        contactPictureDate_;
    // The contact picture file
    QString          contactPicturePath_;
    // The contact's image visible while the contact is typing
    QPixmap          contactTypingPicture_;
    // The defailed contact information, if available
    Contact         *detailedContact_;
    // The contact's handle, saved for performance and for safety
    QString          handle_;
    // Contact popup KAction to add the contact to the contact list
    KAction         *popupAddContact_;
    // Contact popup KAction to allow the contact to see the user's status
    KAction         *popupAllowContact_;
    // Contact popup KAction to block the contact
    KAction         *popupBlockContact_;
    // Contact popup menu to show the friendly name/personal message copying options
    KActionMenu     *popupCopyMenu_;
    // Contact popup KAction to copy the contact's friendly name to clipboard
    KAction         *popupCopyFriendlyName_;
    // Contact popup KAction to copy the contact's message to clipboard
    KAction         *popupCopyPersonalMessage_;
    // Contact popup KAction to copy the contact's email address to clipboard
    KAction         *popupCopyHandle_;
    // Contact popup KAction to send an email to the contact
    KAction         *popupEmailContact_;
    // Contact popup KAction to show the contact's profile
    KAction         *popupMsnProfile_;
    // Contact popup KAction to remove a contact from the contact list
    KAction         *popupRemoveContact_;
    // Contact popup KAction to unblock the contact
    KAction         *popupUnblockContact_;
    // A timer to time the duration that the typing label is shown
    QTimer           typingTimer_;

  signals:
    // The user wants to add or remove a contact.
    void               setContactAdded( QString handle, bool isAdded );
    // The user wants to allow a contact to see hi/hers online status.
    void               setContactAllowed( QString handle );
    // The user wants to block or unblock a contact.
    void               setContactBlocked( QString handle, bool isBlocked );
};

#endif
