/***************************************************************************
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _UPDATE_H_
#define _UPDATE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kdirlister.h> //stack allocated
#include <kurl.h>       //stack allocated
#include <kresolver.h> // namespace
#include <khtml_part.h>


namespace DOM {
  class Node;
}


using namespace KNetwork;

class KURL;
class KProcess;
class KURLRequester;
class KProgressDialog;
class KProcIO;
class KHTMLPart;

/**
 * This class serves as the main window for KlamavUpdate.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class KlamavUpdate : public QWidget
{
  Q_OBJECT

  public:

    KlamavUpdate(QWidget *parent = 0, const char *name=0);

    /**
     * Default Destrucclamav
     */
    virtual ~KlamavUpdate();
    void  downloadComponent(QString component, QString version, QString extension);
    void checkForNewClamAVDirectly();
    void checkForNewKlamAVDirectly();
    void checkForNewKlamAV();

signals:
    void getCurrentVersionOfClamAV( );
    void toggleUpgradeButtons(bool);


private slots:
    void slotProg();
    void klamavInstallationExited(KProcess *arkollonproc);
    void clamavInstallationExited(KProcess *arkollonproc);
/*    void resolved(KResolverResults result);*/
/*    void readVersionLine(KProcIO *);*/
    void parseSFPage();
    void parseSFPageHack();
    void updateCanceled();
/*    void versionExited();*/
private:
    void getLatestVersionFromSF(KURL url);
    void getLatestVersionFromSFHack(KURL url);
    void startProgressDialog( const QString & text );
    void checkInternet();
    void connectToHost();
    void getVersionFromLink( const DOM::Node &n );
    void completedSearchForUpdates(const QString &component, const QString &extension);
    double numericizeVersion(QString &version);
    QString getMirror();
    KProcess *childproc;
    KProcIO *versionproc;
    QString tempFileName;
    QString errorMessage;
    QString pidFileName;
    KProgressDialog *progressDialog;
    QTimer *timer;
    bool upgradeinprogress;
    bool checkingDirectly;
    double highestsofarnumeric;
    QString highestsofarraw;
    QString highestsofarfilename;
    KResolver m_resolver;
    QString currentClamavVersion;
    bool m_alpha;
    KHTMLPart *filelist;
private:
    KDirLister clamav_lister;
    KURL       clamav_url;
    KDirLister klamav_lister;
    KURL       klamav_url;
    KURL       m_url;

};

#endif // _KlamavUpdate_H_
