/***************************************************************************
                          kbswitchtrayicon.cpp  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdeversion.h>
 
#undef USE_BOLD_MENUITEM
 
#include "kbswitchtrayicon.h"
#include "xkeyboard.h"
#ifdef USE_BOLD_MENUITEM
  #include "boldmenuitem.h"
#endif  
#include <kpopupmenu.h>
#if KDE_VERSION_MAJOR >= 3
  #include <kstandarddirs.h>
#else  
  #include <kstddirs.h>
#endif  
#include <klocale.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kaboutapplication.h>
#if KDE_VERSION_MAJOR >= 3
  #include <kapplication.h>
#else
  #include <kapp.h>
#endif
#include <kiconloader.h>
#include <kdebug.h>
#include <kdeversion.h>
#include <qtooltip.h>
#include <qstyle.h>
#include <qpainter.h>

#ifdef USE_BOLD_MENUITEM
static QColor getActiveTextColor(KPopupMenu *menu)
{
	int id = menu->insertItem("test text");
	QMenuItem *item = menu->findItem(id);
	QStyleOption styleopt = QStyleOption(item);
	QPainter painter(menu);
	QColorGroup &cg = menu->colorGroup();
	KApplication::style().drawControl(QStyle::CE_PopupMenuItem, &painter, menu,
	  menu->contentsRect(), cg, QStyle::Style_Enabled | QStyle::Style_Active,
	  styleopt);
	menu->removeItem(id);
	return painter.pen().color();  
}
#endif

KBSwitchTrayIcon::KBSwitchTrayIcon(KBConfig *conf){
  QPixmap pix;
#if KDE_VERSION_MAJOR >= 3
  KActionCollection *actions = new KActionCollection(this);
  #define ACTION_PARENT actions
#else
  #define ACTION_PARENT this
#endif

  m_kbconf = conf;
  //QObject::connect(conf, SIGNAL(changed()), this, SLOT(updateMenuIcons()));
  KPopupMenu * menu = contextMenu();
  addLayoutItems(menu, false);
  QObject::connect(menu, SIGNAL(activated(int)), this, SLOT(slotMenuActivated(int)));

  menu->insertSeparator();
  KAction *pref = KStdAction::preferences(this, SIGNAL(preferencesSelected()), ACTION_PARENT);
  pref->plug(menu);
  KAction *help = KStdAction::help(this, SLOT(slotHelp()), ACTION_PARENT);
  help->plug(menu);
  KAction *about = KStdAction::aboutApp(this, SLOT(slotAbout()), ACTION_PARENT);
  about->plug(menu);

  /*QString path = locate("icon", "hicolor/16x16/apps/locale.png");
  if (!path.isEmpty()) pix.load(path);*/
  pix = kapp->iconLoader()->loadIcon("locale", KIcon::Small);
  menu->changeTitle(menu->idAt(0), pix, i18n("Keyboard Switch"));
  setAlignment(Qt::AlignHCenter | Qt::AlignCenter);
}

KBSwitchTrayIcon::~KBSwitchTrayIcon(){
}

/** No descriptions */
void KBSwitchTrayIcon::slotMenuActivated(int id){
  if (id >= 0 && id < m_kbconf->groupCount()) emit groupSelected(id);
}

/** No descriptions */
void KBSwitchTrayIcon::setActiveGroup(int groupno){
  int i;
  KPopupMenu *menu = contextMenu();
  for (i = 0; i < m_kbconf->groupCount(); i++)
    menu->setItemChecked(i, false);
  menu->setItemChecked(groupno, true);
}

/** No descriptions */
void KBSwitchTrayIcon::setToggleGroups(int group1, int group2){
  int i;
  bool toggling;
  KPopupMenu *menu = contextMenu();

  for (i = 0; i < m_kbconf->groupCount(); i++) {
    toggling = (i == group1 || i == group2);
#ifdef USE_BOLD_MENUITEM
		QMenuItem *item = menu->findItem(i);
		BoldMenuItem *bolditem = dynamic_cast<BoldMenuItem*>(item->custom());
		bolditem->setBold(toggling);
#else
    if (toggling)
      menu->changeItem(i, m_kbconf->getGroup(i)->getName() + "*");
    else menu->changeItem(i, m_kbconf->getGroup(i)->getName());
#endif
  }
}

/** No descriptions */
void KBSwitchTrayIcon::mouseReleaseEvent(QMouseEvent *event){
  if (event->button() == LeftButton) {
    emit clicked();
  }
}

/** No descriptions */
void KBSwitchTrayIcon::slotAbout(){
  KAboutApplication about;
  about.exec();
}

/** No descriptions */
void KBSwitchTrayIcon::updateMenuIcons(){
  KPopupMenu *menu = contextMenu();
  for (int i = 0; i < m_kbconf->groupCount(); i++) {
    menu->changeItem(i, m_kbconf->getGroup(i)->getPixmap(), menu->text(i));
  }
}

/** No descriptions */
void KBSwitchTrayIcon::addLayoutItems(KPopupMenu *menu, bool clearOld) {
  KBGroup *group;
  int index;
#ifdef USE_BOLD_MENUITEM
  QColor active_text_color = getActiveTextColor(menu);
#endif  

  if (clearOld)
    for (int i = 0; i < XKeyboard::MaxNumKbdGroups; i++)
      if ((index = menu->indexOf(i)) >= 0) menu->removeItemAt(index);

  for (int i = 0; i < m_kbconf->groupCount(); i++) {
    group = m_kbconf->getGroup(i);
#ifdef USE_BOLD_MENUITEM
    /* the work on BoldMenuItems suspended: see comments in boldmenuitem.h */
    menu->insertItem(group->getPixmap(),
      new BoldMenuItem(group->getName(), active_text_color, false), i);
#else    
    menu->insertItem(group->getPixmap(), group->getName(), i, i + 1);
#endif    
  }
}

/** No descriptions */
void KBSwitchTrayIcon::reconfigure(){
  addLayoutItems(contextMenu(), true);
}

/** Update the tray icon display for the given group */
void KBSwitchTrayIcon::updateTrayIcon(int groupno){
  const QPixmap& pix = m_kbconf->getGroup(groupno)->getPixmap();
  setPixmap(pix);
  setActiveGroup(groupno);
  QToolTip::remove(this);
  QToolTip::add(this, m_kbconf->getGroup(groupno)->getName());
}

/** Update menu and tray icons after configuration has changed */
void KBSwitchTrayIcon::slotUpdateIcons(){
  updateTrayIcon(XKeyboard::self()->getGroupNo());
  updateMenuIcons();
}

/** Display help */
void KBSwitchTrayIcon::slotHelp(){
  kapp->invokeHelp();
}
