/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KITTY_PREFS_H
#define KITTY_PREFS_H

#include <kdialogbase.h>
#include <qcheckbox.h>
#include <klineedit.h>
#include <kitty_globals.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <keditlistbox.h>

/**
@author KesieV
*/

class Kitty_prefs : public KDialogBase
{
Q_OBJECT
public:
    Kitty_prefs(QObject *parent = 0, const char *name = 0);

    ~Kitty_prefs();

	bool set_open_on_click;
	bool set_download_on_collect;
	QString set_server;
	QString set_trap_var;
	QString set_trap;
	QString set_url_var;

public slots:
	virtual void slotOk();
	void updateWidgets();
	void set_std();
	void set_html();
	void set_pub();
	void set_nopub();

public:
	QCheckBox *chk_open_on_click;
	QCheckBox *chk_download_on_collect;
	QCheckBox *chk_start_minimized;
	QCheckBox *chk_restart_partial;
	QCheckBox *chk_autosubmit_feed;
	QCheckBox *chk_pub_movies;
	QCheckBox *chk_pub_thumbs;
	QCheckBox *chk_publish_update_guide;
	KLineEdit *chk_trap_var;
	KLineEdit *chk_trap;
	KLineEdit *chk_url_var;
	KLineEdit *btclient;

	KLineEdit *pub_hostname;
	KLineEdit *pub_username;
	KLineEdit *pub_password;
	KLineEdit *pub_pub_hostname;
	QRadioButton *radio_pub;
	QRadioButton *radio_nopub;
	KEditListBox *editExtension;

	QRadioButton *radio_std;
	QRadioButton *radio_html;
	QComboBox *cmb_skin;
	t_settings localsettings;

};

#endif
